/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgModuleImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DbgListModulesCommand
extends AbstractDbgCommand<Map<String, DbgModule>> {
    protected final DbgProcessImpl process;
    private Map<String, DebugModule> updatedModules = new HashMap<String, DebugModule>();
    private Map<DebugModule, DebugModuleInfo> moduleInfo = new HashMap<DebugModule, DebugModuleInfo>();

    public DbgListModulesCommand(DbgManagerImpl manager, DbgProcessImpl process) {
        super(manager);
        this.process = process;
    }

    @Override
    public Map<String, DbgModule> complete(DbgPendingCommand<?> pending) {
        Map<String, DbgModule> modules = this.process.getKnownModules();
        Set<String> cur = modules.keySet();
        for (String id : this.updatedModules.keySet()) {
            if (cur.contains(id)) continue;
            Msg.warn((Object)this, (Object)("Resync: Was missing module: " + id));
            DebugModuleInfo info = this.moduleInfo.get(this.updatedModules.get(id));
            DbgModuleImpl module = new DbgModuleImpl(this.manager, this.process, info);
            module.add();
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedModules.containsKey(id)) continue;
            this.process.removeModule(id);
        }
        return this.process.getKnownModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke() {
        try {
            this.setProcess(this.process);
            DebugSymbols symbols = this.manager.getSymbols();
            for (DebugModule module : symbols.iterateModules(0)) {
                DebugModuleInfo info = symbols.getModuleParameters(1, module.getIndex());
                String imageName = "UNKNOWN";
                String moduleName = "UNKNOWN";
                try {
                    imageName = module.getName(DebugModule.DebugModuleName.IMAGE);
                    moduleName = module.getName(DebugModule.DebugModuleName.MODULE);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                info.setImageName(imageName);
                info.setModuleName(moduleName);
                this.updatedModules.put(info.toString(), module);
                this.moduleInfo.put(module, info);
            }
        }
        finally {
            this.resetProcess();
        }
    }
}

