/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.symbols;

import agent.dbgeng.dbgeng.DebugModule;
import agent.dbgeng.dbgeng.DebugSymbolEntry;
import agent.dbgeng.dbgeng.DebugSymbolId;
import agent.dbgeng.impl.dbgeng.DbgEngUtil;
import agent.dbgeng.impl.dbgeng.symbols.DebugModuleImpl;
import agent.dbgeng.impl.dbgeng.symbols.DebugSymbolsImpl2;
import agent.dbgeng.jna.dbgeng.DbgEngNative;
import agent.dbgeng.jna.dbgeng.symbols.IDebugSymbols3;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugSymbolsImpl3
extends DebugSymbolsImpl2 {
    private final IDebugSymbols3 jnaSymbols;

    public DebugSymbolsImpl3(IDebugSymbols3 jnaSymbols) {
        super(jnaSymbols);
        this.jnaSymbols = jnaSymbols;
    }

    @Override
    public int getCurrentScopeFrameIndex() {
        WinDef.ULONGByReference pulIndex = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetCurrentScopeFrameIndex(pulIndex));
        return pulIndex.getValue().intValue();
    }

    @Override
    public void setCurrentScopeFrameIndex(int index) {
        WinDef.ULONG ulIndex = new WinDef.ULONG((long)index);
        WinNT.HRESULT hr = this.jnaSymbols.SetCurrentScopeFrameIndex(ulIndex);
        COMUtils.checkRC((WinNT.HRESULT)hr);
    }

    @Override
    public DebugModule getModuleByModuleName(String name, int startIndex) {
        WinDef.ULONG ulStartIndex = new WinDef.ULONG((long)startIndex);
        WinDef.ULONGByReference pulIndex = new WinDef.ULONGByReference();
        WinDef.ULONGLONGByReference pullBase = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleByModuleNameWide(new WString(name), ulStartIndex, pulIndex, pullBase));
        return new DebugModuleImpl(this, pulIndex.getValue().intValue(), pullBase.getValue().longValue());
    }

    @Override
    public String getModuleName(DebugModule.DebugModuleName which, DebugModule module) {
        WinDef.ULONG ulWhich = new WinDef.ULONG((long)which.ordinal());
        WinDef.ULONGLONG ullBase = new WinDef.ULONGLONG(module.getBase());
        WinDef.ULONGByReference pulNameSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleNameStringWide(ulWhich, DbgEngUtil.DEBUG_ANY_ID, ullBase, null, new WinDef.ULONG(0L), pulNameSize));
        char[] aBuffer = new char[pulNameSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetModuleNameStringWide(ulWhich, DbgEngUtil.DEBUG_ANY_ID, ullBase, aBuffer, pulNameSize.getValue(), null));
        return Native.toString((char[])aBuffer);
    }

    @Override
    public List<DebugSymbolId> getSymbolIdsByName(String pattern) {
        WinDef.ULONGByReference pulEntries = new WinDef.ULONGByReference();
        WString wsPattern = new WString(pattern);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolEntriesByNameWide(wsPattern, new WinDef.ULONG(0L), null, new WinDef.ULONG(0L), pulEntries));
        if (pulEntries.getValue().intValue() == 0) {
            return Collections.emptyList();
        }
        DbgEngNative.DEBUG_MODULE_AND_ID[] aIds = (DbgEngNative.DEBUG_MODULE_AND_ID[])new DbgEngNative.DEBUG_MODULE_AND_ID().toArray(pulEntries.getValue().intValue());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolEntriesByNameWide(wsPattern, new WinDef.ULONG(0L), aIds, pulEntries.getValue(), null));
        ArrayList<DebugSymbolId> result = new ArrayList<DebugSymbolId>(aIds.length);
        for (int i = 0; i < aIds.length; ++i) {
            result.add(new DebugSymbolId(aIds[i].ModuleBase.longValue(), aIds[i].Id.longValue()));
        }
        return result;
    }

    @Override
    public DebugSymbolEntry getSymbolEntry(DebugSymbolId id) {
        DbgEngNative.DEBUG_MODULE_AND_ID sId = new DbgEngNative.DEBUG_MODULE_AND_ID();
        sId.ModuleBase = new WinDef.ULONGLONG(id.moduleBase);
        sId.Id = new WinDef.ULONGLONG(id.symbolIndex);
        DbgEngNative.DEBUG_SYMBOL_ENTRY.ByReference pInfo = new DbgEngNative.DEBUG_SYMBOL_ENTRY.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolEntryInformation(sId, pInfo));
        char[] aName = new char[pInfo.NameSize.intValue() + 1];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSymbols.GetSymbolEntryStringWide(sId, new WinDef.ULONG(0L), aName, new WinDef.ULONG((long)aName.length), null));
        return new DebugSymbolEntry(pInfo.ModuleBase.longValue(), pInfo.Offset.longValue(), pInfo.Id.longValue(), pInfo.Size.longValue(), pInfo.Flags.intValue(), pInfo.TypeId.intValue(), Native.toString((char[])aName), pInfo.Tag.intValue());
    }
}

