/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.gadp;

import agent.dbgeng.gadp.DbgEngGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.program.model.listing.Program;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="MS dbgeng.dll (WinDbg) via GADP", htmlDetails="Connect to the Microsoft Debug Engine.\nThis is the same engine that powers WinDbg.\nThis is best for most Windows userspace and kernel targets.\nKernel debugging is still experimental.\nThis will protect Ghidra's JVM by using a subprocess to access the native API.")
public class DbgEngGadpDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    protected String remote = "none";
    @ConfigurableFactory.FactoryOption(value="DebugConnect options (.server)")
    public final ConfigurableFactory.Property<String> agentRemoteOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentRemote, this::setAgentRemote);
    protected String transport = "none";
    @ConfigurableFactory.FactoryOption(value="Remote process server options (untested)")
    public final ConfigurableFactory.Property<String> agentTransportOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentTransport, this::setAgentTransport);

    public int getPriority(Program program) {
        String exe;
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            return -1;
        }
        if (program != null && ((exe = program.getExecutablePath()) == null || exe.isBlank())) {
            return -1;
        }
        return 60;
    }

    public String getAgentTransport() {
        return this.transport;
    }

    public void setAgentTransport(String transport) {
        this.transport = transport;
    }

    public String getAgentRemote() {
        return this.remote;
    }

    public void setAgentRemote(String remote) {
        this.remote = remote;
    }

    protected String getThreadName() {
        return "Local dbgeng.dll Agent stdout";
    }

    protected Class<?> getServerClass() {
        return DbgEngGadpServer.class;
    }

    protected void completeCommandLine(List<String> cmd) {
        cmd.add(this.getServerClass().getCanonicalName());
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
        if (!this.remote.equals("none") && !this.remote.equals("")) {
            cmd.addAll(List.of("-r", this.remote));
        }
        if (!this.transport.equals("none") && !this.transport.equals("")) {
            cmd.addAll(List.of("-t", this.transport));
        }
    }
}

