/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.io;

import java.io.IOException;
import java.io.Reader;

public class ConcatenatedReader
extends Reader {
    private final Reader[] sources;
    private int currentSource;
    private long charPos = 0L;

    public ConcatenatedReader(Reader[] sources) {
        this.sources = sources;
        this.currentSource = 0;
    }

    public void close() throws IOException {
        for (Reader r : this.sources) {
            r.close();
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int bytesRead = 0;
        while (bytesRead < len) {
            Reader currentReader = this.sources[this.currentSource];
            int currentRead = currentReader.read(cbuf, off + bytesRead, len - bytesRead);
            while (currentRead != -1 && bytesRead < len) {
                currentRead = currentReader.read(cbuf, off + (bytesRead += currentRead), len - bytesRead);
            }
            if (currentRead != -1) continue;
            if (this.currentSource + 1 >= this.sources.length) break;
            ++this.currentSource;
        }
        return bytesRead;
    }
}

