/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTMatchUtil;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.ChooseAddressSetEditorPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import util.CollectionUtils;

public class AddToSessionTask
extends Task {
    private final WizardState<VTWizardStateKey> state;
    private final VTController controller;

    public AddToSessionTask(VTController controller, WizardState<VTWizardStateKey> state) {
        super("Merge Version Tracking Session", true, true, true);
        this.controller = controller;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        VTSession session = null;
        session = this.controller.getSession();
        Program sourceProgram = session.getSourceProgram();
        Program destinationProgram = session.getDestinationProgram();
        Boolean value = (Boolean)this.state.get((Object)VTWizardStateKey.EXCLUDE_ACCEPTED_MATCHES);
        boolean excludeAcceptedMatches = value == null ? false : value;
        ChooseAddressSetEditorPanel.AddressSetChoice sourceAddressSetChoice = (ChooseAddressSetEditorPanel.AddressSetChoice)((Object)this.state.get((Object)VTWizardStateKey.SOURCE_ADDRESS_SET_CHOICE));
        ChooseAddressSetEditorPanel.AddressSetChoice destinationAddressSetChoice = (ChooseAddressSetEditorPanel.AddressSetChoice)((Object)this.state.get((Object)VTWizardStateKey.DESTINATION_ADDRESS_SET_CHOICE));
        if (sourceAddressSetChoice == null) {
            sourceAddressSetChoice = ChooseAddressSetEditorPanel.AddressSetChoice.ENTIRE_PROGRAM;
        }
        if (destinationAddressSetChoice == null) {
            destinationAddressSetChoice = ChooseAddressSetEditorPanel.AddressSetChoice.ENTIRE_PROGRAM;
        }
        Memory sourceAddressSet = switch (sourceAddressSetChoice) {
            case ChooseAddressSetEditorPanel.AddressSetChoice.SELECTION -> (AddressSetView)this.state.get((Object)VTWizardStateKey.SOURCE_SELECTION);
            case ChooseAddressSetEditorPanel.AddressSetChoice.MANUALLY_DEFINED -> (AddressSetView)this.state.get((Object)VTWizardStateKey.SOURCE_ADDRESS_SET_VIEW);
            default -> sourceProgram.getMemory();
        };
        Memory destinationAddressSet = switch (destinationAddressSetChoice) {
            case ChooseAddressSetEditorPanel.AddressSetChoice.SELECTION -> (AddressSetView)this.state.get((Object)VTWizardStateKey.DESTINATION_SELECTION);
            case ChooseAddressSetEditorPanel.AddressSetChoice.MANUALLY_DEFINED -> (AddressSetView)this.state.get((Object)VTWizardStateKey.DESTINATION_ADDRESS_SET_VIEW);
            default -> destinationProgram.getMemory();
        };
        if (excludeAcceptedMatches) {
            sourceAddressSet = this.excludeAcceptedMatches((AddressSetView)sourceAddressSet, true);
            destinationAddressSet = this.excludeAcceptedMatches((AddressSetView)destinationAddressSet, false);
        }
        PluginTool serviceProvider = this.controller.getTool();
        int transactionID = this.startTransaction(session);
        boolean completedSucessfully = false;
        try {
            session.setEventsEnabled(false);
            List<VTProgramCorrelatorFactory> correlatorFactories = this.getCorrelators(this.state);
            List<VTOptions> correlatorOptions = this.getCorrelatorOptions(this.state);
            ArrayList<VTProgramCorrelator> noMatchList = new ArrayList<VTProgramCorrelator>();
            for (int i = 0; i < correlatorFactories.size(); ++i) {
                VTProgramCorrelatorFactory factory = correlatorFactories.get(i);
                VTProgramCorrelator correlator = factory.createCorrelator((ServiceProvider)serviceProvider, sourceProgram, (AddressSetView)sourceAddressSet, destinationProgram, (AddressSetView)destinationAddressSet, correlatorOptions.get(i));
                VTMatchSet resultSet = correlator.correlate(session, monitor);
                if (resultSet.getMatchCount() != 0) continue;
                noMatchList.add(correlator);
            }
            if (!noMatchList.isEmpty()) {
                StringBuffer messageBuffer = new StringBuffer("No matches were found by the following program correlators: ");
                for (VTProgramCorrelator vtProgramCorrelator : noMatchList) {
                    messageBuffer.append("\n  " + vtProgramCorrelator.getName());
                }
                Msg.showInfo((Object)((Object)this), null, (String)"Version Tracking: Add To Session", (Object)messageBuffer.toString());
            }
            completedSucessfully = true;
        }
        catch (CancelledException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                Msg.showWarn((Object)((Object)this), null, (String)"Add to Session Cancelled", (Object)"Correlation canceled by user.");
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Add to Session Cancelled - Unexpected Exception", (Object)("Correlation cancelled due to exception: " + cause.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)"Add to Session Cancelled - Unexpected Exception", (Object)("Correlation cancelled due to exception: " + e.getMessage()), (Throwable)e);
        }
        finally {
            session.setEventsEnabled(true);
            this.endTransaction(session, transactionID, completedSucessfully);
        }
    }

    private void endTransaction(VTSession session, int transactionID, boolean completedSucessfully) {
        if (transactionID == -1) {
            return;
        }
        ((DomainObjectAdapterDB)session).endTransaction(transactionID, completedSucessfully);
    }

    private int startTransaction(VTSession session) {
        if (session instanceof DomainObjectAdapterDB) {
            return ((DomainObjectAdapterDB)session).startTransaction("Correlate");
        }
        return -1;
    }

    private List<VTOptions> getCorrelatorOptions(WizardState<VTWizardStateKey> stateKey) {
        return CollectionUtils.asList((List)((List)stateKey.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_OPTIONS_LIST)), VTOptions.class);
    }

    private List<VTProgramCorrelatorFactory> getCorrelators(WizardState<VTWizardStateKey> stateKey) {
        return CollectionUtils.asList((List)((List)stateKey.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST)), VTProgramCorrelatorFactory.class);
    }

    private AddressSet excludeAcceptedMatches(AddressSetView addrSetView, boolean source) {
        VTSession session = (VTSession)this.state.get((Object)VTWizardStateKey.EXISTING_SESSION);
        AddressSet addrSet = new AddressSet(addrSetView);
        if (session != null) {
            List<VTMatchSet> matchSets = session.getMatchSets();
            for (VTMatchSet vtMatchSet : matchSets) {
                Collection<VTMatch> matches = vtMatchSet.getMatches();
                for (VTMatch vtMatch : matches) {
                    VTAssociationStatus status = vtMatch.getAssociation().getStatus();
                    if (status != VTAssociationStatus.ACCEPTED) continue;
                    AddressSetView matchAddresses = VTMatchUtil.getMatchAddresses(vtMatch, source);
                    addrSet.delete(matchAddresses);
                }
            }
        }
        return addrSet;
    }
}

