/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

class ThreadUnsafeWeakSet<T>
extends WeakSet<T> {
    ThreadUnsafeWeakSet() {
    }

    @Override
    public void add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        this.weakHashStorage.put(t, null);
    }

    @Override
    public void remove(T t) {
        this.weakHashStorage.remove(t);
    }

    @Override
    public void clear() {
        this.weakHashStorage.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.weakHashStorage.keySet().iterator();
    }

    @Override
    public Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public boolean contains(T t) {
        return this.weakHashStorage.containsKey(t);
    }

    public String toString() {
        return this.weakHashStorage.toString();
    }

    @Override
    public Stream<T> stream() {
        return this.values().stream();
    }
}

