/*
 * Decompiled with CFR 0.152.
 */
package generic.test.rule;

import ghidra.util.Msg;
import java.util.Date;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatedStatement
extends Statement {
    private final Statement base;
    private final Description description;
    private final int count;

    public RepeatedStatement(Statement base, Description description, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("@Repeated count must be positive. To ignore a test. Use @Ignore");
        }
        this.base = base;
        this.description = description;
        this.count = count;
    }

    public void evaluate() throws Throwable {
        for (int i = 0; i < this.count; ++i) {
            if (this.count > 1) {
                Msg.debug((Object)((Object)this), (Object)(new Date() + "\n  *** REPETITION " + (i + 1) + "/" + this.count + " of " + this.description.getDisplayName() + " ***"));
            }
            this.base.evaluate();
        }
    }
}

