/*
 * Decompiled with CFR 0.152.
 */
package generic.json;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Json
extends ToStringStyle {
    public static final JsonWithNewlinesToStringStyle WITH_NEWLINES = new JsonWithNewlinesToStringStyle();

    public static String toString(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)WITH_NEWLINES);
    }

    public static String toString(Object o, String ... includFields) {
        InclusiveReflectionToStringBuilder builder = new InclusiveReflectionToStringBuilder(o);
        builder.setIncludeFieldNames(includFields);
        return builder.toString();
    }

    public static String toStringExclude(Object o, String ... excludedFields) {
        ReflectionToStringBuilder builder = new ReflectionToStringBuilder(o, (ToStringStyle)WITH_NEWLINES);
        builder.setExcludeFieldNames(excludedFields);
        return builder.toString();
    }

    public static class JsonWithNewlinesToStringStyle
    extends ToStringStyle {
        private JsonWithNewlinesToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{\n\t");
            this.setContentEnd("\n}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",\n\t");
            this.setFieldNameValueSeparator(": ");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }
    }

    private static class InclusiveReflectionToStringBuilder
    extends ReflectionToStringBuilder {
        private String[] includedNames;

        public InclusiveReflectionToStringBuilder(Object object) {
            super(object, (ToStringStyle)WITH_NEWLINES);
        }

        protected boolean accept(Field field) {
            if (!super.accept(field)) {
                return false;
            }
            return this.includedNames != null && Arrays.binarySearch(this.includedNames, field.getName()) >= 0;
        }

        public ReflectionToStringBuilder setIncludeFieldNames(String ... includeFieldNamesParam) {
            if (includeFieldNamesParam == null) {
                this.includedNames = null;
            } else {
                this.includedNames = includeFieldNamesParam;
                Arrays.sort(this.includedNames);
            }
            return this;
        }
    }
}

