/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti3BackgroundCmd;
import ghidra.app.cmd.data.rtti.CreateVfTableBackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti4Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.cmd.data.rtti.VfTableModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.bytesearch.GenericByteSequencePattern;
import ghidra.util.bytesearch.GenericMatchAction;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MemoryBytePatternSearcher;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreateRtti4BackgroundCmd
extends AbstractCreateDataBackgroundCmd<Rtti4Model> {
    private static final String RTTI_4_NAME = "RTTI Complete Object Locator";
    private List<MemoryBlock> vfTableBlocks;
    private List<Address> rtti4Locations;

    public CreateRtti4BackgroundCmd(Address address, List<MemoryBlock> vfTableBlocks, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTICompleteObjectLocator", address, 1, validationOptions, applyOptions);
        this.vfTableBlocks = vfTableBlocks;
        this.rtti4Locations = new ArrayList<Address>();
        this.rtti4Locations.add(address);
    }

    public CreateRtti4BackgroundCmd(List<Address> addresses, List<MemoryBlock> vfTableBlocks, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTICompleteObjectLocator", addresses.get(0), 1, validationOptions, applyOptions);
        this.rtti4Locations = addresses;
        this.vfTableBlocks = vfTableBlocks;
    }

    @Override
    protected boolean doApplyTo(Program program, TaskMonitor taskMonitor) throws CancelledException {
        ArrayList<Address> goodRtti4Locations = new ArrayList<Address>();
        boolean succeeded = false;
        for (Address addr : this.rtti4Locations) {
            this.setDataAddress(addr);
            succeeded |= super.doApplyTo(program, taskMonitor);
            goodRtti4Locations.add(addr);
        }
        if (succeeded && this.applyOptions.shouldFollowData()) {
            this.createAssociatedVfTables(program, goodRtti4Locations, taskMonitor);
        }
        return succeeded;
    }

    @Override
    protected Rtti4Model createModel(Program program) {
        if (this.model == null || program != ((Rtti4Model)this.model).getProgram() || !this.getDataAddress().equals((Object)((Rtti4Model)this.model).getAddress())) {
            this.model = new Rtti4Model(program, this.getDataAddress(), this.validationOptions);
        }
        return (Rtti4Model)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        boolean createRtti3Success;
        boolean createRtti0Success;
        this.monitor.checkCancelled();
        try {
            createRtti0Success = this.createRtti0();
        }
        catch (InvalidDataTypeException e) {
            createRtti0Success = false;
            this.handleErrorMessage(((Rtti4Model)this.model).getProgram(), ((Rtti4Model)this.model).getAddress(), e.getMessage());
        }
        try {
            createRtti3Success = this.createRtti3();
        }
        catch (InvalidDataTypeException e) {
            createRtti3Success = false;
            this.handleErrorMessage(((Rtti4Model)this.model).getProgram(), ((Rtti4Model)this.model).getAddress(), e.getMessage());
        }
        return createRtti0Success && createRtti3Success;
    }

    private boolean createRtti0() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCancelled();
        CreateTypeDescriptorBackgroundCmd cmd = new CreateTypeDescriptorBackgroundCmd(((Rtti4Model)this.model).getRtti0Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti4Model)this.model).getProgram(), this.monitor);
    }

    private boolean createRtti3() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCancelled();
        CreateRtti3BackgroundCmd cmd = new CreateRtti3BackgroundCmd(((Rtti4Model)this.model).getRtti3Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti4Model)this.model).getProgram(), this.monitor);
    }

    private boolean createAssociatedVfTables(Program program, List<Address> goodRtti4Locations, TaskMonitor taskMonitor) throws CancelledException {
        int n;
        MemoryBytePatternSearcher searcher = new MemoryBytePatternSearcher("RTTI4 Vftables");
        HashMap<Address, VfTableModel> foundVFtables = new HashMap<Address, VfTableModel>();
        for (Address address : goodRtti4Locations) {
            byte[] bytes = ProgramMemoryUtil.getDirectAddressBytes((Program)program, (Address)address);
            this.addByteSearchPattern(searcher, foundVFtables, address, bytes);
        }
        AddressSet searchSet = new AddressSet();
        for (MemoryBlock block : this.vfTableBlocks) {
            searchSet.add(block.getStart(), block.getEnd());
        }
        searcher.search(program, (AddressSetView)searchSet, this.monitor);
        boolean bl = false;
        for (Address rtti4Address : goodRtti4Locations) {
            this.monitor.checkCancelled();
            VfTableModel vfTableModel = foundVFtables.get(rtti4Address);
            if (vfTableModel == null) {
                String message = "No vfTable found for RTTICompleteObjectLocator @ " + rtti4Address;
                this.handleErrorMessage(program, rtti4Address, message);
                continue;
            }
            CreateVfTableBackgroundCmd cmd = new CreateVfTableBackgroundCmd(vfTableModel, this.applyOptions);
            n |= cmd.applyTo((DomainObject)program, this.monitor);
        }
        return n != 0;
    }

    private void addByteSearchPattern(MemoryBytePatternSearcher searcher, final HashMap<Address, VfTableModel> foundVFtables, final Address rtti4Address, byte[] bytes) {
        if (bytes == null) {
            return;
        }
        GenericMatchAction<Address> action = new GenericMatchAction<Address>(rtti4Address){

            public void apply(Program prog, Address addr, Match match) {
                Address possibleVfTableAddr = addr.add((long)prog.getDefaultPointerSize());
                try {
                    VfTableModel vfTableModel = new VfTableModel(prog, possibleVfTableAddr, CreateRtti4BackgroundCmd.this.validationOptions);
                    vfTableModel.validate();
                    VfTableModel existing = foundVFtables.put(rtti4Address, vfTableModel);
                    if (existing != null) {
                        String message = "More than one possible vfTable found for RTTICompleteObjectLocator @ " + rtti4Address;
                        CreateRtti4BackgroundCmd.this.handleErrorMessage(prog, rtti4Address, message);
                    }
                }
                catch (InvalidDataTypeException invalidDataTypeException) {
                    // empty catch block
                }
            }
        };
        GenericByteSequencePattern genericByteMatchPattern = new GenericByteSequencePattern(bytes, (GenericMatchAction)action);
        searcher.addPattern((Pattern)genericByteMatchPattern);
    }

    @Override
    protected boolean createMarkup() throws CancelledException, InvalidDataTypeException {
        this.monitor.checkCancelled();
        Program program = ((Rtti4Model)this.model).getProgram();
        TypeDescriptorModel rtti0Model = ((Rtti4Model)this.model).getRtti0Model();
        if (rtti0Model == null) {
            return true;
        }
        this.monitor.checkCancelled();
        boolean shouldCreateComment = true;
        if (this.applyOptions.shouldCreateLabel()) {
            shouldCreateComment = RttiUtil.createSymbolFromDemangledType(program, this.getDataAddress(), rtti0Model, RTTI_4_NAME);
        }
        if (shouldCreateComment) {
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, "const " + RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", RTTI_4_NAME, null, this.getDataAddress(), this.applyOptions);
        }
        return true;
    }
}

