/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.AbstractDockingTool;
import docking.ActionContext;
import docking.ActionToGuiHelper;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.EditListener;
import docking.ErrLogDialog;
import docking.ErrorReporter;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.actions.ToolActions;
import docking.framework.AboutDialog;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.UserAgreementDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.model.ToolListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginManager;
import ghidra.framework.plugintool.PluginToolMacAboutHandler;
import ghidra.framework.plugintool.PluginToolMacQuitHandler;
import ghidra.framework.plugintool.ToolServicesAdapter;
import ghidra.framework.plugintool.dialog.ExtensionTableProvider;
import ghidra.framework.plugintool.dialog.ManagePluginsDialog;
import ghidra.framework.plugintool.mgr.DialogManager;
import ghidra.framework.plugintool.mgr.EventManager;
import ghidra.framework.plugintool.mgr.OptionsManager;
import ghidra.framework.plugintool.mgr.ServiceManager;
import ghidra.framework.plugintool.mgr.ToolTaskManager;
import ghidra.framework.plugintool.util.OptionsService;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.framework.plugintool.util.TransientToolState;
import ghidra.framework.plugintool.util.UndoRedoToolState;
import ghidra.framework.project.ProjectDataService;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import help.Help;
import help.HelpService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;

public abstract class PluginTool
extends AbstractDockingTool {
    public static final String TOOL_NAME_PROPERTY = "ToolName";
    public static final String ICON_PROPERTY_NAME = "Icon";
    public static final String DESCRIPTION_PROPERTY_NAME = "Description";
    public static final String PLUGIN_COUNT_PROPERTY_NAME = "PluginCount";
    private static final String DOCKING_WINDOWS_ON_TOP = "Docking Windows On Top";
    private static final String SAVE_DIALOG_TITLE = "Save Tool - Possible Conflict";
    private ProjectManager projectManager;
    private Project project;
    private String instanceName = "";
    protected String toolName;
    private String fullName;
    private String subTitle;
    private ServiceManager serviceMgr;
    private OptionsManager optionsMgr;
    private PluginManager pluginMgr;
    private EventManager eventMgr;
    private DialogManager dialogMgr;
    private PropertyChangeSupport propertyChangeMgr;
    private ToolTaskManager taskMgr;
    private Set<TaskListener> executingTaskListeners = Collections.synchronizedSet(new HashSet());
    private OptionsChangeListener optionsListener = new ToolOptionsListener();
    protected ManagePluginsDialog manageDialog;
    protected ToolIconURL iconURL = new ToolIconURL("view_detailed.png");
    private ToolServices toolServices;
    private boolean isConfigurable = true;
    protected boolean isDisposed = false;
    private boolean restoringDataState;

    public PluginTool(Project project, ToolTemplate template) {
        this(project, project.getProjectManager(), project.getToolServices(), template.getName(), true, true, false);
        this.setIconURL(template.getIconURL());
        boolean hasErrors = this.restoreFromXml(template.getToolElement());
        if (!hasErrors) {
            this.setConfigChanged(false);
        }
        this.optionsMgr.validateOptions();
    }

    public PluginTool(Project project, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this(project, project.getProjectManager(), project.getToolServices(), name, isDockable, hasStatus, isModal);
    }

    public PluginTool(Project project, ProjectManager projectManager, ToolServices toolServices, String name, boolean isDockable, boolean hasStatus, boolean isModal) {
        this.project = project;
        this.projectManager = projectManager;
        this.toolServices = toolServices == null ? new ToolServicesAdapter() : toolServices;
        this.propertyChangeMgr = new PropertyChangeSupport((Object)this);
        this.optionsMgr = new OptionsManager(this);
        this.winMgr = this.createDockingWindowManager(isDockable, hasStatus, isModal);
        this.toolActions = new ToolActions((Tool)this, new ActionToGuiHelper(this.winMgr));
        this.taskMgr = new ToolTaskManager(this);
        this.setToolOptionsHelpLocation();
        this.winMgr.addStatusItem(this.taskMgr.getMonitorComponent(), false, true);
        this.winMgr.removeStatusItem(this.taskMgr.getMonitorComponent());
        this.eventMgr = new EventManager(this);
        this.serviceMgr = new ServiceManager();
        this.installServices();
        this.pluginMgr = new PluginManager(this, this.serviceMgr);
        this.dialogMgr = new DialogManager(this);
        this.initActions();
        this.initOptions();
        this.setToolName(name);
        PluginToolMacQuitHandler.install(this);
        PluginToolMacAboutHandler.install(this.winMgr);
        this.installHomeButton();
    }

    protected PluginTool() {
    }

    public abstract PluginClassManager getPluginClassManager();

    protected DockingWindowManager createDockingWindowManager(boolean isDockable, boolean hasStatus, boolean isModal) {
        List windowIcons = ApplicationInformationDisplayFactory.getWindowIcons();
        DockingWindowManager newManager = new DockingWindowManager((Tool)this, windowIcons, isModal, isDockable, hasStatus, null);
        return newManager;
    }

    protected void installHomeButton() {
        Icon homeIcon = ApplicationInformationDisplayFactory.getHomeIcon();
        if (homeIcon == null) {
            Msg.debug((Object)((Object)this), (Object)"If you would like a button to show the Front End, then set the home icon");
            return;
        }
        Runnable callback = ApplicationInformationDisplayFactory.getHomeCallback();
        this.winMgr.setHomeButton(homeIcon, callback);
    }

    protected void installUtilityPlugins() {
        PluginClassManager classManager = this.getPluginClassManager();
        PluginPackage utilityPackage = PluginPackage.getPluginPackage("Utility");
        List<PluginDescription> descriptions = classManager.getPluginDescriptions(utilityPackage);
        HashSet<String> classNames = new HashSet<String>();
        if (descriptions == null) {
            return;
        }
        for (PluginDescription description : descriptions) {
            String pluginClass = description.getPluginClass().getName();
            classNames.add(pluginClass);
        }
        try {
            this.addPlugins(classNames);
        }
        catch (PluginException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Adding Utility Plugins", (Object)"Unexpected exception adding application utility plugins", (Throwable)((Object)e));
        }
    }

    protected void initActions() {
    }

    private void setDefaultOptionValues() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        boolean windowsOnTop = toolOptions.getBoolean(DOCKING_WINDOWS_ON_TOP, false);
        this.winMgr.setWindowsOnTop(windowsOnTop);
    }

    private void initOptions() {
        ToolOptions toolOptions = this.optionsMgr.getOptions("Tool");
        toolOptions.registerOption(DOCKING_WINDOWS_ON_TOP, (Object)false, null, "Determines whether a docked window will always be shown on top of its parent window.");
        this.setDefaultOptionValues();
        toolOptions.addOptionsChangeListener(this.optionsListener);
        this.serviceMgr.addService(OptionsService.class, this.optionsMgr);
    }

    protected void optionsChanged(Options options, String name, Object oldValue, Object newValue) {
        if (name.equals(DOCKING_WINDOWS_ON_TOP)) {
            this.winMgr.setWindowsOnTop(((Boolean)newValue).booleanValue());
        }
    }

    public void setWindowsOnTop(boolean b) {
        this.winMgr.setWindowsOnTop(b);
    }

    public boolean isWindowsOnTop() {
        return this.winMgr.isWindowsOnTop();
    }

    public ManagePluginsDialog getManagePluginsDialog() {
        return this.manageDialog;
    }

    public void showConfig(boolean addSaveActions, boolean isNewTool) {
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.manageDialog = new ManagePluginsDialog(this, addSaveActions, isNewTool);
        this.showDialog((DialogComponentProvider)this.manageDialog);
    }

    public void showExtensions() {
        this.showDialog(new ExtensionTableProvider(this));
    }

    public void showComponentHeader(ComponentProvider provider, boolean b) {
        this.winMgr.showComponentHeader(provider, b);
    }

    private void installServices() {
        this.serviceMgr.addService(ProjectDataService.class, () -> this.project.getProjectData());
    }

    public boolean isService(Class<?> serviceInterface) {
        return this.serviceMgr.isService(serviceInterface);
    }

    public <T> T getService(Class<T> c) {
        return this.serviceMgr.getService(c);
    }

    public <T> T[] getServices(Class<T> c) {
        return this.serviceMgr.getServices(c);
    }

    <T> void addService(Class<T> interfaceClass, T service) {
        this.serviceMgr.addService(interfaceClass, service);
    }

    void removeService(Class<?> interfaceClass, Object service) {
        this.serviceMgr.removeService(interfaceClass, service);
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceMgr.addServiceListener(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceMgr.removeServiceListener(listener);
    }

    public void beep() {
        DockingWindowManager.beep();
    }

    public void setDefaultComponent(ComponentProvider provider) {
        this.winMgr.setDefaultComponent(provider);
    }

    public ToolTemplate getToolTemplate(boolean includeConfigState) {
        throw new UnsupportedOperationException("You cannot create templates for generic tools: " + ((Object)((Object)this)).getClass().getName());
    }

    public ToolTemplate saveToolToToolTemplate() {
        this.setConfigChanged(false);
        this.optionsMgr.removeUnusedOptions();
        return this.getToolTemplate(true);
    }

    public Element saveWindowingDataToXml() {
        throw new UnsupportedOperationException("You cannot persist generic tools: " + ((Object)((Object)this)).getClass().getName());
    }

    public void restoreWindowingDataFromXml(Element element) {
        throw new UnsupportedOperationException("You cannot persist generic tools: " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean acceptDomainFiles(DomainFile[] data) {
        return this.pluginMgr.acceptData(data);
    }

    public boolean accept(URL url) {
        return this.pluginMgr.accept(url);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.addPropertyChangeListener(l);
    }

    public void addToolListener(ToolListener listener) {
        this.eventMgr.addToolListener(listener);
    }

    public boolean hasToolListeners() {
        return this.eventMgr.hasToolListeners();
    }

    public void exit() {
        this.dispose();
    }

    protected void dispose() {
        this.isDisposed = true;
        this.pluginMgr.close();
        if (this.project != null && this.project.getToolManager() != null) {
            this.project.getToolManager().disconnectTool(this);
        }
        if (this.manageDialog != null) {
            this.manageDialog.close();
        }
        this.winMgr.setVisible(false);
        this.eventMgr.clear();
        this.pluginMgr.dispose();
        this.toolActions.removeActions("Tool");
        this.toolActions.dispose();
        if (this.project != null) {
            this.project.releaseFiles((Object)this);
        }
        this.optionsMgr.dispose();
        this.disposeManagers();
        this.winMgr.dispose();
    }

    private void disposeManagers() {
        this.taskMgr.dispose();
        this.executingTaskListeners.clear();
    }

    public void firePluginEvent(PluginEvent event) {
        this.eventMgr.fireEvent(event);
    }

    public String[] getConsumedToolEventNames() {
        return this.eventMgr.getEventsConsumed();
    }

    public DomainFile[] getDomainFiles() {
        return this.pluginMgr.getData();
    }

    public ImageIcon getIcon() {
        return this.iconURL.getIcon();
    }

    public ToolIconURL getIconURL() {
        return this.iconURL;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getName() {
        return this.fullName;
    }

    public Class<?>[] getSupportedDataTypes() {
        return this.pluginMgr.getSupportedDataTypes();
    }

    public String[] getToolEventNames() {
        return this.eventMgr.getEventsProduced();
    }

    public String getToolName() {
        return this.toolName;
    }

    public void putInstanceName(String newInstanceName) {
        this.instanceName = newInstanceName;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.updateTitle();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeMgr.removePropertyChangeListener(l);
    }

    public void removeToolListener(ToolListener listener) {
        this.eventMgr.removeToolListener(listener);
    }

    public void restoreDataStateFromXml(Element root) {
        this.restoringDataState = true;
        try {
            this.pluginMgr.restoreDataStateFromXml(root);
            this.setConfigChanged(false);
        }
        finally {
            this.restoringDataState = false;
        }
    }

    public Element saveDataStateToXml(boolean savingProject) {
        return this.pluginMgr.saveDataStateToXml(savingProject);
    }

    protected boolean restoreFromXml(Element root) {
        this.toolName = root.getAttributeValue("TOOL_NAME");
        this.instanceName = root.getAttributeValue("INSTANCE_NAME");
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.restoreOptionsFromXml(root);
        this.winMgr.restorePreferencesFromXML(root);
        this.setDefaultOptionValues();
        boolean hasErrors = false;
        try {
            this.pluginMgr.restorePluginsFromXml(root);
        }
        catch (PluginException e) {
            hasErrors = true;
            Msg.showError((Object)((Object)this), (Component)this.getToolFrame(), (String)"Error Restoring Plugins", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.winMgr.restoreWindowDataFromXml(root);
        this.winMgr.setToolName(this.fullName);
        return hasErrors;
    }

    public Element saveToXml(boolean includeConfigState) {
        Element root = new Element("TOOL");
        root.setAttribute("TOOL_NAME", this.toolName);
        root.setAttribute("INSTANCE_NAME", this.instanceName);
        root.addContent((Content)this.optionsMgr.getConfigState());
        this.pluginMgr.saveToXml(root, includeConfigState);
        this.winMgr.saveToXML(root);
        return root;
    }

    public void setConfigChanged(boolean changed) {
        super.setConfigChanged(changed);
        if (this.manageDialog != null) {
            this.manageDialog.stateChanged();
        }
    }

    public void setIconURL(ToolIconURL newIconURL) {
        if (newIconURL == null) {
            throw new NullPointerException("iconURL cannot be null.");
        }
        this.setConfigChanged(true);
        if (newIconURL.equals((Object)this.iconURL)) {
            return;
        }
        ImageIcon oldValue = this.iconURL.getSmallIcon();
        this.iconURL = newIconURL;
        ImageIcon newValue = this.iconURL.getSmallIcon();
        this.propertyChangeMgr.firePropertyChange(ICON_PROPERTY_NAME, oldValue, newValue);
        this.winMgr.setIcon(newValue);
    }

    public void setToolName(String name) {
        String oldName = this.toolName;
        this.toolName = name;
        this.fullName = this.instanceName.length() == 0 ? this.toolName : this.toolName + "(" + this.instanceName + ")";
        this.winMgr.setToolName(this.fullName);
        this.propertyChangeMgr.firePropertyChange(TOOL_NAME_PROPERTY, oldName, this.toolName);
    }

    public void processToolEvent(PluginEvent toolEvent) {
        this.eventMgr.processToolEvent(toolEvent);
    }

    public boolean execute(Command command, DomainObject obj) {
        return this.taskMgr.execute(command, obj);
    }

    public boolean isExecutingCommand() {
        return this.taskMgr.isBusy() || !this.executingTaskListeners.isEmpty();
    }

    public boolean threadIsBackgroundTaskThread() {
        ThreadGroup group;
        ThreadGroup taskGroup = this.taskMgr.getTaskThreadGroup();
        for (group = Thread.currentThread().getThreadGroup(); group != null && group != taskGroup; group = group.getParent()) {
        }
        return group == taskGroup;
    }

    public void executeBackgroundCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        this.taskMgr.executeCommand(cmd, obj);
    }

    public void terminateBackgroundCommands(boolean wait) {
        this.taskMgr.stop(wait);
    }

    public void scheduleFollowOnCommand(BackgroundCommand cmd, UndoableDomainObject obj) {
        this.taskMgr.scheduleFollowOnCommand(cmd, obj);
    }

    public void execute(Task task, int delay) {
        task.addTaskListener((TaskListener)new TaskBusyListener());
        new TaskLauncher(task, (Component)this.getToolFrame(), delay);
    }

    public void execute(Task task) {
        task.addTaskListener((TaskListener)new TaskBusyListener());
        new TaskLauncher(task, (Component)this.winMgr.getActiveWindow());
    }

    public ToolOptions getOptions(String categoryName) {
        return this.optionsMgr.getOptions(categoryName);
    }

    public void registerOptionsNameChange(String oldName, String newName) {
        this.optionsMgr.registerOptionNameChanged(oldName, newName);
    }

    public boolean hasOptions(String category) {
        return this.optionsMgr.hasOptions(category);
    }

    OptionsManager getOptionsManager() {
        return this.optionsMgr;
    }

    public ToolOptions[] getOptions() {
        return this.optionsMgr.getOptions();
    }

    public Project getProject() {
        return this.project;
    }

    public ProjectManager getProjectManager() {
        return this.projectManager;
    }

    public ToolServices getToolServices() {
        return this.toolServices;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        this.updateTitle();
    }

    public void addPlugin(String className) throws PluginException {
        this.addPlugins(List.of(className));
    }

    @Deprecated(since="10.2", forRemoval=true)
    public void addPlugins(String[] classNames) throws PluginException {
        this.addPlugins(Arrays.asList(classNames));
    }

    public void addPlugins(Collection<String> classNames) throws PluginException {
        this.checkedRunSwingNow(() -> {
            try {
                this.pluginMgr.addPlugins(classNames);
            }
            finally {
                this.setConfigChanged(true);
            }
        }, PluginException.class);
    }

    public void addPlugin(Plugin p) throws PluginException {
        this.checkedRunSwingNow(() -> {
            this.pluginMgr.addPlugin(p);
            this.setConfigChanged(true);
        }, PluginException.class);
    }

    @Deprecated(since="10.2", forRemoval=true)
    public void removePlugins(Plugin[] plugins) {
        this.removePlugins(Arrays.asList(plugins));
    }

    public void removePlugins(List<Plugin> plugins) {
        Swing.runNow(() -> {
            try {
                this.pluginMgr.removePlugins(plugins);
            }
            finally {
                this.setConfigChanged(true);
            }
        });
    }

    public boolean hasUnsavedData() {
        return this.pluginMgr.hasUnsavedData();
    }

    public List<Plugin> getManagedPlugins() {
        return this.pluginMgr.getPlugins();
    }

    public void saveTool() {
        this.toolServices.saveTool(this);
    }

    public boolean saveToolAs() {
        return this.dialogMgr.saveToolAs();
    }

    public void addStatusComponent(JComponent c, boolean addBorder, boolean rightSide) {
        this.winMgr.addStatusItem(c, addBorder, rightSide);
    }

    public void removeStatusComponent(JComponent c) {
        this.winMgr.removeStatusItem(c);
    }

    protected void addExitAction() {
        DockingAction exitAction = new DockingAction("Exit Ghidra", "Tool"){

            public void actionPerformed(ActionContext context) {
                AppInfo.exitGhidra();
            }
        };
        exitAction.setHelpLocation(new HelpLocation("FrontEndPlugin", exitAction.getName()));
        exitAction.setMenuBarData(new MenuData(new String[]{"&File", "E&xit Ghidra"}, null, "Window_Z"));
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            exitAction.setKeyBindingData(new KeyBindingData(81, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        }
        exitAction.setEnabled(true);
        this.addAction((DockingActionIf)exitAction);
    }

    protected void addOptionsAction() {
        DockingAction optionsAction = new DockingAction("Edit Options", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.optionsMgr.editOptions();
            }
        };
        optionsAction.setAddToAllWindows(true);
        optionsAction.setHelpLocation(new HelpLocation("FrontEndPlugin", "Tool Options"));
        MenuData menuData = new MenuData(new String[]{"&Edit", "&Tool Options"}, null, "AOptions");
        menuData.setMenuSubGroup("AOptions");
        optionsAction.setMenuBarData(menuData);
        optionsAction.setEnabled(true);
        this.addAction((DockingActionIf)optionsAction);
    }

    protected void addSaveToolAction() {
        DockingAction saveAction = new DockingAction("Save Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", "Save Tool"}, null, "Tool");
        menuData.setMenuSubGroup("1Tool");
        saveAction.setMenuBarData(menuData);
        saveAction.setEnabled(true);
        saveAction.setHelpLocation(new HelpLocation("Tool", "Save Tool"));
        DockingAction saveAsAction = new DockingAction("Save Tool As", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.saveToolAs();
            }
        };
        menuData = new MenuData(new String[]{"&File", "Save Tool As..."}, null, "Tool");
        menuData.setMenuSubGroup("2Tool");
        saveAsAction.setMenuBarData(menuData);
        saveAsAction.setEnabled(true);
        saveAsAction.setHelpLocation(new HelpLocation("Tool", "Tool_Changes"));
        this.addAction((DockingActionIf)saveAction);
        this.addAction((DockingActionIf)saveAsAction);
    }

    protected void addExportToolAction() {
        String menuGroup = "Tool";
        String exportPullright = "Export";
        this.setMenuGroup(new String[]{"&File", exportPullright}, menuGroup);
        int subGroup = 1;
        DockingAction exportToolAction = new DockingAction("Export Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                PluginTool.this.dialogMgr.exportTool();
            }
        };
        MenuData menuData = new MenuData(new String[]{"&File", exportPullright, "Export Tool..."});
        menuData.setMenuSubGroup(Integer.toString(subGroup++));
        exportToolAction.setMenuBarData(menuData);
        exportToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Tool"));
        this.addAction((DockingActionIf)exportToolAction);
        DockingAction exportDefautToolAction = new DockingAction("Export Default Tool", "Tool"){

            public void actionPerformed(ActionContext e) {
                PluginTool.this.dialogMgr.exportDefaultTool();
            }
        };
        menuData = new MenuData(new String[]{"&File", exportPullright, "Export Default Tool..."});
        menuData.setMenuSubGroup(Integer.toString(subGroup++));
        exportDefautToolAction.setMenuBarData(menuData);
        exportDefautToolAction.setHelpLocation(new HelpLocation("Tool", "Export_Default_Tool"));
        this.addAction((DockingActionIf)exportDefautToolAction);
    }

    protected void addHelpActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("About Ghidra", "Tool").menuPath(new String[]{"&Help", "&About Ghidra"})).menuGroup("ZZA")).helpLocation(new HelpLocation("About", "About_Ghidra"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> DockingWindowManager.showDialog((DialogComponentProvider)new AboutDialog()))).buildAndInstall((Tool)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("User Agreement", "Tool").menuPath(new String[]{"&Help", "&User Agreement"})).menuGroup("AAAHelpContents")).helpLocation(new HelpLocation("About", "User_Agreement"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> DockingWindowManager.showDialog((DialogComponentProvider)new UserAgreementDialog(false, false)))).buildAndInstall((Tool)this);
        ErrorReporter reporter = ErrLogDialog.getErrorReporter();
        if (reporter != null) {
            ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Report Bug", "Tool").menuPath(new String[]{"&Help", "&Report Bug..."})).menuGroup("BBB")).helpLocation(new HelpLocation("ErrorReporting", "Report_Bug"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> reporter.report((Component)this.getToolFrame(), "User Bug Report", null))).buildAndInstall((Tool)this);
        }
        HelpService help = Help.getHelpService();
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Contents", "Tool").menuPath(new String[]{"&Help", "&Contents"})).menuGroup("AAAHelpContents")).helpLocation(new HelpLocation("Misc", "Welcome_to_Ghidra_Help"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(c -> help.showHelp(null, false, (Component)this.getToolFrame()))).buildAndInstall((Tool)this);
    }

    public void clearLastEvents() {
        this.eventMgr.clearLastEvents();
    }

    public void close() {
        this.close(false);
    }

    protected void close(boolean isExiting) {
        if (this.canClose(isExiting) && this.pluginMgr.saveData()) {
            this.doClose();
        }
    }

    private void doClose() {
        if (!this.doSaveTool()) {
            return;
        }
        this.exit();
        this.toolServices.closeTool(this);
    }

    public boolean shouldSave() {
        return this.hasConfigChanged();
    }

    protected boolean doSaveTool() {
        if (this.toolServices.canAutoSave(this)) {
            this.saveTool();
        } else if (this.hasConfigChanged()) {
            boolean didSave;
            int result = OptionDialog.showOptionDialog((Component)this.getToolFrame(), (String)SAVE_DIALOG_TITLE, (String)"This tool has changed.  There are/were multiple instances of this tool\nrunning and Ghidra cannot determine if this tool instance should\nautomatically be saved.  Do you want to save the configuration of this tool\ninstance?", (String)"Save", (String)"Save As...", (String)"Don't Save", (int)2);
            if (result == 0) {
                return false;
            }
            if (result == 1) {
                this.saveTool();
            } else if (result == 2 && !(didSave = this.saveToolAs())) {
                return this.doSaveTool();
            }
        }
        return true;
    }

    public boolean canClose(boolean isExiting) {
        if (this.taskMgr.isBusy()) {
            if (isExiting) {
                int result = OptionDialog.showYesNoDialog((Component)this.getToolFrame(), (String)"Tool Busy Executing Task", (String)"The tool is busy performing a background task.\n If you continue the task may be terminated and some work may be lost!\n\nContinue anyway?");
                if (result == 2) {
                    return false;
                }
                this.taskMgr.stop(false);
            } else {
                this.beep();
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getToolFrame(), (String)"Tool Busy", (Object)"You must stop all background tasks before tool may close.");
                return false;
            }
        }
        return this.pluginMgr.canClose();
    }

    public boolean canCloseDomainObject(DomainObject domainObject) {
        if (this.taskMgr.hasTasksForDomainObject(domainObject)) {
            String name = domainObject.getName();
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getToolFrame(), (String)("Close " + name + " Failed"), (Object)("The tool is currently working in the background on " + name + ".\nPlease stop the background processing first."));
            return false;
        }
        return this.pluginMgr.canCloseDomainObject(domainObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCloseDomainFile(DomainFile domainFile) {
        Object consumer = new Object();
        DomainObject domainObject = domainFile.getOpenedDomainObject(consumer);
        if (domainObject == null) {
            return true;
        }
        try {
            boolean bl = this.canCloseDomainObject(domainObject);
            return bl;
        }
        finally {
            domainObject.release(consumer);
        }
    }

    public void prepareToSave(DomainObject dobj) {
        this.pluginMgr.prepareToSave(dobj);
    }

    public void setSize(int width, int height) {
        this.winMgr.getMainWindow().setSize(new Dimension(width, height));
    }

    public Dimension getSize() {
        return this.winMgr.getMainWindow().getSize();
    }

    public void setLocation(int x, int y) {
        this.winMgr.getMainWindow().setLocation(x, y);
    }

    public Point getLocation() {
        return this.winMgr.getMainWindow().getLocation();
    }

    private void updateTitle() {
        Object title = this.fullName;
        if (this.subTitle != null) {
            title = (String)title + ": " + this.subTitle;
        }
        this.winMgr.setToolName((String)title);
    }

    protected void restoreOptionsFromXml(Element root) {
        this.optionsMgr.setConfigState(root.getChild("OPTIONS"));
        this.toolActions.restoreKeyBindings();
        this.setToolOptionsHelpLocation();
    }

    protected void setProject(Project project) {
        this.project = project;
        this.toolServices = project != null ? project.getToolServices() : new ToolServicesAdapter();
    }

    protected void restorePluginsFromXml(Element elem) throws PluginException {
        this.pluginMgr.restorePluginsFromXml(elem);
    }

    PluginEvent[] getLastEvents() {
        return this.eventMgr.getLastEvents();
    }

    void removeAll(String owner) {
        this.toolActions.removeActions(owner);
        this.winMgr.ownerRemoved(owner);
    }

    void registerEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.addEventProducer(eventClass);
    }

    public void addEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.addEventListener(eventClass, listener);
    }

    void unregisterEventProduced(Class<? extends PluginEvent> eventClass) {
        this.eventMgr.removeEventProducer(eventClass);
    }

    public void addListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.addAllEventListener(listener);
    }

    public void removeListenerForAllPluginEvents(PluginEventListener listener) {
        this.eventMgr.removeAllEventListener(listener);
    }

    public void removeEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        this.eventMgr.removeEventListener(eventClass, listener);
    }

    void removeEventListener(String className) {
        this.eventMgr.removeEventListener(className);
    }

    public void showEditWindow(String defaultText, Component comp, Rectangle rect, EditListener listener) {
        this.winMgr.showEditWindow(defaultText, comp, rect, listener);
    }

    public void cancelCurrentTask() {
        this.taskMgr.cancelCurrentTask();
    }

    private void setToolOptionsHelpLocation() {
        ToolOptions opt = this.getOptions("Tool");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "OptionsForTool"));
        opt = this.getOptions("Key Bindings");
        opt.setOptionsHelpLocation(new HelpLocation("Tool", "KeyBindings_Option"));
    }

    public TransientToolState getTransientState() {
        return this.pluginMgr.getTransientState();
    }

    public UndoRedoToolState getUndoRedoToolState(DomainObject domainObject) {
        return this.pluginMgr.getUndoRedoToolState(domainObject);
    }

    @Deprecated
    public void showDialogOnActiveWindow(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog((DialogComponentProvider)dialogComponent);
    }

    public void showDialog(DialogComponentProvider dialogComponent, ComponentProvider centeredOnProvider) {
        this.winMgr.showDialog(dialogComponent, centeredOnProvider);
    }

    public void showDialog(DialogComponentProvider dialogComponent, Component centeredOnComponent) {
        DockingWindowManager.showDialog((Component)centeredOnComponent, (DialogComponentProvider)dialogComponent);
    }

    public Window getActiveWindow() {
        return this.winMgr.getActiveWindow();
    }

    public ComponentProvider getActiveComponentProvider() {
        return this.winMgr.getActiveComponentProvider();
    }

    public void refreshKeybindings() {
        this.toolActions.restoreKeyBindings();
    }

    public void setUnconfigurable() {
        this.isConfigurable = false;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    public void removePreferenceState(String name) {
        this.winMgr.removePreferenceState(name);
    }

    public ActionContext getDefaultToolContext() {
        return this.winMgr.getDefaultToolContext();
    }

    public void contextChanged(ComponentProvider provider) {
        if (this.isDisposed) {
            return;
        }
        super.contextChanged(provider);
    }

    public boolean isRestoringDataState() {
        return this.restoringDataState;
    }

    private <T extends Throwable> void checkedRunSwingNow(CheckedRunnable<T> r, Class<T> exceptionClass) throws T {
        AtomicReference caughtException = new AtomicReference();
        Swing.runNow(() -> {
            try {
                r.run();
            }
            catch (Throwable th) {
                caughtException.set(th);
            }
        });
        Throwable th = (Throwable)caughtException.get();
        if (th != null) {
            if (exceptionClass.isInstance(th)) {
                throw (Throwable)exceptionClass.cast(th);
            }
            throw new RuntimeException("Unexpected exception type " + th.getClass(), th);
        }
    }

    private class ToolOptionsListener
    implements OptionsChangeListener {
        private ToolOptionsListener() {
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            PluginTool.this.optionsChanged((Options)options, name, oldValue, newValue);
        }
    }

    private class TaskBusyListener
    implements TaskListener {
        TaskBusyListener() {
            PluginTool.this.executingTaskListeners.add(this);
        }

        public void taskCompleted(Task t) {
            PluginTool.this.executingTaskListeners.remove(this);
        }

        public void taskCancelled(Task t) {
            PluginTool.this.executingTaskListeners.remove(this);
        }
    }

    private static interface CheckedRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

