/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import generic.theme.GIcon;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DBContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.URLLinkObject;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.BadLinkException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.swing.Icon;

public abstract class LinkHandler<T extends DomainObjectAdapterDB>
extends DBContentHandler<T> {
    public static final String URL_METADATA_KEY = "link.url";
    public static final Icon LINK_ICON = new GIcon("icon.content.handler.link.overlay");

    protected final void createLink(URL ghidraUrl, LocalFileSystem fs, String folderPath, String linkFilename) throws IOException, InvalidNameException {
        URLLinkObject link = new URLLinkObject(linkFilename, ghidraUrl, (Object)this);
        try {
            this.createFile((FileSystem)fs, null, folderPath, linkFilename, link, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            link.release(this);
        }
    }

    @Override
    public final T getReadOnlyObject(FolderItem item, int version, boolean okToUpgrade, Object consumer, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        if (!okToUpgrade) {
            throw new UnsupportedOperationException("okToUpgrade must be true for link-file");
        }
        return this.getObject(item, version, consumer, monitor, false);
    }

    @Override
    public T getImmutableObject(FolderItem item, Object consumer, int version, int minChangeVersion, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        if (minChangeVersion != -1) {
            throw new UnsupportedOperationException("minChangeVersion must be -1 for link-file");
        }
        return this.getObject(item, version, consumer, monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getObject(FolderItem item, int version, Object consumer, TaskMonitor monitor, boolean immutable) throws IOException, VersionException, CancelledException {
        DomainObjectAdapterDB domainObjectAdapterDB;
        block8: {
            URL url = LinkHandler.getURL(item);
            Class domainObjectClass = this.getDomainObjectClass();
            if (domainObjectClass == null) {
                throw new UnsupportedOperationException("");
            }
            GhidraURLWrappedContent wrappedContent = null;
            Object content = null;
            try {
                GhidraURLConnection c = (GhidraURLConnection)url.openConnection();
                Object obj = c.getContent();
                if (c.getStatusCode() == GhidraURLConnection.StatusCode.UNAUTHORIZED) {
                    throw new IOException("Authorization failure");
                }
                if (!(obj instanceof GhidraURLWrappedContent)) {
                    throw new IOException("Unsupported linked content");
                }
                wrappedContent = (GhidraURLWrappedContent)obj;
                content = wrappedContent.getContent(consumer);
                if (!(content instanceof DomainFile)) {
                    throw new IOException("Unsupported linked content: " + content.getClass());
                }
                DomainFile linkedFile = (DomainFile)content;
                if (!this.getDomainObjectClass().isAssignableFrom(linkedFile.getDomainObjectClass())) {
                    throw new BadLinkException("Expected " + this.getDomainObjectClass() + " but linked to " + linkedFile.getDomainObjectClass());
                }
                DomainObjectAdapterDB domainObjectAdapterDB2 = domainObjectAdapterDB = immutable ? (DomainObjectAdapterDB)linkedFile.getImmutableDomainObject(consumer, version, monitor) : (DomainObjectAdapterDB)linkedFile.getReadOnlyDomainObject(consumer, version, monitor);
                if (content == null) break block8;
                wrappedContent.release(content, consumer);
            }
            catch (Throwable throwable) {
                if (content != null) {
                    wrappedContent.release(content, consumer);
                }
                throw throwable;
            }
        }
        return (T)domainObjectAdapterDB;
    }

    @Override
    public final T getDomainObject(FolderItem item, FileSystem userfs, long checkoutId, boolean okToUpgrade, boolean okToRecover, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, VersionException {
        throw new UnsupportedOperationException("link-file does not support getDomainObject");
    }

    @Override
    public final ChangeSet getChangeSet(FolderItem versionedFolderItem, int olderVersion, int newerVersion) throws VersionException, IOException {
        return null;
    }

    @Override
    public final DomainObjectMergeManager getMergeManager(DomainObject resultsObj, DomainObject sourceObj, DomainObject originalObj, DomainObject latestObj) {
        return null;
    }

    @Override
    public final boolean isPrivateContentType() {
        return true;
    }

    public static URL getURL(DomainFile linkFile) throws IOException {
        Map<String, String> metadata;
        String urlStr;
        String contentType = linkFile.getContentType();
        ContentHandler<?> ch = DomainObjectAdapter.getContentHandler(contentType);
        if (ch instanceof LinkHandler && (urlStr = (metadata = linkFile.getMetadata()).get(URL_METADATA_KEY)) != null) {
            return new URL(urlStr);
        }
        throw new IOException("Invalid link file: " + contentType);
    }

    static URL getURL(FolderItem linkFile) throws IOException {
        Map<String, String> metadata;
        String urlStr;
        String contentType = linkFile.getContentType();
        ContentHandler<?> ch = DomainObjectAdapter.getContentHandler(contentType);
        if (ch instanceof LinkHandler && (urlStr = (metadata = GhidraFileData.getMetadata(linkFile)).get(URL_METADATA_KEY)) != null) {
            return new URL(urlStr);
        }
        throw new IOException("Invalid link file: " + contentType);
    }

    @Override
    public abstract Icon getIcon();
}

