/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.debug.MemoryUsagePlugin;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class ShowMemoryDialog
extends ReusableDialogComponentProvider {
    private MemoryUsagePlugin plugin;
    private JLabel maxMem;
    private JLabel totalMem;
    private JLabel freeMem;
    private JLabel usedMem;
    private Timer timer;

    ShowMemoryDialog(MemoryUsagePlugin plugin) {
        super("VM Memory Usage", false, false, true, false);
        this.plugin = plugin;
        this.addOKButton();
        this.setOkButtonText("GC");
        this.addWorkPanel(this.createWorkPanel());
        plugin.getTool().showDialog((DialogComponentProvider)this);
        DecimalFormat df = new DecimalFormat();
        this.timer = new Timer(2000, e -> {
            Runtime runtime = Runtime.getRuntime();
            this.maxMem.setText(df.format(runtime.maxMemory() / 1000L) + "K");
            this.totalMem.setText(df.format(runtime.totalMemory() / 1000L) + "K");
            this.freeMem.setText(df.format(runtime.freeMemory() / 1000L) + "K");
            this.usedMem.setText(df.format((runtime.totalMemory() - runtime.freeMemory()) / 1000L) + "K");
        });
        this.timer.start();
    }

    boolean isInitialized() {
        String text = this.maxMem.getText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ('0' == c) continue;
            return true;
        }
        return false;
    }

    protected void cancelCallback() {
        this.timer.stop();
        this.plugin.clearDialog();
        super.cancelCallback();
    }

    protected void okCallback() {
        Runtime.getRuntime().gc();
    }

    private JComponent createWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.maxMem = new GDLabel("00000000000", 4);
        this.totalMem = new GDLabel("00000000000", 4);
        this.freeMem = new GDLabel("00000000000", 4);
        this.usedMem = new GDLabel("00000000000", 4);
        panel.add((Component)new GLabel("Max Memory:"));
        panel.add(this.maxMem);
        panel.add((Component)new GLabel("Total Memory:"));
        panel.add(this.totalMem);
        panel.add((Component)new GLabel("Free Memory:"));
        panel.add(this.freeMem);
        panel.add((Component)new GLabel("Used Memory:"));
        panel.add(this.usedMem);
        return panel;
    }
}

