/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.model.impl;

import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgStateListener;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.model.AbstractDbgModel;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.iface2.DbgModelTargetDebugContainer;
import agent.dbgeng.model.iface2.DbgModelTargetEventContainer;
import agent.dbgeng.model.iface2.DbgModelTargetExceptionContainer;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetModule;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetSession;
import agent.dbgeng.model.iface2.DbgModelTargetStackFrame;
import agent.dbgeng.model.iface2.DbgModelTargetTTD;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelTargetEventContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetExceptionContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetMemoryContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetProcessImpl;
import agent.dbgeng.model.impl.DbgModelTargetThreadImpl;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.manager.DbgManager2Impl;
import agent.dbgmodel.model.impl.DbgModel2Impl;
import agent.dbgmodel.model.impl.DbgModel2TargetProxy;
import agent.dbgmodel.model.impl.DelegateDbgModel2TargetObject;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.AbstractTargetObject;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetAccessConditioned;
import ghidra.dbg.target.TargetAttacher;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DbgModel2TargetObjectImpl
extends DefaultTargetObject<TargetObject, TargetObject>
implements DbgModelTargetObject {
    protected final Map<String, TargetObject> elementsByKey = new WeakValueHashMap();
    protected DbgModelSelectableObject focus;
    public boolean accessible = true;
    private ModelObject modelObject = null;
    protected Map<String, Object> intrinsics = new TreeMap<String, Object>((Comparator<String>)PathUtils.TargetObjectKeyComparator.ATTRIBUTE);
    protected String bptId;
    protected static Map<Integer, DbgBreakpointInfo> bptInfoMap = new HashMap<Integer, DbgBreakpointInfo>();
    protected String DBG_PROMPT = "(kd2)";

    protected static String indexObject(ModelObject obj) {
        return obj.getSearchKey();
    }

    public static String keyObject(ModelObject obj) {
        return PathUtils.makeKey((String)DbgModel2TargetObjectImpl.indexObject(obj));
    }

    protected static String getHintForObject(ModelObject obj) {
        DbgModelNative.TypeKind typeKind = obj.getTypeKind();
        return typeKind == null ? "" : typeKind.name();
    }

    public DbgModel2TargetObjectImpl(AbstractDbgModel model, TargetObject parent, String name, String typeHint) {
        super((AbstractDebuggerObjectModel)model, parent, name, typeHint);
    }

    public DbgModel2TargetObjectImpl(AbstractDbgModel model, TargetObject parent, String name, String typeHint, TargetObjectSchema schema) {
        super((AbstractDebuggerObjectModel)model, parent, name, typeHint, schema);
    }

    public <I> DbgModel2TargetObjectImpl(AbstractTargetObject.ProxyFactory<I> proxyFactory, I proxyInfo, AbstractDbgModel model, TargetObject parent, String name, String typeHint) {
        super(proxyFactory, proxyInfo, (AbstractDebuggerObjectModel)model, parent, name, typeHint);
    }

    public DbgModel2Impl getModel() {
        return (DbgModel2Impl)super.getModel();
    }

    public CompletableFuture<List<TargetObject>> requestNativeElements() {
        DbgManager2Impl manager2 = (DbgManager2Impl)this.getManager();
        List pathX = PathUtils.extend(List.of("Debugger"), (List)this.path);
        return manager2.listElements(pathX, this);
    }

    public CompletableFuture<? extends Map<String, ?>> requestNativeAttributes() {
        DbgManager2Impl manager2 = (DbgManager2Impl)this.getManager();
        List pathX = PathUtils.extend(List.of("Debugger"), (List)this.path);
        return manager2.listAttributes(pathX, this);
    }

    public CompletableFuture<Void> requestAugmentedAttributes() {
        return this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        ArrayList nlist = new ArrayList();
        ArrayList rlist = new ArrayList();
        return ((CompletableFuture)this.requestNativeElements().thenCompose(list -> {
            Map map = this.elements;
            synchronized (map) {
                for (Map.Entry entry : this.elements.entrySet()) {
                    TargetObject element = (TargetObject)entry.getValue();
                    if (list.contains(element)) continue;
                    if (element instanceof DbgStateListener) {
                        this.getManager().removeStateListener((DbgStateListener)element);
                    }
                    if (element instanceof DbgEventsListener) {
                        this.getManager().removeEventsListener((DbgEventsListener)element);
                    }
                    rlist.add((String)entry.getKey());
                }
                nlist.addAll(list);
                return AsyncUtils.NIL;
            }
        })).thenAccept(__ -> this.changeElements(rlist, nlist, Map.of(), "Refreshed"));
    }

    protected boolean isReallyValid() {
        for (DbgModel2TargetObjectImpl p = this; p != null; p = p.getParent()) {
            if (p.isValid()) continue;
            return false;
        }
        return true;
    }

    public CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        HashMap nmap = new HashMap();
        ArrayList rlist = new ArrayList();
        return ((CompletableFuture)this.requestNativeAttributes().thenCompose(map -> {
            Map map2 = this.attributes;
            synchronized (map2) {
                if (map != null) {
                    Collection values = map.values();
                    for (Map.Entry entry : this.attributes.entrySet()) {
                        Object attribute = entry.getValue();
                        if (values.contains(attribute)) continue;
                        if (attribute instanceof DbgStateListener) {
                            this.getManager().removeStateListener((DbgStateListener)attribute);
                        }
                        if (attribute instanceof DbgEventsListener) {
                            this.getManager().removeEventsListener((DbgEventsListener)attribute);
                        }
                        rlist.add((String)entry.getKey());
                    }
                    nmap.putAll(map);
                }
                return this.addModelObjectAttributes(nmap);
            }
        })).thenAccept(__ -> {
            if (!this.isReallyValid()) {
                return;
            }
            this.changeAttributes(List.of(), nmap, "Refreshed");
        });
    }

    protected CompletableFuture<Void> processModelObjectElements(List<TargetObject> list) {
        List<CompletableFuture> futures = list.stream().map(to -> this.processElement((TargetObject)to)).collect(Collectors.toList());
        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        return allOf;
    }

    private CompletableFuture<Void> processElement(TargetObject targetObject) {
        if (targetObject instanceof DbgModelTargetObject) {
            DbgModel2TargetProxy proxy = (DbgModel2TargetProxy)targetObject;
            DelegateDbgModel2TargetObject delegate = proxy.getDelegate();
            if (proxy instanceof TargetStackFrame || proxy instanceof TargetModule || proxy instanceof TargetBreakpointSpec) {
                return delegate.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> addModelObjectAttributes(Map<String, Object> attrs) {
        if (this.modelObject == null || !this.valid) {
            return CompletableFuture.completedFuture(null);
        }
        String key = this.modelObject.getSearchKey();
        DbgModelNative.ModelObjectKind kind = this.modelObject.getKind();
        DbgModelNative.TypeKind tk = this.modelObject.getTypeKind();
        String value = this.modelObject.getValueString();
        attrs.put("_display", key);
        if (kind != null) {
            attrs.put("_kind", kind.toString());
        }
        if (tk != null) {
            attrs.put("_type", tk.toString());
        }
        if (value != null && !value.equals("")) {
            Object val;
            attrs.put("_value", value);
            if (!Objects.equals((Object)kind, (Object)DbgModelNative.ModelObjectKind.OBJECT_PROPERTY_ACCESSOR)) {
                Map map = this.attributes;
                synchronized (map) {
                    String oldval = (String)this.attributes.get("_display");
                    String newval = this.getName() + " : " + value;
                    attrs.put("_display", newval);
                    this.setModified(attrs, !newval.equals(oldval));
                }
            }
            if (tk == null && (val = this.modelObject.getIntrinsicValue()) != null) {
                attrs.put("_type", val.getClass().getSimpleName());
            }
        }
        if (this instanceof DelegateDbgModel2TargetObject) {
            DbgModelTargetThread targetThread;
            DbgThread thread;
            DelegateDbgModel2TargetObject delegate = (DelegateDbgModel2TargetObject)this;
            DbgModelTargetObject proxy = delegate.getProxy();
            if (proxy instanceof TargetAccessConditioned) {
                attrs.put("_accessible", this.accessible);
            }
            if (proxy instanceof TargetExecutionStateful && this.isValid()) {
                TargetExecutionStateful stateful = (TargetExecutionStateful)proxy;
                TargetExecutionStateful.TargetExecutionState state = stateful.getExecutionState();
                attrs.put("_state", state);
            }
            if (proxy instanceof TargetAttacher) {
                attrs.put("_supported_attach_kinds", DbgModelTargetProcessImpl.SUPPORTED_KINDS);
            }
            if (proxy instanceof TargetSteppable) {
                attrs.put("_supported_step_kinds", DbgModelTargetThreadImpl.SUPPORTED_KINDS);
            }
            if (proxy instanceof TargetInterpreter) {
                attrs.put("_prompt", this.DBG_PROMPT);
            }
            if (proxy instanceof TargetBreakpointSpecContainer) {
                attrs.put("_supported_breakpoint_kinds", TargetBreakpointSpecContainer.TargetBreakpointKindSet.of((TargetBreakpointSpec.TargetBreakpointKind[])TargetBreakpointSpec.TargetBreakpointKind.values()));
            }
            if (proxy instanceof TargetBreakpointSpec) {
                DbgModelTargetBreakpointSpec spec = (DbgModelTargetBreakpointSpec)proxy;
                return spec.init(attrs);
            }
            if (proxy instanceof TargetEnvironment) {
                attrs.put("_arch", "x86_64");
                attrs.put("_debugger", "dbgeng");
                attrs.put("_os", "Windows");
                attrs.put("_endian", "little");
            }
            if (proxy instanceof TargetModule) {
                DbgModelTargetModule module = (DbgModelTargetModule)proxy;
                return module.init(attrs);
            }
            if (proxy instanceof TargetProcess) {
                Object memory = this.attributes.containsKey("Memory") ? (DbgModelTargetMemoryContainer)this.attributes.get("Memory") : new DbgModelTargetMemoryContainerImpl((DbgModelTargetProcess)proxy);
                attrs.put(memory.getName(), memory);
                memory.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS);
            }
            if (proxy instanceof TargetThread && (thread = (targetThread = (DbgModelTargetThread)proxy).getThread()) != null) {
                String executionType = thread.getExecutingProcessorType().description;
                attrs.put("_arch", executionType);
            }
            if (proxy instanceof TargetRegister) {
                DbgModelTargetObject bank = (DbgModelTargetObject)this.getParent();
                TargetObject container = bank.getParent();
                attrs.put("_container", container);
            }
            if (proxy instanceof TargetRegisterBank) {
                attrs.put("_descriptions", this.getParent());
            }
            if (proxy instanceof TargetStackFrame) {
                DbgModelTargetStackFrame frame = (DbgModelTargetStackFrame)proxy;
                return frame.init(attrs);
            }
            if (proxy instanceof DbgModelTargetTTD) {
                DbgModelTargetTTD ttd = (DbgModelTargetTTD)proxy;
                return ttd.init(attrs);
            }
            if (proxy instanceof DbgModelTargetDebugContainer) {
                Object events = this.attributes.containsKey("Events") ? (DbgModelTargetEventContainer)this.attributes.get("Events") : new DbgModelTargetEventContainerImpl((DbgModelTargetDebugContainer)proxy);
                attrs.put(events.getName(), events);
                Object exceptions = this.attributes.containsKey("Exceptions") ? (DbgModelTargetExceptionContainer)this.attributes.get("Exceptions") : new DbgModelTargetExceptionContainerImpl((DbgModelTargetDebugContainer)proxy);
                attrs.put(exceptions.getName(), exceptions);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> fetchChild(String key) {
        Map map = this.elements;
        synchronized (map) {
            if (key.startsWith("[") && key.endsWith("]")) {
                String trimKey = key.substring(1, key.length() - 1);
                if (this.elements.containsKey(trimKey)) {
                    return CompletableFuture.completedFuture((TargetObject)this.elements.get(trimKey));
                }
                return this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenApply(__ -> (TargetObject)this.getCachedElements().get(trimKey));
            }
        }
        map = this.attributes;
        synchronized (map) {
            if (this.attributes.containsKey(key)) {
                return CompletableFuture.completedFuture(this.attributes.get(key));
            }
            if (key.endsWith(")")) {
                DbgManager2Impl manager2 = (DbgManager2Impl)this.getManager();
                List pathX = PathUtils.extend(List.of("Debugger"), (List)this.path);
                pathX = PathUtils.extend((List)pathX, (String)key);
                return manager2.applyMethods(pathX, this).thenApply(obj -> {
                    this.changeAttributes(List.of(), List.of(), Map.of(key, obj), "Initialized");
                    return obj;
                });
            }
            return this.requestAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER).thenApply(__ -> this.getCachedAttribute(key));
        }
    }

    public DbgModelSelectableObject getFocus() {
        return this.focus;
    }

    public Map<String, Object> getIntrinsics() {
        return this.intrinsics;
    }

    public void setModelObject(ModelObject modelObject) {
        this.modelObject = modelObject;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        ((CompletableFuture)this.addModelObjectAttributes(attrs).thenAccept(__ -> {
            if (this.isReallyValid() && !attrs.isEmpty()) {
                this.changeAttributes(List.of(), List.of(), attrs, "Refreshed");
            }
        })).exceptionally(ex -> {
            Msg.error((Object)((Object)this), (Object)("Problem setting model object" + PathUtils.toString((List)this.getPath()) + ": "), (Throwable)ex);
            return null;
        });
    }

    public DbgModelTargetSession getParentSession() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test.getProxy() instanceof DbgModelTargetSession); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetSession)test.getProxy();
    }

    public DbgModelTargetProcess getParentProcess() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test.getProxy() instanceof TargetProcess); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetProcess)test.getProxy();
    }

    public DbgModelTargetThread getParentThread() {
        DbgModelTargetObject test;
        for (test = (DbgModelTargetObject)this.parent; test != null && !(test.getProxy() instanceof TargetThread); test = (DbgModelTargetObject)test.getParent()) {
        }
        return test == null ? null : (DbgModelTargetThread)test.getProxy();
    }

    public void setModified(Map<String, Object> attrs, boolean modified) {
        if (modified) {
            attrs.put("_modified", modified);
        }
    }

    public void setModified(boolean modified) {
        if (modified) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", modified), "Refreshed");
        }
    }

    public void resetModified() {
        if (this.getCachedAttribute("_modified") != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_modified", false), "Refreshed");
        }
    }
}

