/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.impl.dbgmodel.main.KeyStoreInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectImpl;
import agent.dbgmodel.jna.dbgmodel.main.IKeyStore;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;

public class KeyStoreImpl
implements KeyStoreInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IKeyStore jnaData;

    public KeyStoreImpl(IKeyStore jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public ModelObject getKey(WString key) {
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKey(key, ppObject, ppMetadata));
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    @Override
    public void setKey(WString key, ModelObject object, KeyStore metadata) {
        Pointer pObject = object.getPointer();
        Pointer pMetadata = metadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKey(key, pObject, pMetadata));
    }

    @Override
    public ModelObject getKeyValue(WString key) {
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKeyValue(key, ppObject, ppMetadata));
        return ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
    }

    @Override
    public void setKeyValue(WString key, ModelObject object) {
        Pointer pObject = object.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKeyValue(key, pObject));
    }

    @Override
    public void clearKeys() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ClearKeys());
    }
}

