/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import java.awt.Font;

class WrappedFont
implements WrappedOption {
    private static final String FAMILY = "family";
    private static final String SIZE = "size";
    private static final String STYLE = "style";
    private Font font;

    WrappedFont(Font font) {
        this.font = font;
    }

    public WrappedFont() {
    }

    @Override
    public Object getObject() {
        return this.font;
    }

    @Override
    public void readState(SaveState saveState) {
        String family = saveState.getString(FAMILY, "monospaced");
        int size = saveState.getInt(SIZE, 12);
        int style = saveState.getInt(STYLE, 0);
        this.font = new Font(family, style, size);
    }

    @Override
    public void writeState(SaveState saveState) {
        String family = this.font.getFamily();
        int pos = family.indexOf(".");
        if (pos > 0) {
            family = family.substring(0, pos);
        }
        saveState.putString(FAMILY, family);
        saveState.putInt(SIZE, this.font.getSize());
        saveState.putInt(STYLE, this.font.getStyle());
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.FONT_TYPE;
    }
}

