/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ApplicationThemeDefaults;
import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GColor;
import generic.theme.GTheme;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconValue;
import generic.theme.LafType;
import generic.theme.PropertyFileThemeDefaults;
import generic.theme.ThemeEvent;
import generic.theme.ThemeListener;
import generic.theme.builtin.MacTheme;
import generic.theme.builtin.NimbusTheme;
import generic.theme.builtin.WindowsTheme;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.plaf.ComponentUI;
import resources.ResourceManager;
import utilities.util.reflection.ReflectionUtilities;

public abstract class ThemeManager {
    public static final String THEME_DIR = "themes";
    static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    static final Color DEFAULT_COLOR = Color.CYAN;
    private static final int MIN_FONT_SIZE = 3;
    protected static ThemeManager INSTANCE;
    protected GTheme activeTheme = ThemeManager.getDefaultTheme();
    protected LafType activeLafType = this.activeTheme.getLookAndFeelType();
    protected boolean useDarkDefaults = this.activeTheme.useDarkDefaults();
    protected GThemeValueMap javaDefaults = new GThemeValueMap();
    protected GThemeValueMap currentValues = new GThemeValueMap();
    protected ApplicationThemeDefaults applicationDefaults;
    private WeakSet<ThemeListener> themeListeners = WeakDataStructureFactory.createCopyOnReadWeakSet();

    public static ThemeManager getInstance() {
        return INSTANCE;
    }

    public ThemeManager() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.applicationDefaults = this.getApplicationDefaults();
    }

    protected ApplicationThemeDefaults getApplicationDefaults() {
        return new PropertyFileThemeDefaults();
    }

    protected void installInGui() {
        Gui.setThemeManager(this);
    }

    protected void buildCurrentValues() {
        GThemeValueMap map = new GThemeValueMap();
        map.load(this.javaDefaults);
        map.load(this.applicationDefaults.getLightValues());
        if (this.useDarkDefaults) {
            map.load(this.applicationDefaults.getDarkValues());
        }
        map.load(this.applicationDefaults.getLookAndFeelValues(this.getLookAndFeelType()));
        map.load(this.activeTheme);
        this.currentValues = map;
    }

    public void restoreThemeValues() {
        throw new UnsupportedOperationException();
    }

    public void restoreColor(String id) {
        throw new UnsupportedOperationException();
    }

    public void restoreFont(String id) {
        throw new UnsupportedOperationException();
    }

    public void restoreIcon(String id) {
        throw new UnsupportedOperationException();
    }

    public boolean isChangedColor(String id) {
        return false;
    }

    public boolean isChangedFont(String id) {
        return false;
    }

    public boolean isChangedIcon(String id) {
        return false;
    }

    public void setTheme(GTheme theme) {
        throw new UnsupportedOperationException();
    }

    public void setLookAndFeel(LafType lafType, boolean useDarkDefaults) {
        throw new UnsupportedOperationException();
    }

    public void addTheme(GTheme newTheme) {
        throw new UnsupportedOperationException();
    }

    public void deleteTheme(GTheme theme) {
        throw new UnsupportedOperationException();
    }

    public Set<GTheme> getAllThemes() {
        throw new UnsupportedOperationException();
    }

    public List<GTheme> getSupportedThemes() {
        throw new UnsupportedOperationException();
    }

    public GTheme getActiveTheme() {
        return this.activeTheme;
    }

    public LafType getLookAndFeelType() {
        return this.activeLafType;
    }

    public GTheme getTheme(String themeName) {
        throw new UnsupportedOperationException();
    }

    public GThemeValueMap getCurrentValues() {
        return new GThemeValueMap(this.currentValues);
    }

    public GThemeValueMap getThemeValues() {
        GThemeValueMap map = new GThemeValueMap();
        map.load(this.javaDefaults);
        map.load(this.applicationDefaults.getLightValues());
        if (this.useDarkDefaults) {
            map.load(this.applicationDefaults.getDarkValues());
        }
        map.load(this.applicationDefaults.getLookAndFeelValues(this.getLookAndFeelType()));
        map.load(this.activeTheme);
        return map;
    }

    public GThemeValueMap getNonDefaultValues() {
        return this.currentValues.getChangedValues(this.getDefaults());
    }

    public Color getColor(String id) {
        ColorValue color = this.currentValues.getColor(id);
        if (color == null) {
            this.error("No color value registered for: '" + id + "'");
            return DEFAULT_COLOR;
        }
        return (Color)color.get(this.currentValues);
    }

    public Font getFont(String id) {
        FontValue font = this.currentValues.getFont(id);
        if (font == null) {
            this.error("No color value registered for: '" + id + "'");
            return DEFAULT_FONT;
        }
        return font.get(this.currentValues);
    }

    public Icon getIcon(String id) {
        IconValue icon = this.currentValues.getIcon(id);
        if (icon == null) {
            this.error("No icon value registered for: '" + id + "'");
            return ResourceManager.getDefaultIcon();
        }
        return icon.get(this.currentValues);
    }

    public void setFont(String id, Font font) {
        this.setFont(new FontValue(id, font));
    }

    public void setFont(FontValue newValue) {
        throw new UnsupportedOperationException();
    }

    public void setColor(String id, Color color) {
        GColor gColor;
        if (color == null) {
            throw new IllegalArgumentException("Can't set theme value to null!");
        }
        if (color instanceof GColor && id.equals((gColor = (GColor)color).getId())) {
            Throwable t = new Throwable();
            Msg.error((Object)this, (Object)("Attempted to set a color for id \"" + id + "\" using a GColor defined using that same id! This would create a self reference!"), (Throwable)t);
            return;
        }
        this.setColor(new ColorValue(id, color));
    }

    public void setColor(ColorValue newValue) {
        throw new UnsupportedOperationException();
    }

    public void setIcon(String id, Icon icon) {
        this.setIcon(new IconValue(id, icon));
    }

    public void setIcon(IconValue newValue) {
        throw new UnsupportedOperationException();
    }

    public GThemeValueMap getJavaDefaults() {
        GThemeValueMap map = new GThemeValueMap();
        map.load(this.javaDefaults);
        return map;
    }

    public GThemeValueMap getApplicationDarkDefaults() {
        GThemeValueMap map = new GThemeValueMap(this.applicationDefaults.getLightValues());
        map.load(this.applicationDefaults.getDarkValues());
        map.load(this.applicationDefaults.getLookAndFeelValues(this.getLookAndFeelType()));
        return map;
    }

    public GThemeValueMap getApplicationLightDefaults() {
        GThemeValueMap map = new GThemeValueMap(this.applicationDefaults.getLightValues());
        map.load(this.applicationDefaults.getLookAndFeelValues(this.getLookAndFeelType()));
        return map;
    }

    public GThemeValueMap getDefaults() {
        GThemeValueMap currentDefaults = new GThemeValueMap(this.javaDefaults);
        currentDefaults.load(this.applicationDefaults.getLightValues());
        if (this.useDarkDefaults) {
            currentDefaults.load(this.applicationDefaults.getDarkValues());
        }
        currentDefaults.load(this.applicationDefaults.getLookAndFeelValues(this.getLookAndFeelType()));
        return currentDefaults;
    }

    public boolean isUsingAquaUI(ComponentUI UI) {
        return this.getLookAndFeelType() == LafType.MAC;
    }

    public boolean isUsingNimbusUI() {
        return this.getLookAndFeelType() == LafType.NIMBUS;
    }

    public void addThemeListener(ThemeListener listener) {
        this.themeListeners.add((Object)listener);
    }

    public void removeThemeListener(ThemeListener listener) {
        this.themeListeners.remove((Object)listener);
    }

    public boolean hasThemeChanges() {
        return false;
    }

    public boolean hasColor(String id) {
        return this.currentValues.containsColor(id);
    }

    public boolean hasFont(String id) {
        return this.currentValues.containsFont(id);
    }

    public boolean hasIcon(String id) {
        return this.currentValues.containsIcon(id);
    }

    public void registerFont(Component component, String fontId) {
    }

    public boolean isDarkTheme() {
        return this.useDarkDefaults;
    }

    public static GTheme getDefaultTheme() {
        OperatingSystem OS = Platform.CURRENT_PLATFORM.getOperatingSystem();
        switch (OS) {
            case MAC_OS_X: {
                return new MacTheme();
            }
            case WINDOWS: {
                return new WindowsTheme();
            }
        }
        return new NimbusTheme();
    }

    protected void notifyThemeChanged(ThemeEvent event) {
        for (ThemeListener listener : this.themeListeners) {
            listener.themeChanged(event);
        }
    }

    protected void error(String message) {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{ThemeManager.class});
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace((StackTraceElement[])trace, (String[])new String[]{"java.", "theme.Gui", "theme.ThemeManager", "theme.GColor"});
        t.setStackTrace(filtered);
        Msg.error((Object)this, (Object)message, (Throwable)t);
    }

    public void adjustFonts(int amount) {
        List<FontValue> fonts = this.currentValues.getFonts();
        for (FontValue fontValue : fonts) {
            Font directFont = (Font)fontValue.getRawValue();
            if (directFont == null) continue;
            int currentSize = directFont.getSize();
            int newSize = Math.max(3, currentSize += amount);
            this.setFont(fontValue.getId(), directFont.deriveFont((float)newSize));
        }
    }
}

