/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLightLaf;
import generic.theme.AllValuesChangedThemeEvent;
import generic.theme.ColorChangedThemeEvent;
import generic.theme.ColorValue;
import generic.theme.DiscoverableGTheme;
import generic.theme.FontChangedThemeEvent;
import generic.theme.FontValue;
import generic.theme.GColor;
import generic.theme.GColorUIResource;
import generic.theme.GIcon;
import generic.theme.GTheme;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import generic.theme.IconChangedThemeEvent;
import generic.theme.IconValue;
import generic.theme.LafType;
import generic.theme.ThemeManager;
import generic.theme.ThemePreferences;
import generic.theme.ThemeReader;
import generic.theme.laf.LookAndFeelManager;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class ApplicationThemeManager
extends ThemeManager {
    private Set<GTheme> allThemes = null;
    protected ThemePreferences themePreferences = new ThemePreferences();
    private Map<String, GColorUIResource> gColorMap = new HashMap<String, GColorUIResource>();
    private GThemeValueMap changedValuesMap = new GThemeValueMap();
    protected LookAndFeelManager lookAndFeelManager;

    public static void initialize() {
        if (INSTANCE instanceof ApplicationThemeManager) {
            Msg.error(ApplicationThemeManager.class, (Object)"Attempted to initialize theming more than once!");
            return;
        }
        ApplicationThemeManager themeManager = new ApplicationThemeManager();
        themeManager.doInitialize();
    }

    protected ApplicationThemeManager() {
        INSTANCE = this;
        this.installInGui();
    }

    protected void doInitialize() {
        this.installFlatLookAndFeels();
        this.setTheme(this.themePreferences.load());
    }

    @Override
    public void restoreThemeValues() {
        this.applicationDefaults = this.getApplicationDefaults();
        this.buildCurrentValues();
        this.lookAndFeelManager.resetAll(this.javaDefaults);
        this.notifyThemeChanged(new AllValuesChangedThemeEvent(false));
    }

    @Override
    public void restoreColor(String id) {
        if (this.changedValuesMap.containsColor(id)) {
            this.setColor(this.changedValuesMap.getColor(id));
        }
    }

    @Override
    public void restoreFont(String id) {
        if (this.changedValuesMap.containsFont(id)) {
            this.setFont(this.changedValuesMap.getFont(id));
        }
    }

    @Override
    public void restoreIcon(String id) {
        if (this.changedValuesMap.containsIcon(id)) {
            this.setIcon(this.changedValuesMap.getIcon(id));
        }
    }

    @Override
    public boolean isChangedColor(String id) {
        return this.changedValuesMap.containsColor(id);
    }

    @Override
    public boolean isChangedFont(String id) {
        return this.changedValuesMap.containsFont(id);
    }

    @Override
    public boolean isChangedIcon(String id) {
        return this.changedValuesMap.containsIcon(id);
    }

    @Override
    public void setTheme(GTheme theme) {
        if (theme.hasSupportedLookAndFeel()) {
            this.activeTheme = theme;
            this.activeLafType = theme.getLookAndFeelType();
            this.useDarkDefaults = theme.useDarkDefaults();
            this.cleanUiDefaults();
            this.lookAndFeelManager = this.activeLafType.getLookAndFeelManager(this);
            try {
                this.lookAndFeelManager.installLookAndFeel();
                this.notifyThemeChanged(new AllValuesChangedThemeEvent(true));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Error setting Look and Feel: " + this.activeLafType.getName()), (Throwable)e);
            }
            this.themePreferences.save(theme);
        }
        this.currentValues.checkForUnresolvedReferences();
    }

    @Override
    public void setLookAndFeel(LafType lafType, boolean useDarkDefaults) {
        if (!lafType.isSupported()) {
            Msg.error((Object)this, (Object)("Attempted to set unsupported Look and Feel: " + lafType));
            return;
        }
        this.activeLafType = lafType;
        this.useDarkDefaults = useDarkDefaults;
        this.cleanUiDefaults();
        this.lookAndFeelManager = lafType.getLookAndFeelManager(this);
        try {
            this.lookAndFeelManager.installLookAndFeel();
            this.notifyThemeChanged(new AllValuesChangedThemeEvent(true));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error setting Look and Feel: " + lafType.getName()), (Throwable)e);
        }
    }

    @Override
    public void addTheme(GTheme newTheme) {
        this.loadThemes();
        this.allThemes.remove(newTheme);
        this.allThemes.add(newTheme);
    }

    @Override
    public void deleteTheme(GTheme theme) {
        File file = theme.getFile();
        if (file != null) {
            file.delete();
        }
        if (this.allThemes != null) {
            this.allThemes.remove(theme);
        }
    }

    @Override
    public Set<GTheme> getAllThemes() {
        this.loadThemes();
        return new HashSet<GTheme>(this.allThemes);
    }

    @Override
    public List<GTheme> getSupportedThemes() {
        this.loadThemes();
        ArrayList<GTheme> supported = new ArrayList<GTheme>();
        for (GTheme theme : this.allThemes) {
            if (!theme.hasSupportedLookAndFeel()) continue;
            supported.add(theme);
        }
        Collections.sort(supported, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        return supported;
    }

    @Override
    public GTheme getTheme(String themeName) {
        Optional<GTheme> first = this.getAllThemes().stream().filter(t -> t.getName().equals(themeName)).findFirst();
        return first.orElse(null);
    }

    @Override
    public void setFont(FontValue newValue) {
        FontValue currentValue = this.currentValues.getFont(newValue.getId());
        if (newValue.equals(currentValue)) {
            return;
        }
        this.updateChangedValuesMap(currentValue, newValue);
        this.currentValues.addFont(newValue);
        String id = newValue.getId();
        Set<String> changedFontIds = this.findChangedJavaFontIds(id);
        this.lookAndFeelManager.fontsChanged(changedFontIds);
        this.notifyThemeChanged(new FontChangedThemeEvent(this.currentValues, newValue));
    }

    @Override
    public void setColor(ColorValue newValue) {
        ColorValue currentValue = this.currentValues.getColor(newValue.getId());
        if (newValue.equals(currentValue)) {
            return;
        }
        this.updateChangedValuesMap(currentValue, newValue);
        this.currentValues.addColor(newValue);
        this.notifyThemeChanged(new ColorChangedThemeEvent(this.currentValues, newValue));
        this.lookAndFeelManager.colorsChanged();
    }

    @Override
    public void setIcon(IconValue newValue) {
        IconValue currentValue = this.currentValues.getIcon(newValue.getId());
        if (newValue.equals(currentValue)) {
            return;
        }
        this.updateChangedValuesMap(currentValue, newValue);
        this.currentValues.addIcon(newValue);
        String id = newValue.getId();
        Set<String> changedIconIds = this.findChangedJavaIconIds(id);
        Icon newIcon = newValue.get(this.currentValues);
        this.lookAndFeelManager.iconsChanged(changedIconIds, newIcon);
        this.notifyThemeChanged(new IconChangedThemeEvent(this.currentValues, newValue));
    }

    public GColorUIResource getGColorUiResource(String id) {
        GColorUIResource gColor = this.gColorMap.get(id);
        if (gColor == null) {
            gColor = new GColorUIResource(id);
            this.gColorMap.put(id, gColor);
        }
        return gColor;
    }

    public void setJavaDefaults(GThemeValueMap map) {
        this.javaDefaults = map;
        this.buildCurrentValues();
        GColor.refreshAll(this.currentValues);
        GIcon.refreshAll(this.currentValues);
    }

    @Override
    public boolean hasThemeChanges() {
        if (!this.changedValuesMap.isEmpty()) {
            return true;
        }
        return this.lookAndFeelManager.getLookAndFeelType() != this.activeTheme.getLookAndFeelType();
    }

    @Override
    public void registerFont(Component component, String fontId) {
        this.lookAndFeelManager.registerFont(component, fontId);
    }

    private void installFlatLookAndFeels() {
        UIManager.installLookAndFeel(LafType.FLAT_LIGHT.getName(), FlatLightLaf.class.getName());
        UIManager.installLookAndFeel(LafType.FLAT_DARK.getName(), FlatDarkLaf.class.getName());
    }

    @Override
    protected void buildCurrentValues() {
        super.buildCurrentValues();
        this.changedValuesMap.clear();
    }

    private void loadThemes() {
        if (this.allThemes == null) {
            HashSet<GTheme> set = new HashSet<GTheme>();
            set.addAll(this.findDiscoverableThemes());
            set.addAll(this.loadThemeFiles());
            this.allThemes = set;
        }
    }

    protected Collection<GTheme> loadThemeFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        FileFilter themeFileFilter = file -> file.getName().endsWith("." + GTheme.FILE_EXTENSION);
        File dir = Application.getUserSettingsDirectory();
        File themeDir = new File(dir, "themes");
        File[] files = themeDir.listFiles(themeFileFilter);
        if (files != null) {
            fileList.addAll(Arrays.asList(files));
        }
        ArrayList<GTheme> list = new ArrayList<GTheme>();
        for (File file2 : fileList) {
            GTheme theme = ApplicationThemeManager.loadTheme(file2);
            if (theme == null) continue;
            list.add(theme);
        }
        return list;
    }

    private static GTheme loadTheme(File file) {
        try {
            return new ThemeReader(file).readTheme();
        }
        catch (IOException e) {
            Msg.error(Gui.class, (Object)("Could not load theme from file: " + file.getAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    private Collection<DiscoverableGTheme> findDiscoverableThemes() {
        return ClassSearcher.getInstances(DiscoverableGTheme.class);
    }

    private void updateChangedValuesMap(ColorValue currentValue, ColorValue newValue) {
        String id = newValue.getId();
        ColorValue originalValue = this.changedValuesMap.getColor(id);
        if (newValue.equals(originalValue)) {
            this.changedValuesMap.removeColor(id);
        } else if (originalValue == null) {
            this.changedValuesMap.addColor(currentValue);
        }
    }

    private void updateChangedValuesMap(FontValue currentValue, FontValue newValue) {
        String id = newValue.getId();
        FontValue originalValue = this.changedValuesMap.getFont(id);
        if (newValue.equals(originalValue)) {
            this.changedValuesMap.removeFont(id);
        } else if (originalValue == null) {
            this.changedValuesMap.addFont(currentValue);
        }
    }

    private void updateChangedValuesMap(IconValue currentValue, IconValue newValue) {
        String id = newValue.getId();
        IconValue originalValue = this.changedValuesMap.getIcon(id);
        if (newValue.equals(originalValue)) {
            this.changedValuesMap.removeIcon(id);
        } else if (originalValue == null) {
            this.changedValuesMap.addIcon(currentValue);
        }
    }

    private Set<String> findChangedJavaFontIds(String id) {
        HashSet<String> affectedIds = new HashSet<String>();
        List<FontValue> fonts = this.javaDefaults.getFonts();
        for (FontValue fontValue : fonts) {
            String fontId = fontValue.getId();
            FontValue currentFontValue = this.currentValues.getFont(fontId);
            if (!fontId.equals(id) && !currentFontValue.inheritsFrom(id, this.currentValues)) continue;
            affectedIds.add(fontId);
        }
        return affectedIds;
    }

    private Set<String> findChangedJavaIconIds(String id) {
        HashSet<String> affectedIds = new HashSet<String>();
        List<IconValue> icons = this.javaDefaults.getIcons();
        for (IconValue iconValue : icons) {
            String iconId = iconValue.getId();
            if (!iconId.equals(id) && !iconValue.inheritsFrom(id, this.currentValues)) continue;
            affectedIds.add(iconId);
        }
        return affectedIds;
    }

    public void refreshGThemeValues() {
        GColor.refreshAll(this.currentValues);
        GIcon.refreshAll(this.currentValues);
    }

    private void cleanUiDefaults() {
        UIDefaults defaults = UIManager.getDefaults();
        defaults.clear();
    }
}

