/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbManager;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.GdbStateListener;
import agent.gdb.manager.impl.cmd.GdbCommandError;
import agent.gdb.model.impl.GdbModelTargetSession;
import agent.gdb.pty.PtyFactory;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerModelClosedReason;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.AnnotatedSchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class GdbModelImpl
extends AbstractDebuggerObjectModel {
    protected static final String SPACE_NAME = "ram";
    protected static final AnnotatedSchemaContext SCHEMA_CTX = new AnnotatedSchemaContext();
    protected static final TargetObjectSchema ROOT_SCHEMA = SCHEMA_CTX.getSchemaForClass(GdbModelTargetSession.class);
    protected final AddressSpace space = new GenericAddressSpace("ram", 64, 1, 0);
    protected final AddressFactory addressFactory = new DefaultAddressFactory(new AddressSpace[]{this.space});
    protected final GdbManager gdb;
    protected final GdbModelTargetSession session;
    private volatile boolean closed;
    protected final CompletableFuture<GdbModelTargetSession> completedSession;
    protected final GdbStateListener gdbExitListener = this::checkExited;
    protected Map<Object, TargetObject> objectMap = new HashMap<Object, TargetObject>();

    protected static <T> T translateEx(Throwable ex) {
        Throwable t = AsyncUtils.unwrapThrowable((Throwable)ex);
        if (t instanceof GdbCommandError) {
            GdbCommandError err = (GdbCommandError)t;
            throw new DebuggerUserException(err.getInfo().getString("msg"));
        }
        return (T)ExceptionUtils.rethrow((Throwable)ex);
    }

    public GdbModelImpl(PtyFactory ptyFactory) {
        this.gdb = GdbManager.newInstance(ptyFactory);
        this.session = new GdbModelTargetSession(this, ROOT_SCHEMA);
        this.completedSession = CompletableFuture.completedFuture(this.session);
        this.gdb.addStateListener(this.gdbExitListener);
        this.addModelRoot((SpiTargetObject)this.session);
    }

    public TargetObjectSchema getRootSchema() {
        return ROOT_SCHEMA;
    }

    public String getBrief() {
        return "GDB@" + Integer.toHexString(System.identityHashCode((Object)this)) + " " + this.gdb.getPtyDescription();
    }

    public AddressSpace getAddressSpace(String name) {
        if (!SPACE_NAME.equals(name)) {
            return null;
        }
        return this.space;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    protected void checkExited(GdbState state, GdbCause cause) {
        switch (state) {
            case NOT_STARTED: {
                break;
            }
            case STARTING: {
                break;
            }
            case RUNNING: {
                this.session.setAccessible(false);
                break;
            }
            case STOPPED: {
                this.session.setAccessible(true);
                break;
            }
            case EXIT: {
                try {
                    this.terminate();
                    break;
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    public void setUnixNewLine() {
        this.gdb.setUnixNewLine();
    }

    public void setDosNewLine() {
        this.gdb.setDosNewLine();
    }

    public CompletableFuture<Void> startGDB(String gdbCmd, String[] args) {
        return CompletableFuture.runAsync(() -> {
            try {
                if (this.closed) {
                    return;
                }
                this.gdb.start(gdbCmd, args);
            }
            catch (IOException e) {
                if (this.closed) {
                    return;
                }
                throw new DebuggerModelTerminatingException("Error while starting GDB: " + e.getMessage(), (Throwable)e);
            }
        }).thenCompose(__ -> {
            if (this.closed) {
                return AsyncUtils.NIL;
            }
            return this.gdb.runRC();
        });
    }

    public void consoleLoop() throws IOException {
        this.gdb.consoleLoop();
    }

    public void terminate() throws IOException {
        ((DebuggerModelListener)this.listeners.fire).modelClosed(DebuggerModelClosedReason.NORMAL);
        this.session.invalidateSubtree((TargetObject)this.session, "GDB is terminating");
        this.gdb.terminate();
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot() {
        return this.completedSession;
    }

    public boolean isAlive() {
        return this.gdb.getState().isAlive();
    }

    public CompletableFuture<Void> close() {
        this.closed = true;
        try {
            this.terminate();
            return super.close();
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    public void addModelObject(Object object, TargetObject targetObject) {
        this.objectMap.put(object, targetObject);
    }

    public TargetObject getModelObject(Object object) {
        return this.objectMap.get(object);
    }

    public void deleteModelObject(Object object) {
        this.objectMap.remove(object);
    }
}

