/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.generators.EvolvingGraphGenerator;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class BarabasiAlbertGenerator<V, E>
implements EvolvingGraphGenerator<V, E> {
    private Graph<V, E> mGraph = null;
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected List<V> vertex_index;
    protected int init_vertices;
    protected Map<V, Integer> index_vertex;
    protected Supplier<Graph<V, E>> graphFactory;
    protected Supplier<V> vertexFactory;
    protected Supplier<E> edgeFactory;

    public BarabasiAlbertGenerator(Supplier<Graph<V, E>> graphFactory, Supplier<V> vertexFactory, Supplier<E> edgeFactory, int init_vertices, int numEdgesToAttach, int seed, Set<V> seedVertices) {
        Preconditions.checkArgument((init_vertices > 0 ? 1 : 0) != 0, (Object)"Number of initial unconnected 'seed' vertices must be positive");
        Preconditions.checkArgument((numEdgesToAttach > 0 ? 1 : 0) != 0, (Object)"Number of edges to attach at each time step must be positive");
        Preconditions.checkArgument((numEdgesToAttach <= init_vertices ? 1 : 0) != 0, (Object)"Number of edges to attach at each time step must less than or equal to the number of initial vertices");
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.init_vertices = init_vertices;
        this.initialize(seedVertices);
    }

    public BarabasiAlbertGenerator(Supplier<Graph<V, E>> graphFactory, Supplier<V> vertexFactory, Supplier<E> edgeFactory, int init_vertices, int numEdgesToAttach, Set<V> seedVertices) {
        this(graphFactory, vertexFactory, edgeFactory, init_vertices, numEdgesToAttach, (int)System.currentTimeMillis(), seedVertices);
    }

    private void initialize(Set<V> seedVertices) {
        this.mGraph = (Graph)this.graphFactory.get();
        this.vertex_index = new ArrayList<V>(2 * this.init_vertices);
        this.index_vertex = new HashMap<V, Integer>(2 * this.init_vertices);
        for (int i = 0; i < this.init_vertices; ++i) {
            Object v = this.vertexFactory.get();
            this.mGraph.addVertex(v);
            this.vertex_index.add(v);
            this.index_vertex.put((Integer)v, i);
            seedVertices.add(v);
        }
        this.mElapsedTimeSteps = 0;
    }

    @Override
    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            this.evolveGraph();
            ++this.mElapsedTimeSteps;
        }
    }

    private void evolveGraph() {
        Collection preexistingNodes = this.mGraph.getVertices();
        Object newVertex = this.vertexFactory.get();
        this.mGraph.addVertex(newVertex);
        Set<Pair<Object>> added_pairs = this.createRandomEdges(preexistingNodes, newVertex, this.mNumEdgesToAttachPerStep);
        for (Pair<Object> pair : added_pairs) {
            Object v1 = pair.getFirst();
            Object v2 = pair.getSecond();
            if (this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED && this.mGraph.isNeighbor(v1, v2)) continue;
            this.mGraph.addEdge(this.edgeFactory.get(), pair);
        }
        this.vertex_index.add(newVertex);
        this.index_vertex.put((Integer)newVertex, new Integer(this.vertex_index.size() - 1));
    }

    private Set<Pair<V>> createRandomEdges(Collection<V> preexistingNodes, V newVertex, int numEdges) {
        HashSet<Pair<V>> added_pairs = new HashSet<Pair<V>>(numEdges * 3);
        HashMap<V, Double> item_weights = new HashMap<V, Double>();
        for (V v : preexistingNodes) {
            double denominator;
            double degree;
            if (v == newVertex) continue;
            if (this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED) {
                degree = this.mGraph.degree(v);
                denominator = 2 * this.mGraph.getEdgeCount() + this.mGraph.getVertexCount() - 1;
            } else {
                degree = this.mGraph.inDegree(v);
                denominator = this.mGraph.getEdgeCount() + this.mGraph.getVertexCount() - 1;
            }
            double prob = (degree + 1.0) / denominator;
            item_weights.put(v, prob);
        }
        WeightedChoice nodeProbabilities = new WeightedChoice(item_weights, this.mRandom);
        for (int i = 0; i < numEdges; ++i) {
            this.createRandomEdge(preexistingNodes, newVertex, added_pairs, nodeProbabilities);
        }
        return added_pairs;
    }

    private void createRandomEdge(Collection<V> preexistingNodes, V newVertex, Set<Pair<V>> added_pairs, WeightedChoice<V> weightedProbabilities) {
        Pair<V> endpoints;
        V attach_point;
        boolean created_edge = false;
        do {
            attach_point = weightedProbabilities.nextItem();
            endpoints = new Pair<V>(newVertex, attach_point);
            if (!(this.mGraph instanceof MultiGraph) && (added_pairs.contains(endpoints) || this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED && added_pairs.contains(new Pair<V>(attach_point, newVertex)))) continue;
            created_edge = true;
        } while (!created_edge);
        added_pairs.add(endpoints);
        if (this.mGraph.getDefaultEdgeType() == EdgeType.UNDIRECTED) {
            added_pairs.add(new Pair<V>(attach_point, newVertex));
        }
    }

    @Override
    public int numIterations() {
        return this.mElapsedTimeSteps;
    }

    public Graph<V, E> get() {
        return this.mGraph;
    }
}

