/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.jparted.app;

import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

/**
 *
 * @author  erik
 */
public class TreeViewConcept extends javax.swing.JPanel {

    /** Creates new form TreeViewConcept */
    public TreeViewConcept() {
        initComponents();
        
        DefaultMutableTreeNode rootNode =
                new DefaultMutableTreeNode("File [/Users/erik/totalimage.dmg]", true);
        
        DefaultMutableTreeNode udifNode =
                new DefaultMutableTreeNode("UDIF Backing Store [type=UDBZ]", true);
        rootNode.add(udifNode);
        
        DefaultMutableTreeNode mbrNode =
                new DefaultMutableTreeNode("MBR Partition Table [4 partitions]", true);
        udifNode.add(mbrNode);
        
        {
            mbrNode.add(new DefaultMutableTreeNode("1. Microsoft Basic Data", false));

            mbrNode.add(new DefaultMutableTreeNode("2. HFS+ File System", false));

            DefaultMutableTreeNode lvmNode =
                    new DefaultMutableTreeNode("3. Linux LVM Volume Manager [3 partitions]", true);
            mbrNode.add(lvmNode);
            {
                lvmNode.add(new DefaultMutableTreeNode("1. Linux Ext3 File System", false));

                lvmNode.add(new DefaultMutableTreeNode("2. Linux Swap Partition", false));

                lvmNode.add(new DefaultMutableTreeNode("3. Linux ReiserFS File System", false));
            }
            DefaultMutableTreeNode dosxNode =
                    new DefaultMutableTreeNode("4. DOS Extended Partition Table [2 partitions]", true);
            mbrNode.add(dosxNode);
            {
                dosxNode.add(new DefaultMutableTreeNode("1. FAT32 File System", false));

                dosxNode.add(new DefaultMutableTreeNode("2. FAT16 File System", false));
            }
        }
       
        DefaultMutableTreeNode gptNode =
                new DefaultMutableTreeNode("GPT Partition Table [6 partitions]", true);
        udifNode.add(gptNode);
        
        {
            gptNode.add(new DefaultMutableTreeNode("1. Microsoft Basic Data", false));

            gptNode.add(new DefaultMutableTreeNode("2. HFS+ File System", false));

            DefaultMutableTreeNode lvmNode =
                    new DefaultMutableTreeNode("3. Linux LVM Volume Manager [3 partitions]", true);
            gptNode.add(lvmNode);
            {
                lvmNode.add(new DefaultMutableTreeNode("1. Linux Ext3 File System", false));

                lvmNode.add(new DefaultMutableTreeNode("2. Linux Swap Partition", false));

                lvmNode.add(new DefaultMutableTreeNode("3. Linux ReiserFS File System", false));
            }
            gptNode.add(new DefaultMutableTreeNode("4. FAT32 File System", false));

            gptNode.add(new DefaultMutableTreeNode("5. FAT16 File System", false));
        }
        /*
        DefaultMutableTreeNode Node =
                new DefaultMutableTreeNode("", true);
        Node.add(Node);
        */
        
        jTree1.setModel(new DefaultTreeModel(rootNode));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();

        jTree1.setModel(null);
        jScrollPane1.setViewportView(jTree1);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 360, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 183, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(112, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables
    
    public static void main(String[] args) {
        JFrame w = new JFrame("jParted Tree view concept");
        w.add(new TreeViewConcept());
        w.pack();
        w.setLocationRelativeTo(null);
        w.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        w.setVisible(true);
    }
}
