/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
static char message[] = {
0x23,                                     
0x14,                                     
0x14,                                     
0x37,                                     
0x8E,                                     
0x86,                                     
0xE5,                                     
0xC0,                                     
0x3A,                                     
0x64,                                     
0x1E,                                     
0x54,                                     
0x6B,                                     
0x85,                                     
0xBD,                                     
0xC1,                                     
0xF5,                                     
0x4C,                                     
0xA,                                      
0x4A,                                     
0x62,                                     
0x7E,                                     
0xC3,                                     
0xF8,                                     
0x93,                                     
0xC4,                                     
0x37,                                     
0x6A,                                     
0x6A,                                     
0x66,                                     
0x8E,                                     
0xB4,                                     
0xBD,                                     
0x8D,                                     
0x97,                                     
0x20,                                     
0x5,                                      
0x75,                                     
0x2C,                                     
0xCF,                                     
0xED,                                     
0x92,                                     
0xC1,                                     
0xF7,                                     
0x11,                                     
0x2F,                                     
0x57,                                     
0x71,                                     
0x89,                                     
0xB9,                                     
0xC0,                                     
0xA2,                                     
0x1E,                                     
0xF,                                      
0x33,                                     
0x5C,                                     
0x76,                                     
0x9E,                                     
0xCA,                                     
0x89,                                     
0xFB,                                     
0x40,                                     
0x35,                                     
0x16,                                     
0x57,                                     
0x3C,                                     
0x92,                                     
0xE2,                                     
0x97,                                     
0x97,                                     
0xF,                                      
0x6E,                                     
0x59,                                     
0x6C,                                     
0x7F,                                     
0xC8,                                     
0xFF,                                     
0xF6,                                     
0x94,                                     
0x1,                                      
0x2E,                                     
0xC,                                      
0x67,                                     
0x82,                                     
0xA1,                                     
0xB6,                                     
0xD6,                                     
0xAC,                                     
0x52,                                     
0x76,                                     
0x5E,                                     
0x78,                                     
0x85,                                     
0x4,                                      
0xCE,                                     
0xED,                                     
0xF9,                                     
0xB,                                      
0x25,                                     
0x10,                                     
0xF4,                                     
0x89,                                     
0xA5,                                     
0x8E,                                     
0xF0,                                     
0xA,                                      
0x11,                                     
0x37,                                     
0x59,                                     
0x65,                                     
0xEC,                                     
0x3C,                                     
0xCA,                                     
0x64,                                     
0x2E,                                     
0x35,                                     
0x4F,                                     
0x59,                                     
0x73,                                     
0x99,                                     
0xBD,                                     
0xC1,                                     
0x5E,                                     
0x1,                                      
0x6F,                                     
0xF5,                                     
0x75,                                     
0x4,                                      
0x93,                                     
0xBF,                                     
0x60,                                     
0x7A,                                     
0x24,                                     
0x13,                                     
0x7D,                                     
0x5C,                                     
0x97,                                     
0xE5,                                     
0xEC,                                     
0x9A,                                     
0xE8,                                     
0x12,                                     
0x80,                                     
0x91,                                     
0x78,                                     
0x5F,                                     
0xFF,                                     
0xD2,                                     
0x34,                                     
0xF5,                                     
0x5D,                                     
0x32,                                     
0x58,                                     
0x7C,                                     
0x99,                                     
0xA1,                                     
0x88,                                     
0xA0,                                     
0x18,                                     
0x34,                                     
0x2E,                                     
0x1C,                                     
0x65,                                     
0x2C,                                     
0x28,                                     
0xC5,                                     
0xF9,                                     
0xA6,                                     
0x9D,                                     
0x49,                                     
0x50,                                     
0xCA,                                     
0x14,                                     
0x39,                                     
0x42,                                     
0x63,                                     
0x98,                                     
0x42,                                     
0x44,                                     
0x23,                                     
0x8E,                                     
0x79,                                     
0x22,                                     
0xCE,                                     
0xA8,                                     
0x54,                                     
0x21,                                     
0xC1,                                     
0x78,                                     
0xC0,                                     
0x22,                                     
0xCB,                                     
0xD9,                                     
0xFF,                                     
0x17,                                     
0x36,                                     
0x4,                                      
0xC7,                                     
0xCA,                                     
0xC6,                                     
0xB5,                                     
0xA4,                                     
0xDD,                                     
0xDF,                                     
0xF5,                                     
0x61,                                     
0x44,                                     
0xD2,                                     
0x67,                                     
0x3F,                                     
0x75,                                     
0xEC,                                     
0xD9,                                     
0xA9,                                     
0x1D,                                     
0x76,                                     
0x94,                                     
0xA1,                                     
0x53,                                     
0x4B,                                     
0x91,                                     
0x43,                                     
0x5,                                      
0x64,                                     
0x70,                                     
0x98,                                     
0xE0,                                     
0xDB,                                     
0x44,                                     
0x96,                                     
0x20,                                     
0x30,                                     
0xD0,                                     
0x93,                                     
0xD8,                                     
0xB9,                                     
0x62,                                     
0xFA,                                     
0x55,                                     
0x1C,                                     
0x4A,                                     
0xF,                                      
0x81,                                     
0xA3,                                     
0x5D,                                     
0x47,                                     
0xF8,                                     
0x1B,                                     
0xE1,                                     
0x40,                                     
0x7D,                                     
0x7F,                                     
0x7,                                      
0xE4,                                     
0xF1,                                     
0x11,                                     
0x1D,                                     
0xEF,                                     
0xCE,                                     
0x79,                                     
0x9,                                      
0x8D,                                     
0xDF,                                     
0xB4,                                     
0x7F,                                     
0x3C,                                     
0x26,                                     
0x4D,                                     
0x79,                                     
0xD4,                                     
0x3F,                                     
0x56,                                     
0xAB,                                     
0xB,                                      
0x9C,                                     
0xC9,                                     
0xC8,                                     
0x39,                                     
0x89,                                     
0xAC,                                     
0xC7,                                     
0x0,                                      
0xD,                                      
0x99,                                     
0xD1,                                     
0xAE,                                     
0xC5,                                     
0xAD,                                     
0xD5,                                     
0xD8,                                     
0xF9,                                     
0xD5,                                     
0x33,                                     
0xCA,                                     
0x79,                                     
0x84,                                     
0xB1,                                     
0xC4,                                     
0xD9,                                     
0x8F,                                     
0x14,                                     
0x30,                                     
0x15,                                     
0xED,                                     
0x47,                                     
0xEC,                                     
0xEB,                                     
0x81,                                     
0x7A,                                     
0xF,                                      
0x5E,                                     
0x5A,                                     
0x26,                                     
0x90,                                     
0x1,                                      
0x18,                                     
0xEF,                                     
0xC4,                                     
0x62,                                     
0x7,                                      
0x7B,                                     
0x68,                                     
0x73,                                     
0xC8,                                     
0xAF,                                     
0x6E,                                     
0x6E,                                     
0xC1,                                     
0xF7,                                     
0xBA,                                     
0xE7,                                     
0x68,                                     
0xBB,                                     
0x81,                                     
0xFC,                                     
0x45,                                     
0x3F,                                     
0x52,                                     
0x33,                                     
0x80,                                     
0xAD,                                     
0x32,                                     
0x75,                                     
0x2C,                                     
0xCD,                                     
0x32,                                     
0x92,                                     
0x15,                                     
0x3D,                                     
0xE0,                                     
0xCD,                                     
0xEF,                                     
0xF5,                                     
0xB9,                                     
0xAE,                                     
0x59,                                     
0x8B,                                     
0x36,                                     
0x10,                                     
0x55,                                     
0x60,                                     
0xAA,                                     
0x91,                                     
0x4B,                                     
0xC4,                                     
0x70,                                     
0x7A,                                     
0xD,                                      
0xC2,                                     
0x18,                                     
0x9F,                                     
0x71,                                     
0x8B,                                     
0x18,                                     
0x7A,                                     
0x23,                                     
0x38,                                     
0x7B,                                     
0xB,                                      
0x16,                                     
0xED,                                     
0xF2,                                     
0xCB,                                     
0xC6,                                     
0x99,                                     
0xB7,                                     
0xD5,                                     
0xA3,                                     
0x1E,                                     
0x9B,                                     
0xB1,                                     
0x64,                                     
0x81,                                     
0xB0,                                     
0xAD,                                     
0x46,                                     
0xFD,                                     
0x54,                                     
0xDF,                                     
0xBE,                                     
0x84,                                     
0x38,                                     
0x7F,                                     
0x5C,                                     
0xE0,                                     
0xA6,                                     
0x3D,                                     
0x2A,                                     
0xB1,                                     
0xE,                                      
0xF1,                                     
0x2C,                                     
0xAC,                                     
0xA4,                                     
0x45,                                     
0xC0,                                     
0x88,                                     
0xC2,                                     
0xE,                                      
0x20,                                     
0x7B,                                     
0x88,                                     
0xE8,                                     
0xAA,                                     
0x23,                                     
0x92,                                     
0x84,                                     
0xA8,                                     
0x15,                                     
0x18,                                     
0xBB,                                     
0x8D,                                     
0xD5,                                     
0x6C,                                     
0x49,                                     
0xA7,                                     
0x81,                                     
0xFD,                                     
0xBB,                                     
0xD7,                                     
0x90,                                     
0x16,                                     
0x3D,                                     
0xC2,                                     
0x6C,                                     
0x52,                                     
0xAB,                                     
0xC6,                                     
0xDA,                                     
0x4F,                                     
0x6,                                      
0x76,                                     
0x17,                                     
0xF3,                                     
0xCD,                                     
0xAB,                                     
0x67,                                     
0xEE,                                     
0x38,                                     
0x48,                                     
0x3D,                                     
0xC8,                                     
0xCD,                                     
0x9B,                                     
0xB5,                                     
0x8D,                                     
0xE5,                                     
0xA,                                      
0x2C,                                     
0x2D,                                     
0xC7,                                     
0x75,                                     
0x8,                                      
0xB4,                                     
0x43,                                     
0xF8,                                     
0x4,                                      
0x20,                                     
0x5,                                      
0x6E,                                     
0x75,                                     
0x91,                                     
0xF6,                                     
0xBA,                                     
0x81,                                     
0x48,                                     
0x31,                                     
0xCC,                                     
0x65,                                     
0x51,                                     
0x9B,                                     
0xAE,                                     
0xCD,                                     
0xFD,                                     
0xFB,                                     
0xF8,                                     
0x87,                                     
0x2C,                                     
0x83,                                     
0x14,                                     
0xC2,                                     
0xDA,                                     
0xF6,                                     
0x1A,                                     
0xBB,                                     
0x51,                                     
0x6B,                                     
0x54,                                     
0xA2,                                     
0xC8,                                     
0x11,                                     
0x98,                                     
0x1C,                                     
0x62,                                     
0x71,                                     
0x66,                                     
0x75,                                     
0xD2,                                     
0xB5,                                     
0x68,                                     
0x60,                                     
0x60,                                     
0x78,                                     
0xA8,                                     
0x67,                                     
0x8F,                                     
0xA2,                                     
0xD0,                                     
0xAB,                                     
0xB,                                      
0x9C,                                     
0xC9,                                     
0xC8,                                     
0x38,                                     
0x94,                                     
0xB3,                                     
0xD1,                                     
0xF2,                                     
0xC,                                      
0x9A,                                     
0x4F,                                     
0x72,                                     
0x8B,                                     
0xAB,                                     
0xAE,                                     
0x82,                                     
0x92,                                     
0x8C,                                     
0xE5,                                     
0x4C,                                     
0x6F,                                     
0x80,                                     
0x7D,                                     
0x5A,                                     
0xDF,                                     
0xBA,                                     
0x2C,                                     
0x0,                                      
0x13,                                     
0x68,                                     
0x89,                                     
0xC2,                                     
0x80,                                     
0xF6,                                     
0x5,                                      
0x13,                                     
0x8E,                                     
0x55,                                     
0x77,                                     
0x96,                                     
0x4B,                                     
0xE4,                                     
0x4E,                                     
0x40,                                     
0xF,                                      
0x25,                                     
0x26,                                     
0x6B,                                     
0xF2,                                     
0xB6,                                     
0x82,                                     
0xEC,                                     
0xA5,                                     
0x2A,                                     
0xF7,                                     
0xC1,                                     
0x72,                                     
0xCF,                                     
0x51,                                     
0x36,                                     
0x46,                                     
0x88,                                     
0x54,                                     
0xFE,                                     
0xD0,                                     
0x56,                                     
0xF5,                                     
0x6A,                                     
0xC8,                                     
0xFA,                                     
0x12,                                     
0x75,                                     
0xD4,                                     
0xB4,                                     
0x43,                                     
0xAA,                                     
0x85,                                     
0xA4,                                     
0xF1,                                     
0x4C,                                     
0xB9,                                     
0x2D,                                     
0x14,                                     
0x17,                                     
0xED,                                     
0xCB,                                     
0xE1,                                     
0x0,                                      
0x1F,                                     
0x3F,                                     
0x5D,                                     
0xDD,                                     
0xC6,                                     
0xF6,                                     
0xCE,                                     
0xEE,                                     
0xB7,                                     
0x36,                                     
0xCF,                                     
0x5E,                                     
0x3D,                                     
0x9A,                                     
0xEE,                                     
0x5C,                                     
0x96,                                     
0xB8,                                     
0x6F,                                     
0x44,                                     
0x6D,                                     
0x94,                                     
0x96,                                     
0xB9,                                     
0xDA,                                     
0xB1,                                     
0x2,                                      
0x69,                                     
0x3C,                                     
0x2E,                                     
0x84,                                     
0x19,                                     
0xB5,                                     
0xD8,                                     
0x1A,                                     
0x51,                                     
0x0,                                      
0x0                                      
};

static int messagelen = 654;

typedef struct _mystring {
    int alloc;
    char data[20];
} mystring, *Pmystring;

typedef struct _mytable {
    int numcodes;
    mystring entry[256];
} mytable, *Pmytable;


static mytable table;
static char buffer[2000];

static char*  output_string(char* out,mystring *str)

{
  char* local_8;
  
  local_8 = str->data;
  while (*local_8 != 0x00) {
    *out = *local_8;
    out = out + 1;
    local_8 = local_8 + 1;
  }
  return out;
}



static void init_string(mystring *ptr)

{
  ptr->alloc = 0;
  return;
}



static void append_character(mystring *ptr,int c)

{
  if (ptr->alloc < 0x13) {
    ptr->data[ptr->alloc] = c;
    ptr->data[ptr->alloc + 1] = 0x00;
    ptr->alloc = ptr->alloc + 1;
  }
  return;
}



static void set_character(mystring *ptr,int c)

{
  ptr->alloc = 1;
  ptr->data[0] = c;
  ptr->data[1] = 0x00;
  return;
}



static void set_string(mystring *ptr,mystring *ptr2)

{
  char* local_c;
  char* local_8;
  
  local_c = ptr->data;
  local_8 = ptr2->data;
  while (*local_8 != 0x00) {
    *local_c = *local_8;
    local_c = local_c + 1;
    local_8 = local_8 + 1;
  }
  *local_c = 0x00;
  ptr->alloc = ptr2->alloc;
  return;
}



static void init_table(mytable *table)

{
  char local_d;
  int local_8;
  
  local_8 = 0;
  local_d = 'a';
  while (local_d != '{') {
    set_character(table->entry + local_8,(int)local_d);
    local_d = local_d + 0x01;
    local_8 = local_8 + 1;
  }
  local_d = 'A';
  while (local_d != '[') {
    set_character(table->entry + local_8,(int)local_d);
    local_d = local_d + 0x01;
    local_8 = local_8 + 1;
  }
  local_d = '0';
  while (local_d != ':') {
    set_character(table->entry + local_8,(int)local_d);
    local_d = local_d + 0x01;
    local_8 = local_8 + 1;
  }
  set_character(table->entry + local_8,0x28);
  set_character(table->entry + local_8 + 1,0x29);
  set_character(table->entry + local_8 + 2,0x2d);
  set_character(table->entry + local_8 + 3,0x2e);
  set_character(table->entry + local_8 + 4,0x2c);
  set_character(table->entry + local_8 + 5,0x2f);
  set_character(table->entry + local_8 + 6,0x22);
  set_character(table->entry + local_8 + 7,0x27);
  set_character(table->entry + local_8 + 8,0x20);
  set_character(table->entry + local_8 + 9,10);
  table->numcodes = local_8 + 10;
  return;
}



static void add_code(mytable *table,mystring *ptr)

{
  if (table->numcodes < 0x100) {
    set_string(table->entry + table->numcodes,ptr);
    table->numcodes = table->numcodes + 1;
  }
  return;
}



static void lzw_decompress(mytable *table,char *instream,int len,char* output)
{
  mystring local_2c;
  mystring *local_14;
  unsigned local_10;
  unsigned local_c;
  int local_8;
  
  init_string(&local_2c);
  local_c = 0;
  init_table(table);
  local_10 = (unsigned)*instream;
  instream = instream + 1;
  local_c = local_c + 0x1d & 0xff;
  set_string(&local_2c,table->entry + (local_10 ^ local_c));
  output = output_string(output,&local_2c);
  local_8 = 1;
  while (local_8 < len) {
    local_10 = (unsigned)*instream;
    instream = instream + 1;
    local_c = local_c + 0x1d & 0xff;
    local_14 = table->entry + (local_10 ^ local_c);
    output = output_string(output,local_14);
    append_character(&local_2c,local_14->data[0]);
    add_code(table,&local_2c);
    set_string(&local_2c,local_14);
    local_8 = local_8 + 1;
  }
  *output = 0x00;
  return;
}

int main(int argc, char *argv[])
{
  lzw_decompress(&table,message,messagelen,buffer);
//  printf("%s",buffer);
  return 0;
}








































