/* ###
 * IP: Apache License 2.0 with LLVM Exceptions
 */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package SWIG;

public class SBBlock {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected SBBlock(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SBBlock obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SBBlock obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        lldbJNI.delete_SBBlock(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public SBBlock() {
    this(lldbJNI.new_SBBlock__SWIG_0(), true);
  }

  public SBBlock(SBBlock rhs) {
    this(lldbJNI.new_SBBlock__SWIG_1(SBBlock.getCPtr(rhs), rhs), true);
  }

  public boolean IsInlined() {
    return lldbJNI.SBBlock_IsInlined(swigCPtr, this);
  }

  public boolean IsValid() {
    return lldbJNI.SBBlock_IsValid(swigCPtr, this);
  }

  public String GetInlinedName() {
    return lldbJNI.SBBlock_GetInlinedName(swigCPtr, this);
  }

  public SBFileSpec GetInlinedCallSiteFile() {
    return new SBFileSpec(lldbJNI.SBBlock_GetInlinedCallSiteFile(swigCPtr, this), true);
  }

  public long GetInlinedCallSiteLine() {
    return lldbJNI.SBBlock_GetInlinedCallSiteLine(swigCPtr, this);
  }

  public long GetInlinedCallSiteColumn() {
    return lldbJNI.SBBlock_GetInlinedCallSiteColumn(swigCPtr, this);
  }

  public SBBlock GetParent() {
    return new SBBlock(lldbJNI.SBBlock_GetParent(swigCPtr, this), true);
  }

  public SBBlock GetSibling() {
    return new SBBlock(lldbJNI.SBBlock_GetSibling(swigCPtr, this), true);
  }

  public SBBlock GetFirstChild() {
    return new SBBlock(lldbJNI.SBBlock_GetFirstChild(swigCPtr, this), true);
  }

  public long GetNumRanges() {
    return lldbJNI.SBBlock_GetNumRanges(swigCPtr, this);
  }

  public SBAddress GetRangeStartAddress(long idx) {
    return new SBAddress(lldbJNI.SBBlock_GetRangeStartAddress(swigCPtr, this, idx), true);
  }

  public SBAddress GetRangeEndAddress(long idx) {
    return new SBAddress(lldbJNI.SBBlock_GetRangeEndAddress(swigCPtr, this, idx), true);
  }

  public long GetRangeIndexForBlockAddress(SBAddress block_addr) {
    return lldbJNI.SBBlock_GetRangeIndexForBlockAddress(swigCPtr, this, SBAddress.getCPtr(block_addr), block_addr);
  }

  public SBValueList GetVariables(SBFrame frame, boolean arguments, boolean locals, boolean statics, DynamicValueType use_dynamic) {
    return new SBValueList(lldbJNI.SBBlock_GetVariables__SWIG_0(swigCPtr, this, SBFrame.getCPtr(frame), frame, arguments, locals, statics, use_dynamic.swigValue()), true);
  }

  public SBValueList GetVariables(SBTarget target, boolean arguments, boolean locals, boolean statics) {
    return new SBValueList(lldbJNI.SBBlock_GetVariables__SWIG_1(swigCPtr, this, SBTarget.getCPtr(target), target, arguments, locals, statics), true);
  }

  public SBBlock GetContainingInlinedBlock() {
    return new SBBlock(lldbJNI.SBBlock_GetContainingInlinedBlock(swigCPtr, this), true);
  }

  public boolean GetDescription(SBStream description) {
    return lldbJNI.SBBlock_GetDescription(swigCPtr, this, SBStream.getCPtr(description), description);
  }

  public String __repr__() {
    return lldbJNI.SBBlock___repr__(swigCPtr, this);
  }

}
