/* gexiv2-dump.c generated by valac 0.42.2, the Vala compiler
 * generated from gexiv2-dump.vala, do not modify */

/*
 * gexiv2-dump.vala
 *
 * Author(s)
 *  Jim Nelson <jim@yorba.org>
 *
 * This is free software. See COPYING for details.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gexiv2/gexiv2.h>
#include <stdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



gint _vala_main (gchar** args,
                 int args_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
void usage (void);
void dump_tags (GExiv2Metadata* metadata,
                gchar** tags,
                int tags_length1,
                GError** error);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	if (args_length1 < 2) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = _vala_string_array_contains (args, args_length1, "--help");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_string_array_contains (args, args_length1, "-h");
	}
	if (_tmp0_) {
		usage ();
		result = 1;
		return result;
	}
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = args + 1;
		filename_collection_length1 = args_length1 - 1;
		for (filename_it = 0; filename_it < (args_length1 - 1); filename_it = filename_it + 1) {
			gchar* _tmp2_;
			gchar* filename = NULL;
			_tmp2_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp2_;
			{
				{
					GExiv2Metadata* metadata = NULL;
					GExiv2Metadata* _tmp3_;
					GExiv2Metadata* _tmp4_;
					const gchar* _tmp5_;
					GExiv2Metadata* _tmp6_;
					GExiv2Metadata* _tmp7_;
					gchar** _tmp8_;
					gchar** _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					GExiv2Metadata* _tmp11_;
					GExiv2Metadata* _tmp12_;
					gchar** _tmp13_;
					gchar** _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					GExiv2Metadata* _tmp16_;
					GExiv2Metadata* _tmp17_;
					gchar** _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					_tmp3_ = gexiv2_metadata_new ();
					metadata = _tmp3_;
					_tmp4_ = metadata;
					_tmp5_ = filename;
					gexiv2_metadata_open_path (_tmp4_, _tmp5_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (metadata);
						goto __catch0_g_error;
					}
					_tmp6_ = metadata;
					_tmp7_ = metadata;
					_tmp9_ = _tmp8_ = gexiv2_metadata_get_exif_tags (_tmp7_);
					_tmp10_ = _tmp9_;
					_tmp10__length1 = _vala_array_length (_tmp8_);
					dump_tags (_tmp6_, _tmp10_, _vala_array_length (_tmp8_), &_inner_error_);
					_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (metadata);
						goto __catch0_g_error;
					}
					_tmp11_ = metadata;
					_tmp12_ = metadata;
					_tmp14_ = _tmp13_ = gexiv2_metadata_get_iptc_tags (_tmp12_);
					_tmp15_ = _tmp14_;
					_tmp15__length1 = _vala_array_length (_tmp13_);
					dump_tags (_tmp11_, _tmp15_, _vala_array_length (_tmp13_), &_inner_error_);
					_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (metadata);
						goto __catch0_g_error;
					}
					_tmp16_ = metadata;
					_tmp17_ = metadata;
					_tmp19_ = _tmp18_ = gexiv2_metadata_get_xmp_tags (_tmp17_);
					_tmp20_ = _tmp19_;
					_tmp20__length1 = _vala_array_length (_tmp18_);
					dump_tags (_tmp16_, _tmp20_, _vala_array_length (_tmp18_), &_inner_error_);
					_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (metadata);
						goto __catch0_g_error;
					}
					_g_object_unref0 (metadata);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					FILE* _tmp21_;
					const gchar* _tmp22_;
					GError* _tmp23_;
					const gchar* _tmp24_;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp21_ = stderr;
					_tmp22_ = filename;
					_tmp23_ = err;
					_tmp24_ = _tmp23_->message;
					fprintf (_tmp21_, "Unable to dump metadata for %s: %s\n", _tmp22_, _tmp24_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint _tmp25_ = -1;
					_g_free0 (filename);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp25_;
				}
				_g_free0 (filename);
			}
		}
	}
	result = 0;
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}


void
usage (void)
{
	FILE* _tmp0_;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "usage: gexiv2-dump FILE...\n\n");
}


void
dump_tags (GExiv2Metadata* metadata,
           gchar** tags,
           int tags_length1,
           GError** error)
{
	g_return_if_fail (metadata != NULL);
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
		tag_collection = tags;
		tag_collection_length1 = tags_length1;
		for (tag_it = 0; tag_it < tags_length1; tag_it = tag_it + 1) {
			gchar* _tmp0_;
			gchar* tag = NULL;
			_tmp0_ = g_strdup (tag_collection[tag_it]);
			tag = _tmp0_;
			{
				FILE* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp1_ = stdout;
				_tmp2_ = tag;
				_tmp3_ = tag;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = tag;
				_tmp7_ = gexiv2_metadata_get_tag_interpreted_string (metadata, _tmp6_);
				_tmp8_ = _tmp7_;
				fprintf (_tmp1_, "%s%*s%s\n", _tmp2_, CLAMP (64 - _tmp5_, 1, 64), "", _tmp8_);
				_g_free0 (_tmp8_);
				_g_free0 (tag);
			}
		}
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



