import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { GIT_COMMIT_INFO } from '../../generated/git-commit.js';
export const AboutBox = ({ cliVersion, osVersion, sandboxEnv, modelVersion, selectedAuthType, gcpProject, ideClient, }) => (_jsxs(Box, { borderStyle: "round", borderColor: theme.border.default, flexDirection: "column", padding: 1, marginY: 1, width: "100%", children: [_jsx(Box, { marginBottom: 1, children: _jsx(Text, { bold: true, color: theme.text.accent, children: "About Gemini CLI" }) }), _jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "CLI Version" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: cliVersion }) })] }), GIT_COMMIT_INFO && !['N/A'].includes(GIT_COMMIT_INFO) && (_jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "Git Commit" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: GIT_COMMIT_INFO }) })] })), _jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "Model" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: modelVersion }) })] }), _jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "Sandbox" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: sandboxEnv }) })] }), _jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "OS" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: osVersion }) })] }), _jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "Auth Method" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: selectedAuthType.startsWith('oauth') ? 'OAuth' : selectedAuthType }) })] }), gcpProject && (_jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "GCP Project" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: gcpProject }) })] })), ideClient && (_jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { width: "35%", children: _jsx(Text, { bold: true, color: theme.text.link, children: "IDE Client" }) }), _jsx(Box, { children: _jsx(Text, { color: theme.text.primary, children: ideClient }) })] }))] }));
//# sourceMappingURL=AboutBox.js.map