/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { debugLogger, } from '@google/gemini-cli-core';
import { getErrorMessage } from '../../utils/errors.js';
import { requestConsentNonInteractive } from '../../config/extensions/consent.js';
import { ExtensionManager } from '../../config/extension-manager.js';
import { loadSettings } from '../../config/settings.js';
import { promptForSetting } from '../../config/extensions/extensionSettings.js';
export async function handleLink(args) {
    try {
        const installMetadata = {
            source: args.path,
            type: 'link',
        };
        const workspaceDir = process.cwd();
        const extensionManager = new ExtensionManager({
            workspaceDir,
            requestConsent: requestConsentNonInteractive,
            requestSetting: promptForSetting,
            settings: loadSettings(workspaceDir).merged,
        });
        await extensionManager.loadExtensions();
        const extensionName = await extensionManager.installOrUpdateExtension(installMetadata);
        debugLogger.log(`Extension "${extensionName}" linked successfully and enabled.`);
    }
    catch (error) {
        debugLogger.error(getErrorMessage(error));
        process.exit(1);
    }
}
export const linkCommand = {
    command: 'link <path>',
    describe: 'Links an extension from a local path. Updates made to the local path will always be reflected.',
    builder: (yargs) => yargs
        .positional('path', {
        describe: 'The name of the extension to link.',
        type: 'string',
    })
        .check((_) => true),
    handler: async (argv) => {
        await handleLink({
            path: argv['path'],
        });
    },
};
//# sourceMappingURL=link.js.map