dnl version $Id: ac_dmtoffline.m4 7450 2015-08-13 10:05:33Z john.zweizig@LIGO.ORG $
dnl -*- m4 -*-
dnl----------------------------------------------------------------------
dnl This is a common set of macros to be used in the configuration of
dnl	the GDS software
dnl----------------------------------------------------------------------

dnl ---------------------------------------------------------------------
 
AC_DEFUN([AC_GDS_PROG_CC],
[ AC_PROG_CC
if test "${GCC}" = "yes"
then
  touch ,t.c
  ac_dmt_default_cc_includes="`${CC} -v ,t.c 2>&1 | \
        sed -n -e '/\#include/,/End of search list\./p' | \
        egrep '^ '`"
  rm ,t.c
fi
GDS_CC_FLAVOR="generic"
case $CC in
gcc|*/gcc|*-gcc) GDS_CC_FLAVOR="gnu";;
cc|*/cc)
    case "`$CC -V 2>&1`" in
    *Sun\ C\ *)
      GDS_CC_FLAVOR="SunPRO"
      ;;
    esac
    ;;
esac
AM_CONDITIONAL([GDS_CC_SUNPRO],[test x$GDS_CC_FLAVOR = xSunPRO])
])
   
dnl ---------------------------------------------------------------------
 
AC_DEFUN([AC_GDS_PROG_CXX],
[ AC_PROG_CXX
if test "${GXX}" = "yes"
then
  touch ,t.cc
  ac_dmt_default_cxx_includes="`${CXX} -v ,t.cc 2>&1 | \
        sed -n -e '/\#include/,/End of search list\./p' | \
        egrep '^ '`"
  rm ,t.cc
fi
GDS_CXX_FLAVOR="generic"
case $CXX in
gcc|*/gcc|g++|*/g++|g++-mp-*|*/g++-mp-*|clang++|*/clang++) 
    GDS_CXX_FLAVOR="gnu"
    CXXFLAGS="${CXXFLAGS} -std=c++0x"
    if test `$CXX --version | grep -c clang` != 0
    then
      GDS_CXX_FLAVOR="clang"
    fi
    ;;
CC|*/CC)
    case "`$CXX -V 2>&1`" in
    *Sun\ C++*)
      GDS_CXX_FLAVOR="SunPRO"
      ;;
    esac
    ;;
esac
CXXFLAGS=`echo ${CXXFLAGS} | sed -e s,-O2,,g`
AC_SYS_LARGEFILE
AM_CONDITIONAL([GDS_CXX_SUNPRO],[test x$GDS_CXX_FLAVOR = xSunPRO])
])

dnl======================================================================
dnl AC_GDS_CHECK_DISTRO
dnl   Check target ditribution (redhat-like or debaian-like)
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_DISTRO],
[
   distro=unknown
   if test -f /etc/debian_version 
   then
      distro=debian
   elif test -f /etc/redhat-release
   then
      distro=redhat
   fi
   AC_MSG_CHECKING([for user specified distribution])
   AC_ARG_WITH(distro, 
   	       AC_HELP_STRING([--with-distro=DISTNAME],
			      [distribution type @<:@unknown@:>@]
			     ),
	       [distro=${with_distro}]
	      )
   AC_MSG_RESULT(${distro})
   distconfigdir=/etc
   debian_distro=no
   redhat_distro=no
   case ${distro} in 
   ubuntu | debian)
      distconfigdir='${sysconfdir}/default'
      debian_distro=yes
      ;;
   fedora | redhat | rhel | scientific)
      distconfigdir='${sysconfdir}/sysconfig'
      redhat_distro=yes
      ;;
   esac
   AM_CONDITIONAL([debian_distro],[test x$debian_distro = xyes])
   AM_CONDITIONAL([redhat_distro],[test x$redhat_distro = xyes])
   AC_SUBST(distconfigdir)
])

dnl======================================================================
dnl GDS_CHECK_PKGCONF
dnl   Make sure that a valid version of pkg-config is available
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_PKGCONF],
[AC_REQUIRE([PKG_PROG_PKG_CONFIG])dnl
if test -z "$PKG_CONFIG"; then
    AC_MSG_ERROR([cannot find installed pkg-config])   
fi
])

dnl======================================================================
dnl GDS_CHECK_SIMD
dnl   Check the SIMD options to use
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_SIMD],
[
simd_arch=
simd_cflags=
AC_MSG_CHECKING([for SIMD architecture request])
AC_ARG_WITH(simd, 
	    AC_HELP_STRING([--with-simd@<:@=sse2@:>@],
			   [simd architecture]
			   ),
	    [simd_arch=yes],
	    [simd_arch=no]
)
if test "x$simd_arch" = "xyes" ;
then
  if test x$with_simd = xnative; then
    simd_cflags="-march=native"
    simd_arch=native
  else
    for simdv in sse2 ssse3 sse4 sse4.1 sse4.2 avx; do
	if test x$simdv = x$with_simd ; then
	    simd_cflags="-m$simdv"
	    simd_arch=$simdv
	    break
	fi
    done
  fi
fi
AC_MSG_RESULT(${simd_arch})
AC_SUBST(simd_cflags)

AC_MSG_CHECKING([for gcc style SIMD vector library])
gcc_simd=no
case ${GDS_CXX_FLAVOR} in
gnu|clang)
    gcc_simd=yes
    ;;
*)
    gcc_simd=no
    ;;
esac

AM_CONDITIONAL([x86simd_gcc], [test x${gcc_simd} = xyes ])
AC_MSG_RESULT(${gcc_simd})
])

dnl======================================================================
dnl GDS_CHECK_BITW
dnl   Check bit width
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_BITW],
[
  dnl ===================================================================
  dnl  Test 32/64-bit architecture
  dnl ===================================================================
bit_size=
AC_ARG_ENABLE(64bit,
	      AC_HELP_STRING([--enable-64bit], [64-bit compilation]),
	      [bit_size="-m64"]
)
AC_ARG_ENABLE(32bit,
	      AC_HELP_STRING([--enable-32bit], [32-bit compilation]),
	      [bit_size="-m32"]
)
  CXXFLAGS="$CXXFLAGS $bit_size"
  CFLAGS="$CFLAGS $bit_size"
  LDFLAGS="$LDFLAGS $bit_size"
])

dnl======================================================================
dnl GDS_CHECK_ROOT
dnl   Check if ROOT is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_ROOT],
[
rootcflags=
rootlibs=
rootglibs=
rootinc=
rootcint=
rootbaselibs=
AC_MSG_CHECKING([for ROOT])
ROOT_CONFIG=`which root-config`
if test -n "$ROOTSYS"; then
  rootdir="$ROOTSYS"
elif test -n "$ROOT_CONFIG" -a -x $ROOT_CONFIG ; then
  rootdir=`$ROOT_CONFIG --prefix`
fi
rootbin=$rootdir/bin
if test -x $rootbin/root-config
then
  rootcflags=`$rootbin/root-config --cflags`
  rootlibs=`$rootbin/root-config --libs | sed -e 's,-lPhysics,,'`
  rootglibs="`$rootbin/root-config --glibs | sed -e 's,-lPhysics,,'` -lRIO -lGpad"
  rootlib=`$rootbin/root-config --libdir`
  rootinc=`$rootbin/root-config --incdir`
  rootcint="$rootbin/rootcint"
  rootbaselibs="-L`$rootbin/root-config --libdir` -lCore -lCint `$rootbin/root-config --auxlibs`"
  LD_LIBRARY_PATH="$rootlib:$LD_LIBRARY_PATH"
else
  AC_MSG_RESULT([no])
dnl ===========================================================
dnl   We don't need ROOT with for non-gui DTT
dnl ===========================================================
  if test x$need_onlydtt = "xyes"
  then
    if test x$need_dttgui = "xno"
    then
      echo "ROOT not found - but OK, don't need it"
    else
      echo "ROOT must be on the system - Aborting"
      exit 1
    fi
  else
    echo "ROOT must be on the system - Aborting"
    exit 1
  fi	
fi
AC_MSG_RESULT([${rootdir}])
AC_SUBST(rootdir)
AC_SUBST(rootbin)
AC_SUBST(rootlib)
AC_SUBST(rootinc)
AC_SUBST(rootcflags)
AC_SUBST(rootlibs)
AC_SUBST(rootglibs)
AC_SUBST(rootbaselibs)
AC_SUBST(rootcint)
AC_SUBST(LD_LIBRARY_PATH)
])

dnl======================================================================
dnl GDS_CHECK_EXPAT
dnl   Check if EXPAT is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_EXPAT],
[
have_expat="no"
AC_CHECK_LIB(expat, XML_Parse, have_expat="yes", have_expat="no")
AM_CONDITIONAL([require_expat], [test "$have_expat" = "no" ])
if test "$have_expat" = "yes"; then
  pkgf=/usr
  pkgl=$pkgf/lib
  for d in `echo "$LD_LIBRARY_PATH" | sed -e "s/:/ /g"` ; do
    if test -f "$d/libexpat.so" ; then
      pkgl=`echo $d | sed -e 's,/$,,g'`
      pkgf=`echo $pkgl | sed -e 's,/lib\(64\)*$,,'`
      echo $pkgf
      break
    fi
  done
  expatcflags="-I$pkgf/include"
  expatlibs="-lexpat"
else
  expatcflags="-I$PWD/External/include"
  expatlibs="-L$PWD/External/lib -lxml"
fi
AC_SUBST(expatcflags)
AC_SUBST(expatlibs)
])

dnl======================================================================
dnl GDS_CHECK_FFTW3
dnl   Check if FFTW3 is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_FFTW3],
[
have_fftw3f="no"
have_fftw3d="no"
fftwcflags=
fftwlibs=
ext_fftw="no"
PKG_CHECK_MODULES(FFTWF, [fftw3f >= 3.2.1], have_fftw3f="yes", have_fftw3f="no")
PKG_CHECK_MODULES(FFTWD, [fftw3  >= 3.2.1], have_fftw3d="yes", have_fftw3d="no")
if test "$have_fftw3f" = "yes"; then
  fftwcflags="$FFTWF_CFLAGS -DFFTW3"
  fftwlibs=`echo $FFTWF_LIBS | sed -e 's,-lfft,-lfftw3f_threads -lfft,'`
  if test "$have_fftw3d" = "yes"; then
    fftwcflags="$fftwcflags -DFFT_DOUBLE"
    fftwlibs="$fftwlibs -lfftw3_threads -lfftw3"
  fi
else
  AC_CHECK_LIB(fftw3f, fftwf_execute_dft, have_fftw3f="yes", have_fftw3f="no")
  AC_CHECK_LIB(fftw3,  fftw_execute_dft,  have_fftw3d="yes", have_fftw3d="no")
  if test "$have_fftw3f" = "yes"; then
    pkgf=/usr
    pkgl=$pkgf/lib
    for d in `echo "$LD_LIBRARY_PATH" | sed -e "s/:/ AC_ARG_ENABLE(dtt,
	      AC_HELP_STRING([--enable-dtt], [Build dtt]),
	      [need_dtt="yes"]
)
/g"` ; do
      if test -f "$d/libfftw3f.so" -o -f "$d/libfftw3f.a" ; then
      	pkgl=`echo $d | sed -e 's,/$,,g'`
      	pkgf=`echo $pkgl | sed -e 's,/lib.*$,,'`
      	echo $pkgf
      	break
      fi
    done
    fftwcflags="-I$pkgf/include -DFFTW3"
    fftwlibs="-L$pkgl -lfftw3f_threads -lfftw3f"
    if test "$have_fftw3d" = "yes"; then
      fftwcflags="$fftwcflags -DFFT_DOUBLE"
      fftwlibs="$fftwlibs -lfftw3_threads -lfftw3"
    fi
  else
    AC_MSG_ERROR([cannot find installed fftw3])
  fi
fi
AM_CONDITIONAL([require_fftw3], [test "$ext_fftw" = "yes" ])
AC_SUBST(fftwcflags)
AC_SUBST(fftwlibs)
])

dnl======================================================================
dnl GDS_FIND_PKG
dnl Check if soecified package is installed
dnl======================================================================

AC_DEFUN([AC_GDS_FIND_PKG],
[
symname="$1"
pkgname="$2"
])

dnl======================================================================
dnl GDS_CHECK_HDF
dnl Check if soecified package is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_HDF],
[
AC_MSG_CHECKING([for HDF5])
hdflibs=
hdfcflags=
found_hdf5="no"
AC_ARG_WITH(hdf5, 
	    AC_HELP_STRING([--with-hdf5@<:@=DIR@:>@],
			   [hdf5 installation location @<:@/usr/@:>@]
			   ),
	    [found_hdf5=yes]
	    )
if test x$found_hdf5 = "xyes" -a x$with_hdf5 != "xyes"
then
   if test $with_hdf5 = "no"
   then
      found_hdf5="no"
   else
      hdfinc="$with_hdf5/include"
      for td in include/hdf5 include/hdf5/serial
      do
         test -f $with_hdf5/$td/H5Cpp.h && hdfinc=$with_hdf5/$td
      done
      if test ! -f $hdfinc/H5Cpp.h
      then
         AC_MSG_RESULT([not found])
         AC_MSG_ERROR([HDF5 not found])
      fi
      hdflibs="-L$with_hdf5/lib -lhdf5_cpp -lhdf5"
      hdfcflags="-I$hdfinc -DHAVE_HDF5"
   fi
else
   H5CXX=`which h5c++`
   PKG_CHECK_MODULES(HDF5, hdf5-serial, found_hdf5=yes, found_hdf5=no)
   if test $found_hdf5 = "yes"
   then
      hdflibs="$HDF5_LIBS -lhdf5_cpp"
      hdfcflags="$HDF5_CFLAGS"
   elif test -x $H5CXX
   then
      h5cflags=`$H5CXX -showconfig | grep -e ' CPPFLAGS:' | sed -e s,.*:,,g`
      hdflibs="-lhdf5_cpp -lhdf5"
      hdfcflags="-DHAVE_HDF5 $h5cflags"
   else
      hdfdir="/usr/include"
      for td in /usr/include /usr/include/hdf5 /usr/include/hdf5/serial
      do
         test -f $td/H5Cpp.h && hdfdir=$td
      done
      if test -f $hdfdir/H5Cpp.h
      then
         hdflibs="-lhdf5_cpp -lhdf5"
         hdfcflags="-I$hdfdir -DHAVE_HDF5"
      else
         AC_MSG_RESULT([not found])
         AC_MSG_ERROR([HDF5 not found])
      fi
   fi
   found_hdf5="yes"
fi
AC_MSG_RESULT([$found_hdf5])
if test $found_hdf5 = "yes"
then
  echo "HDF5 found in $hdflibs"
fi
AM_CONDITIONAL([have_hdf5], [test "$found_hdf5" = "yes"])
AC_SUBST(hdfcflags)
AC_SUBST(hdflibs)
])

dnl======================================================================
dnl GDS_CHECK_RT
dnl   Check if RT is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_RT],
[
ac_gds_lib=${LIBS}
have_rt="no"
AC_CHECK_LIB([rt],[clock_gettime],[have_rt="yes"],[have_rt="no"])
if test "$have_rt" = "yes"; then
  rtlibs="-lrt"
fi
AC_SUBST(rtlibs)
LIBS=${ac_gds_lib}
])

dnl======================================================================
dnl GDS_CHECK_ZLIB
dnl   Check if ZLIB is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_ZLIB],
[
found_zutil=no
zlibcflags=
zliblibs="-lz"
have_libz=no
AC_CHECK_LIB([z], inflate, have_libz="yes", have_libz="no")
libp=`echo $LD_LIBRARY_PATH | sed -e s,::,:,g -e 's,/lib\(64\)*\:, ,g' -e 's,/lib\(64\)*$,,g'`
for p in $libp /usr/local /usr ; do
  if test -f $p/include/zutil.h ; then
    zlibcflags="-I$p/include"
    zliblibs="-L$p/lib -lz"
    found_zutil=yes
    break
  elif test -f $p/include/zlib.h ; then
    zlibcflags="-I$p/include"
  fi
done
AM_CONDITIONAL([have_zutil], [test "$found_zutil" = "yes"])
AC_SUBST(zlibcflags)
AC_SUBST(zliblibs)
if test $have_libz = "no" ; then
  AC_MSG_ERROR([libz not found])
fi
])

dnl======================================================================
dnl GDS_CHECK_FRAMECPP
dnl   Check if framecpp is installed
dnl removed framecpplibs="-Wl,--no-as-needed -Wl,--copy-dt-needed-entries 
dnl                      $framecpplibs"
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_FRAMECPP],
[
have_framecpp=not-set
PKG_CHECK_MODULES(FRAMECPP, framecpp, have_framecpp=yes, have_framecpp=no)
if test "${have_framecpp}" = "yes"
then
  framecpplibs="$FRAMECPP_LIBS"
  framecppcflags="$FRAMECPP_CFLAGS"
fi
if test "${have_framecpp}" = "no"
then
  framecppcflags=""
  framecpplibs="-lframecpp -lldastoolsal"
fi
AC_MSG_RESULT($have_framecpp)
#framecpplibs="-Wl,--no-as-needed $framecpplibs"
AM_CONDITIONAL([require_framecpp], test x$have_framecpp = xno)
AC_SUBST(framecpplibs)
AC_SUBST(framecppcflags)
])


dnl======================================================================
dnl GDS_CHECK_LAL
dnl   Check if lal is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_LAL],
[
lal_pkgok=
PKG_CHECK_MODULES(LAL, [lal lalsupport], lal_pkgok="yes", lal_pkgok="no")
if test "${lal_pkgok}" = "yes"
then
lallibs="$LAL_LIBS"
lalcflags="$LAL_CFLAGS"
else
lallibs=
lalcflags=
fi
AM_CONDITIONAL([have_lal], [test "$lal_pkgok" = yes])
AC_SUBST(lallibs)
AC_SUBST(lalcflags)
])


dnl======================================================================
dnl GDS_CHECK_FR
dnl   Check if FR is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_FR],
[
have_libframe=no
PKG_CHECK_MODULES(FRAME, libframe, have_libframe="yes", have_libframe="no")
if test "${have_libframe}" = "yes"
then
frlibs="$FRAME_LIBS"
frcflags="$FRAME_CFLAGS"
fi
if test "${have_libframe}" = "no"
then
frlibs="-lFrame"
frcflags=""
case `uname -m` in
   "i386" | "i486" | "i586" | "i686")
	frcflags=""
	;;
   *)
	frcflags="-DFR_LONG_LONG"
	;;
esac
fi
AM_CONDITIONAL([require_fr], [test "$have_libframe" = no])
AM_CONDITIONAL([have_fr], [test "$have_libframe" = yes])
AC_SUBST(frlibs)
AC_SUBST(frcflags)
])

dnl======================================================================
dnl GDS_CHECK_METAIO
dnl   Check if METAIO is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_METAIO],
[
have_metaio=
PKG_CHECK_MODULES(METAIO, libmetaio, have_metaio="yes", have_metaio="no")
if test "${have_metaio}" = "yes"
then
metaiovsn=`pkg-config --modversion libmetaio | sed -e 's,\.,0,g'`
metaiolibs="$METAIO_LIBS"
metaiocflags="$METAIO_CFLAGS -DMETAIO_VSN=$metaiovsn"
fi
if test "${have_metaio}" = "no"
then
metaiolibs="-lmetaio"
metaiocflags=""
fi
AM_CONDITIONAL([require_metaio], [test "$have_metaio" = no])
AC_SUBST(metaiolibs)
AC_SUBST(metaiocflags)
dnl----------------------------------------------------------------------
dnl Verify if the header file is C++ compatable
dnl----------------------------------------------------------------------
AC_LANG_PUSH([C++])
AC_COMPILE_IFELSE([AC_LANG_PROGRAM([#include<metaio.h>],[])],
	[AC_DEFINE([HAVE_CPLUSPLUS_COMPATABLE_METAIO_H],[1],[Defined if C++ working version of metaio.h is available])])
AC_LANG_POP([C++])
])

dnl======================================================================
dnl AC_GDS_CHECK_SASL
dnl   Check if SASL is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_SASL],
[
have_sasl="no"
sasllibs=
saslcflags=
AC_MSG_CHECKING([for user specified sasl2 library])
AC_ARG_WITH(sasl, 
	    AC_HELP_STRING([--with-sasl@<:@=DIR@:>@],
			   [sasl2 library location @<:@SASL/lib@:>@]
			   ),
	    [have_sasl=yes],
	    [have_sasl=no]
)
AC_MSG_RESULT(${have_sasl})
if test "${have_sasl}" = "yes"
then
    saslcflags="-I${with_sasl}/include -DHAVE_SASL=2"
    sasllibs="-L${with_sasl}/lib -lsasl2"
    have_sasl=${with_sasl}
else
    AC_CHECK_LIB(sasl2, sasl_client_new, have_sasl="yes", have_ssl="no")
    if test "${have_sasl}" != "no"
    then
        saslcflags=-DHAVE_SASL=2
        sasllibs=-lsasl2
	have_sasl=sasl2
    else
        AC_CHECK_LIB(sasl, sasl_client_new, have_sasl="yes", have_ssl="no")
        if test "${have_sasl}" = "yes"
        then
            saslcflags=-DHAVE_SASL=1
            sasllibs=-lsasl
	    have_sasl=${with_sasl}
        fi
    fi
fi
AC_SUBST(sasllibs)
AC_SUBST(saslcflags)
])

dnl======================================================================
dnl AC_GDS_CHECK_VIRGO
dnl   Check if VIRGO is installed
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_VIRGO],
[
have_virgo="no"
virgolibs=
virgocflags=
AC_MSG_CHECKING([for virgo DA libraries])
AC_ARG_WITH(virgo, 
	    AC_HELP_STRING([--with-virgo@<:@=DIR@:>@],
			   [virgo library location @<:@VIRGO/lib@:>@]
			   ),
	    [have_virgo=yes],
	    [have_virgo=no]
)
if test "x${with_virgo}" = "xno"
then
    have_virgo=no
fi
if test "${have_virgo}" = "yes"
then
    virgocflags="-I${with_virgo}/include/Fr -I${with_virgo}/include/Cm -I${with_virgo}/include/CSet"
    virgolibs="-L${with_virgo}/lib -lCSet -lCm -lReg -lFrame"
    AC_MSG_RESULT(${with_virgo})
else
    AC_MSG_RESULT(${have_virgo})
fi
AM_CONDITIONAL([have_virgo_apps], test x$have_virgo = xyes)
AC_SUBST(virgolibs)
AC_SUBST(virgocflags)
])

dnl======================================================================
dnl   Enable DTT compilation
dnl   
dnl======================================================================

AC_DEFUN([AC_GDS_ENABLE_DTT],
[
AC_MSG_CHECKING([whether to build dtt])
need_dtt=no
need_onlydtt=no
need_dttgui=
AC_ARG_ENABLE(dtt,
	      AC_HELP_STRING([--enable-dtt], [Build dtt]),
	      [need_dtt="yes"]
)
AC_ARG_ENABLE(only_dtt,
	      AC_HELP_STRING([--enable-only-dtt], [Build dtt only]),
	      [need_onlydtt="yes"]
)

if test $need_onlydtt = "yes"
then
    need_dtt="yes"
    AC_MSG_RESULT([Only])
    
else
    AC_MSG_RESULT([${need_dtt}])
fi

need_dttgui=yes
AC_ARG_ENABLE(nogui,
	      AC_HELP_STRING([--enable-nogui], [Build dtt without gui]),
	      [need_dttgui="no"]
)

have_epics=
AC_ARG_WITH(
    [epics], 
    AC_HELP_STRING([--with-epics@<:@=DIR@:>@], 
                   [epics top-level directory @<:@DTT/epics@:>@]
		   ),
    [have_epics=yes],
    [have_epics=no]
)

dtt_defines=
rpcgen_flags=
epicslibs=
epicscflags=
build_epics=no
if test $need_dtt = "yes"
then
    echo "$as_me:$LINENO: checking for DTT GUI" >&5
    echo $ECHO_N "checking for DTT GUI... $ECHO_C"
    if test x$need_dttgui = "xno" 
    then
       need_dttgui=no
       echo NO
    else
       need_dttgui=yes
       echo yes
    fi

    dtt_defines="-DLIGO_GDS -D_CONFIG_DYNAMIC -D_ADVANCED_LIGO -DCOMPAT_INITIAL_LIGO=1"
    case $host in
    *solaris*)
        osarch=solaris 
        dtt_defines="$dtt_defines -D__EXTENSIONS__"
	if test `uname -m` = "i86pc" ;
	then
	    arch=solaris-x86-gnu
	else
	    arch=solaris-sparc	
	fi
	;;
    *linux*)
	dtt_defines="$dtt_defines -DPORTMAP"
        osarch=Linux
	if test `uname -m` = "x86_64" ;
	then
	    arch=linux-x86_64
	else
	    arch=linux-x86
	fi
	;;
    *darwin*)
	dtt_defines="$dtt_defines -DPORTMAP -DAVOID_SIGNALS"
        osarch=Darwin
	if test `uname -m` = "x86_64" ;
	then
	    arch=darwin-x86
	else
	    arch=darwin-x86
	fi
	;;
    *)
	dtt_defines="$dtt_defines -DPORTMAP"
        osarch=Linux
        arch=linux-x86
    esac

    rpcgen_flags="-C -N"
    case $host in
      *solaris*)
      rpcgen_flags="$rpcgen_flags -M"
	;;
      *linux*)
	  rpcgen_flags="$rpcgen_flags -M"
	;;
      *darwin*)
	  rpcgen_flags="broken"
	;;
      *)
	  rpcgen_flags="$rpcgen_flags -M"
    esac

    if test "x$buildtype" = "xonline" ;
    then
      if test "x$have_epics" = "xyes" -a "x$with_epics" = "xno" ; then
        epicslibs=""
	epicscflags=""
      elif test "x$have_epics" = "xyes" ; then
	if test "x$with_epics" = "xyes" -o "x$with_epics" = "x" ; then
            echo "$as_me:$LINENO: checking for epics archive for arch=$arch" >&5
	    echo $ECHO_N "checking for epics base libs DTT/epics/base/lib/${arch} ... $ECHO_C"
            if test -f "DTT/epics/base/lib/${arch}/libca.a" ;
	    then
	        epicslibs="-L../epics/base/lib/${arch} -lca -lCom -L../epics/extensions/lib/${arch} -lezca"
                epicscflags="-I../epics/base/include -I../epics/base/include/os/${osarch} -I../epics/extensions/include"
	        build_epics=yes
		echo "$build_epics"
	    else
	        build_epics=no
		echo "$build_epics"
		echo $ECHO_N "** REMEMBER to expand EPICS tar-ball in DTT/epics ! $ECHO_N"
	    fi
	else
            epicstop="${with_epics}"
            echo "$as_me:$LINENO: checking for epics archive for arch=$arch" >&5
	    echo $ECHO_N "checking for epics base libs ${epicstop}/base/lib/${arch} ... $ECHO_C"
            if test -f "${epicstop}/base/lib/${arch}/libca.a" ;
	    then
	        epicslibs="-L${epicstop}/base/lib/${arch} -lca -lCom -L${epicstop}/extensions/lib/${arch} -lezca"
                epicscflags="-I${epicstop}/base/include -I${epicstop}/base/include/os/${osarch} -I${epicstop}/extensions/include"
	        build_epics=yes
	    else
	        build_epics=no
	    fi
	    echo "$build_epics"
        fi
     fi
      if test "x$build_epics" = "xno" ;
      then
        dtt_defines="$dtt_defines -DGDS_NO_EPICS"
      else
        dtt_defines="$dtt_defines -DGDS_ONLINE"
      fi 	
    else
      dtt_defines="$dtt_defines -DGDS_NO_EPICS"
    fi 
else
  need_dttgui=no
fi

AM_CONDITIONAL([build_dtt], [test "x$need_dtt" = "xyes"])
AM_CONDITIONAL([build_onlydtt], [test "x$need_onlydtt" = "xyes"])
AM_CONDITIONAL([build_dttgui], [test "x$need_dttgui" = "xyes"])
AM_CONDITIONAL([build_ezca], [test "x$build_epics" = "xyes"])
AM_CONDITIONAL([rpcgen_ok], [test "$rpcgen_flags" != "broken"])
AC_SUBST(dtt_defines)
AC_SUBST(rpcgen_flags)
AC_SUBST(epicslibs)
AC_SUBST(epicscflags)

echo $ECHO_N "checking for rts ... $ECHO_C"

AC_ARG_ENABLE([rts], 
    [--enable-rts  add realtime site],
    [case "${enableval}" in
      llo) rts=llo ;;
      lho) rts=lho ;;
      mit) rts=mit ;;
      geo) rts=geo ;;
      *) AC_MSG_ERROR([bad site ${withval} for --with-rts]) ;;
    esac],[rts=]
)
add_rts=false
AM_CONDITIONAL([add_rts], [test x$rts != x]) 
AM_CONDITIONAL([site_llo], [test x$rts = xllo])	
AM_CONDITIONAL([site_lho], [test x$rts = xlho])	
AM_CONDITIONAL([site_mit], [test x$rts = xmit])	
AM_CONDITIONAL([site_geo], [test x$rts = xgeo])	
echo "$rts"

echo $ECHO_N "checking for dmtviewer enable flag... $ECHO_C"
AC_ARG_ENABLE([dmtviewer], 
    [--enable-dmtviewer  add dmtviewer anyway],
    [case "${enableval}" in
      yes) dmtviewer=true ;;
      no) dmtviewer=false ;;
      *) AC_MSG_ERROR([bad logic ${withval} for --with-dmtviewer]) ;;
    esac],[dmtviewer=false]
)
add_dmtviewer=false
AM_CONDITIONAL([add_dmtviewer], [test x$dmtviewer = xtrue]) 
echo "$dmtviewer"

echo $ECHO_N

])

dnl======================================================================
dnl   Enable python wrappers
dnl   
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_PYTHON],
[
AC_MSG_CHECKING([whether to build python wrappers])
build_python=no
AC_ARG_ENABLE(python,
	      AC_HELP_STRING([--enable-python], [Build python wrappers]),
	      [build_python="yes"], [build_python="no"]
)
echo "$build_python"
flag_pygds=0
if test x$build_python = xyes
then
flag_pygds=1
fi
AM_CONDITIONAL([dmt_swig_python], test x$build_python = xyes)
AC_SUBST(flag_pygds)
])

dnl======================================================================
dnl GDS_BUILD_TYPE
dnl   Check build type: online, offline, ...
dnl======================================================================

AC_DEFUN([AC_GDS_BUILD_TYPE],
[
AC_MSG_CHECKING([GDS build type])
buildtype="none"
AC_ARG_ENABLE(online,
	      AC_HELP_STRING([--enable-online], [Online program version]),
	      [buildtype="online"],
)
AC_ARG_ENABLE(offline,
	      AC_HELP_STRING([--enable-offline], [Offline program version]),
	      [buildtype="offline"],
)
if test "x$buildtype" = "xnone"
then
    buildtype="$GDSBUILD"
    case "x$buildtype" in
    xonline | xoffline)
      ;;
    *)
      echo "Online or offline build must be specified - Aborting"
      exit 1;
      ;;
    esac
fi
AC_MSG_RESULT([$buildtype])

online=
offline=
AM_CONDITIONAL([online], test x$buildtype = xonline)
AM_CONDITIONAL([offline], test x$buildtype = xoffline)

dnl =====================================================================
dnl   Check whether to build moniors
dnl =====================================================================
AC_MSG_CHECKING([whether to build monitors])
need_monitors=yes
AC_ARG_ENABLE(monitors,
	      AC_HELP_STRING([--enable-monitors], [Build all monitors]),
	      [need_monitors=$enable_monitors]
)

need_omega=no
AC_ARG_ENABLE(omega,
	      AC_HELP_STRING([--enable-omega], [Build Omega_c only]),
	      [need_omega=$enable_omega]
)
AC_MSG_RESULT([$need_monitors])

AM_CONDITIONAL([build_monitors], [test x$need_monitors != xno ])
AM_CONDITIONAL([build_omega], [test x$need_omega != xno ])

dnl =====================================================================
dnl   Also set dtt online flag here
dnl =====================================================================
dtt_online=
AM_CONDITIONAL([dtt_online], test x$buildtype = xonline)
])

AC_DEFUN([AC_GDS_MAX_CHNNAME],
[
echo "Setting max channel name length to 60"
max_chnname_size="-DMAX_CHNNAME_SIZE=60"
AC_SUBST(max_chnname_size)
]
)

dnl======================================================================
dnl AC_GDS_LDFLAGS_GROUPINGS
dnl======================================================================
AC_DEFUN([AC_GDS_LDFLAGS_GROUPINGS],
[
ac_gds_val="$LDFLAGS"
LDFLAGS="$LDFLAGS -Wl,--start-group -Wl,--end-group"
AC_LINK_IFELSE([
AC_LANG_PROGRAM([],
        	[[]])
],[
LDFLAGS_STARTGROUP="-Wl,--start-group"
LDFLAGS_ENDGROUP="-Wl,--end-group"
])
AC_SUBST([LDFLAGS_STARTGROUP])
AC_SUBST([LDFLAGS_ENDGROUP])
LDFLAGS="$ac_gds_val"
])

dnl======================================================================
dnl ROOT_OBJECTS
dnl   Check whether to build root objects ...
dnl======================================================================

AC_DEFUN([AC_GDS_ROOT_OBJECTS],
[
bld_dict="yes"
echo $ECHO_N "checking whether to build root_objects ... $ECHO_C"
AC_ARG_ENABLE(root_objects,
	      AC_HELP_STRING([--enable-root-objects], 
	         [Build root dictionary in shared objects]),
	      	 [bld_dict="yes"]
)

case "x$enable_root_objects" in
"x" | "xyes")
    if test $buildtype = online ; then
        if test $need_onlydtt = "yes" ; then
            if test x$need_dttgui = "xno"; then
                bld_dict="no"
            else
                bld_dict="yes"
            fi
        else
           bld_dict="yes"
        fi  
    else
        bld_dict="no"
    fi
    ;;
*)
    bld_dict="no"
    ;;
esac
AM_CONDITIONAL([root_dict], [test "$bld_dict" = "yes"])
echo "$bld_dict"
])

dnl======================================================================
dnl GDS_CHECK_POSIX
dnl	
dnl======================================================================

AC_DEFUN([AC_GDS_CHECK_POSIX],
[
AC_MSG_CHECKING([posix flags])
posixflags=
case "${host}" in
*linux*) posixflags="-D_POSIX_C_SOURCE=200809L" ;;
*solaris*) posixflags="-D_POSIX_C_SOURCE=200112L" ;;
*darwin*) posixflags="-D_POSIX_C_SOURCE=200112L -D_DARWIN_C_SOURCE=1" ;;
esac
AC_MSG_RESULT([$posixflags])
posix95flags=
case "${host}" in
*linux*) posix95flags="-D_POSIX_C_SOURCE=199506L" ;;
*solaris*) posix95flags="-D_POSIX_C_SOURCE=199506L" ;;
*darwin*) posix95flags="-D_POSIX_C_SOURCE=199506L -D_DARWIN_C_SOURCE=1" ;;
esac
unix98flags="-D_XOPEN_SOURCE=600"
CFLAGS="$CFLAGS -std=c99"
])

dnl======================================================================
dnl GDS_DMT_RUNTIME
dnl Check if soecified package is installed
dnl======================================================================

AC_DEFUN([AC_GDS_DMT_RUNTIME],
[
echo $ECHO_N "checking whether to build dmt runtime environment ... $ECHO_C"
bld_dmtrun="no"
AC_ARG_ENABLE(dmt_runtime,
	      AC_HELP_STRING([--enable-dmt-runtime], 
	         [Build dmt runtime environment]),
	      	 [bld_dmtrun="$enable_dmt_runtime"]
	     )
flag_dmtrun=0
if test "$bld_dmtrun" = "yes"
then
flag_dmtrun=1
fi
AC_SUBST(flag_dmtrun)
AM_CONDITIONAL([dmt_runtime], [test "$bld_dmtrun" = "yes"])
echo "$bld_dmtrun"
])

dnl======================================================================
dnl AC_GDS_FINISH - Things to be done at the very end for GDS
dnl======================================================================
 
AC_DEFUN([AC_GDS_FINISH],
[
  dnl ===================================================================
  dnl  Setup $architecture
  dnl ===================================================================
architecture=
case "${host}" in
*linux*) architecture="linux" ;;
*solaris*) architecture="solaris" ;;
*darwin*) architecture="darwin" ;;
esac
AC_SUBST(architecture)
  dnl ===================================================================
  dnl  Setup $syslibs
  dnl ===================================================================
syslibs=
case "${host}" in
*linux*) syslibs="-lm -ldl -lrt" ;;
*solaris*) syslibs="-lm -ldl -lrt" ;;
*darwin*) syslibs="-lm -ldl" ;;
esac
AC_SUBST(syslibs)
  dnl ===================================================================
  dnl  Setup $sysmtlibs
  dnl ===================================================================
sysmtlibs=
case "${host}" in
*linux*) sysmtlibs="-lm -ldl -lrt -lpthread" ;;
*solaris*) sysmtlibs="-lm -ldl -lrt -lpthread" ;;
*darwin*) sysmtlibs="-lm -ldl -lpthread" ;;
esac
AC_SUBST(sysmtlibs)
  dnl ===================================================================
  dnl  Setup $netlib
  dnl ===================================================================
netlib=
case "${host}" in
*linux*) netlib="" ;;
*solaris*) netlib="-lnsl -lsocket" ;;
*darwin*) netlib="" ;;
esac
AC_SUBST(netlib)
  dnl ===================================================================
  dnl  Setup $readlinelibs
  dnl ===================================================================
readlinelibs=
case "${host}" in
*linux*) readlinelibs="-lreadline -ltermcap" ;;
*solaris*) readlinelibs="-lreadline -ltermcap" ;;
*darwin*) readlinelibs="-lreadline -ltermcap" ;;
esac
AC_SUBST(readlinelibs)
  dnl ===================================================================
  dnl  Specify warning message level
  dnl ===================================================================
case "$GDS_CC_FLAVOR" in
gnu)
  CFLAGS="$CFLAGS -pipe -fPIC $unix98flags"
  WARNINGCFLAGS="-Wall"
  ;;
clang)
  CFLAGS="$CFLAGS -pipe -fPIC $unix98flags"
  WARNINGCFLAGS="-Wall"
  ;;
SunPRO)
  CFLAGS="$CFLAGS -v -KPIC -xc99=none"
  ;;
esac
case "$GDS_CXX_FLAVOR" in
gnu)
  CXXFLAGS="$CXXFLAGS -pipe -fPIC"
  WARNINGCXXFLAGS="-Wall -Woverloaded-virtual -Wno-deprecated"
  ;;
clang)
  CXXFLAGS="$CXXFLAGS -pipe -fPIC"
  WARNINGCXXFLAGS="-Wall -Woverloaded-virtual -Wno-deprecated -Wno-unused-const-variable"
  ;;
SunPRO)
  CXXFLAGS="$CXXFLAGS -KPIC"
  ;;
esac
  dnl ===================================================================
  dnl  Specify optimization
  dnl ===================================================================
opt="-O2"
hiopt="-O3"
noopt="-O0"
  dnl ===================================================================
  dnl   Add POSIX source flag to optimization
  dnl ===================================================================
case "$GDS_CC_FLAVOR" in
gnu)
  opt95="$opt $posix95flags"
  hiopt95="$hiopt $posix95flags"
  noopt95="$noopt $posix95flags"
  opt="$opt $posixflags"
  hiopt="$hiopt $posixflags"
  noopt="$noopt $posixflags"
  ;;
SunPRO)
  opt95="$opt"
  hiopt95="$hiopt"
  noopt95="$noopt"
  ;;
esac
AC_SUBST(opt)
AC_SUBST(hiopt)
AC_SUBST(noopt)
AC_SUBST(opt95)
AC_SUBST(hiopt95)
AC_SUBST(noopt95)
  dnl ===================================================================
  dnl  Instruct how to handle Version Control Id Tag
  dnl ===================================================================
  case "$GDS_CC_FLAVOR" in
  gnu)
    CFLAGS="$CFLAGS '-DVCSID(x)=static const char* __attribute__((__unused__)) versionId = x'"
    ;;
  clang)
    CFLAGS="$CFLAGS '-DVCSID(x)=static const char* __attribute__((__unused__)) versionId = x'"
    ;;
  *)
    CFLAGS="$CFLAGS '-DVCSID(x)=static const char* versionId = x;'"
    ;;
  esac
  case "$GDS_CXX_FLAVOR" in
  *)
    CXXFLAGS="$CXXFLAGS '-DVCSID(x)=static const char* versionId[[]] = { versionId[[1]], x }'"
    ;;
  esac
  dnl ===================================================================
  dnl  Writing config files
  dnl ===================================================================
AC_CONFIG_FILES(config/PConfig.h:config/PConfig.in)
AC_CONFIG_FILES(External/Makefile.patch:External/Makefile.patch.in)
AC_CONFIG_FILES(Utilities/scripts/WatchDawg:Utilities/scripts/WatchDawg.in)
AC_CONFIG_FILES(Utilities/scripts/findProc:Utilities/scripts/findProc.in)
AC_CONFIG_FILES(Utilities/setup/dmtsetup.csh:Utilities/setup/dmtsetup.in)
AC_CONFIG_FILES(Utilities/setup/dmtsetup.sh:Utilities/setup/dmtsetupb.in)
AC_CONFIG_FILES(Utilities/setup/dol-user-env.sh:Utilities/setup/dol-user-env.sh.in)
AC_CONFIG_FILES(Utilities/setup/dol-user-env.csh:Utilities/setup/dol-user-env.csh.in)
AC_CONFIG_FILES(Utilities/setup/dol.pc:Utilities/setup/dol.pc.in)
AC_CONFIG_FILES(Utilities/setup/gds-user-env.sh:Utilities/setup/gds-user-env.sh.in)
AC_CONFIG_FILES(Utilities/setup/gds-user-env.csh:Utilities/setup/gds-user-env.csh.in)
AC_CONFIG_FILES(Utilities/procmgt/mkTrendDirs:Utilities/procmgt/mkTrendDirs.in)
AC_CONFIG_FILES(Utilities/procmgt/procmgt:Utilities/procmgt/procmgt.in)
AC_CONFIG_FILES(Utilities/procmgt/procsetup:Utilities/procmgt/procsetup.in)
])
