/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "VArg.hh"
#include "ParseLine.hh"
#include <stdexcept>
#include <cstdlib>

using namespace std;

//======================================  Constructor
VArg::VArg(int N) 
  : mKeyList(N), mArgList(N)
{}

//======================================  Add keyword
VArg& 
VArg::operator<<(const std::string& a) {
    mKeyList.push_back(a);
    mArgList.push_back("");
    return *this;
}

//======================================  Add keyword
VArg& 
VArg::operator=(const std::string& a) {
    mArgList.back() = a;
    return *this;
}

//======================================  Get key value
const std::string& 
VArg::operator[](const std::string& a) const {
    return mArgList[find(a)];
}

//======================================  Clear all entries
void 
VArg::erase(void) {
    mKeyList.clear();
    mArgList.clear();
}

//======================================  Find specified keyword
VArg::const_arg_iter 
VArg::findx(const std::string& a) const {
    const_arg_iter N = end();
    for (const_arg_iter inx=begin(); inx!=N; inx++) {
        if (mKeyList[inx] == a) return inx;
    }
    return N;
}

//======================================  Find specified keyword
VArg::const_arg_iter 
VArg::find(const std::string& a) const {
    const_arg_iter inx = findx(a);
    if (inx == end()) throw runtime_error(string("Undefined key: ") + a);
    return inx;
}

//======================================  Get key value (convert to numeric)
double 
VArg::getDouble(const std::string& a) const {
    return strtod((*this)[a].c_str(), 0);
}

//======================================  Scan command line for values.
void
VArg::scan(const ParseLine& pl, int first, int last) {
    int N = pl.getCount();
    if (!last || last > N) last = N;
    scanx(pl, first, last);
    if (!mScanError.empty()) throw runtime_error(mScanError);
}

//======================================  Scan command line for values.
int
VArg::scanx(const ParseLine& pl, int first, int last) {
    mScanError.clear();
    for (int i=first; i<last; ++i) {

	//------------------------------  Look for this keyword..
	const_arg_iter inx = findx(pl[i]);
	if (inx == end()) {
	    mScanError = string("Undefined key: ") + pl[i];
	    return i;
	}

	//------------------------------  Value is "true" if this is the 
	//                                last argument or .
	else if (i+1 >= last) {
	    mArgList[inx] = "true";
	}

	//------------------------------  if followed by -xx it may be a number
	else if (*(pl[i+1]) == '-') {
	    char* p = 0;
	    strtod(pl[i+1], &p);
	    if (! *p) mArgList[inx] = pl[++i];
	    else      mArgList[inx] = "true";
	}

	//------------------------------  Doesn't start with "-", record value
	else {
	    mArgList[inx] = pl[++i];
	}
    }
    return last;
}
