#include "Segment.hh"

using namespace trig;
using namespace std;

//======================================  Constructors.
Segment::Segment(const string& grp, int vsn, const Time& strt, const Time& end)
  : mCreatorDB(0), mGroup(grp), mVersion(vsn), mActivity(1), mStartTime(strt), 
    mEndTime(end)
{
}

//======================================  Operators.
bool 
Segment::operator==(const Segment& x) const {
    return (mGroup     == x.mGroup     && mVersion   == x.mVersion &&
	    mIfos      == x.mIfos      && mActivity  == x.mActivity &&
	    mStartTime == x.mStartTime && mEndTime   == x.mEndTime);
}

//======================================  Mutators.
void 
Segment::setActivity(int act) {
      mActivity = act;
}

void 
Segment::setComment(const string& com) {
    mComment = com;
}

void 
Segment::setEndTime(const Time& t0) {
    mEndTime = t0;
}

void 
Segment::setGroup(const char* group) {
    mGroup = group;
}

void 
Segment::setIfos(const char* ifo) {
    mIfos = ifo;
}

void 
Segment::setProcess(const char* proc) {
    mProcess = proc;
}

void 
Segment::setSegID(const std::string& SegID) {
    mSegID = SegID;
}

void 
Segment::setStartTime(const Time& t0) {
    mStartTime = t0;
}

void 
Segment::setVersion(int version) {
    mVersion = version;
}
