//////////////////////////////////////////////////////////////////////////
//  									//
//  Window								//
//  									//
//////////////////////////////////////////////////////////////////////////

#include "events/Window.hh"
#include "events/Event.hh"


namespace events {

//______________________________________________________________________________
   class WindowIteratorImp : public IteratorImp {
   public:
      typedef std::deque<Event*>::iterator iterator;
      WindowIteratorImp (const iterator& i) : fIter (i) {
      }
      virtual IteratorImp* Copy() const {
         return new (std::nothrow) WindowIteratorImp (*this); }
      virtual Event* Get() const {
         return *fIter; }
      virtual void Inc() {
         ++fIter; }
      virtual void Dec()  {
         --fIter; }
   private:
      iterator		fIter;
   };

//______________________________________________________________________________
   class ConstWindowIteratorImp : public IteratorImp {
   public:
      typedef std::deque<Event*>::const_iterator iterator;
      ConstWindowIteratorImp (const iterator& i) : fIter (i) {
      }
      virtual IteratorImp* Copy() const {
         return new (std::nothrow) ConstWindowIteratorImp (*this); }
      virtual Event* Get() const {
         return *fIter; }
      virtual void Inc() {
         ++fIter; }
      virtual void Dec()  {
         --fIter; }
   private:
      iterator		fIter;
   };

//______________________________________________________________________________
   Window::Window (const TimeWindow& window, int order)
   : mWindow (window), mCurrent (order, (pointer)0) 
   {
   }

//______________________________________________________________________________
   Window::Window (const Interval& width, const Interval& offset, int order)
   : mWindow (width, offset), mCurrent (order, (pointer)0) 
   {
   }

//______________________________________________________________________________
   Window::Window (pointer event) 
   : mWindow(1.0,-0.5), mCurrent (1, (pointer)0)
   {
      PushBack (event);
      SetCurrent (0, event); 
   }

//______________________________________________________________________________
   Window::Window (pointer e1, pointer e2) 
   : mWindow(1.0,-0.5), mCurrent (2, (pointer)0)
   {
      PushBack (e1); PushBack (e2);
      SetCurrent (0, e1); SetCurrent (1, e2); 
   }

//______________________________________________________________________________
   bool Window::operator== (const Window& win) const
   {
      return mCurrent == win.mCurrent;
   }

//______________________________________________________________________________
   Time Window::GetTimeFirst() const 
   {
      if (mList.empty()) {
         return Time (0);
      }
      else {
         return mList.front()->GetTime();
      }
   }

//______________________________________________________________________________
   Time Window::GetTimeLast() const 
   {
      if (mList.empty()) {
         return Time (0);
      }
      else {
         return mList.back()->GetTime();
      }
   }

//______________________________________________________________________________
   Time Window::GetTime() const 
   {
      Time t (0);
      int n = GetOrder();
      if (n == 1) {
         t = mCurrent.front()->GetTime();
      }
      else {
         for (int i = 0; i < n; ++i) {
            t += Interval (mCurrent[i]->GetTime().totalS() / (double)n);
         }
      }
      return t;
   }

//______________________________________________________________________________
   Time Window::GetStartTime() const 
   {
      if (GetOrder() < 1) {
         return Time (0);
      }
      else {
         return mCurrent.front()->GetTime() + mWindow.GetOffset();
      }
   }

//______________________________________________________________________________
   Time Window::GetStopTime() const 
   {
      if (GetOrder() < 1) {
         return Time (0);
      }
      else {
         return mCurrent.front()->GetTime() + mWindow.GetOffset() +
            mWindow.GetWidth();
      }
   }

//______________________________________________________________________________
   Window::iterator Window::Begin()
   {
      return iterator (WindowIteratorImp (mList.begin()));
   }

//______________________________________________________________________________
   Window::const_iterator Window::Begin() const
   {
      return const_iterator (ConstWindowIteratorImp (mList.begin()));
   }

//______________________________________________________________________________
   Window::iterator Window::End()
   {
      return iterator (WindowIteratorImp (mList.end()));
   }

//______________________________________________________________________________
   Window::const_iterator Window::End() const
   {
      return const_iterator (ConstWindowIteratorImp (mList.end()));
   }

}
