/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "FileList.hh"
#include <fstream>
#include <string>
#include <iostream>
#include <sys/types.h>
#include <dirent.h>
#include <fnmatch.h>

using namespace std;

//======================================  Constructor
FileList::FileList(void) {
}

//======================================  Destructor
FileList::~FileList(void) {
    mFile.clear();
}

//======================================  Compare filename to full path
inline int
filecmp(const char* file, const string& path) {
    const char* pstr = path.c_str();
    const char* fstart = pstr;
    while (*pstr) if (*(pstr++) == '/') fstart = pstr;
    while (*fstart && *fstart == *file ) {
        fstart++;
	file++;
    }
    if (*file > *fstart) return  1;
    if (*file < *fstart) return -1;
    return 0;
}

inline bool 
filelt(const char* file, const string& path) {
    return filecmp(file, path) < 0;
}

inline bool 
filegt(const char* file, const string& path) {
    return filecmp(file, path) > 0;
}

//======================================  Specify a data source to be read.
void 
FileList::addList(const std::string& File) {
    if (File.empty()) return;
    ifstream inf(File.c_str());
    long nStartFile = mFile.size();
    cout << "Processing frame list file: " << File << endl;
    string fname;
    while (inf.good()) {
        fname.clear();
        inf >> fname;
	if (!inf) break;
	while (fname.size() > 0 && fname[0] == ' ') fname.erase(0,1);
	int l = fname.size();
	if (l<=0 || fname[0] == '#') continue;
	while (l>0 && (fname[l-1]==' ' || fname[l-1]=='\n'))fname.erase(--l);
	if (l>0) addFile(fname);
    }
    cout << "        Number of files added: " << mFile.size() - nStartFile
	 << " Total frame files: " << mFile.size() << endl;
}

//======================================  Specify a data source to be read.
void 
FileList::addFile(const std::string& File) {
    if (File.empty()) return;
    string entry(File);

    //----------------------------------  Resolve wild-cards.
    if (entry.find("*") != string::npos) {

	//------------------------------  Find the directory name
	string::size_type ndir = entry.rfind("/");
	string direc;
	if (ndir == string::npos) {
	    direc = ".";
	} else {
	    direc = entry.substr(0, ndir);
	    if (direc.find("*") != string::npos) {
	        cerr << "FileList doesn't do directory wild-cards as in " 
		     << entry << endl;
		return;
	    }
	}

	//------------------------------  Open the directory.
	DIR* dd = opendir(direc.c_str());
	if (!dd) {
	    cerr << "Directory " << direc << " is unknown" << endl;
	    return;
	}

	//------------------------------  Scan for files matching the pattern
	file_iter fi = mFile.begin();
	string pattern(entry.substr(ndir+1,entry.length()-ndir-1));
	for (struct dirent* dirt=readdir(dd) ; dirt ; dirt=readdir(dd)) {
	    if (!fnmatch(pattern.c_str(), dirt->d_name, 0)) {
	        string fullname = direc + "/" + string(dirt->d_name);

		//----------------------  Insert file name into list
		if (mFile.empty() || filegt(dirt->d_name, mFile.back())) {
		    mFile.push_back(fullname);
		} else if (filelt(dirt->d_name, mFile.front())) {
		    mFile.push_front(fullname);
		} else if ( filegt(dirt->d_name, *fi) ) {
		    for ( ; fi != mFile.end() ; ++fi) {
		        if (filelt(dirt->d_name, *fi)) break;
		    }
		    mFile.insert(fi, fullname);
		} else {
		    while ( fi != mFile.begin() ) {
		        if (filegt(dirt->d_name, *(--fi))) break;
		    }
		    mFile.insert(++fi, fullname);
		}
		if (fi == mFile.end()) fi--;
	    }
	}
	closedir(dd);

    //----------------------------------  Push a single entry.
    } else {
	mFile.push_back(entry);
    }
}

//======================================  Print the file list
std::ostream& 
FileList::print(std::ostream& out) const {
    if (empty()) return out << "No files requested." << endl;
    for (const_file_iter i=mFile.begin(); i != mFile.end(); ++i) {
        out << *i << endl;
    }
    return out;
}

//======================================   First string reference.
const std::string&
FileList::first(void) const {
    static const string str_null;
    if (empty()) return str_null;
    return mFile.front();
}
