#include "Process.hh"

//======================================  Construct a process entry
Process::Process(const trig::TrigProc& x) 
  : mProcess(x), mRecvCount(0), mWriteCount(0), mErrorCount(0), 
    mWritten(false), mClosed(false), mLastMsg(-1)
{}

//======================================  Construct a process entry
Process::Process(void)
  : mRecvCount(0), mWriteCount(0), mErrorCount(0), mWritten(false), 
    mClosed(false), mLastMsg(-1)
{}

//======================================  Copy a process entry
Process::Process(const Process& x) 
  : mProcess(x.mProcess), mRecvCount(x.mRecvCount), mWriteCount(x.mWriteCount),
    mErrorCount(x.mErrorCount), mWritten(x.mWritten), mClosed(x.mClosed), 
    mLastMsg(x.mLastMsg)
{}

//======================================  Destroy a process entry
Process::~Process(void) {
}

//======================================  Set the written flag
void 
Process::setWritten(void) {
    mWritten = true;
}

//======================================  Set the closed flag
void 
Process::setClosed(void) {
    mClosed = true;
}

//======================================  Test whether Message ID is unique
bool
Process::testMsgID(int msgid) {
    if (msgid == mLastMsg) return false;
    mLastMsg = msgid;
    return true;
}
