/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <time.h>
#include <iostream>
#include "PConfig.h"
#ifdef __GNU_STDC_OLD
#include <gnusstream.h>
#else
#include <sstream>
#endif
#include <sys/stat.h>
#include <unistd.h>
#include "NameClient.hh"
#include "NameMsg.hh"
#include "lmsg/MsgHeader.hh"
#include "lmsg/MsgTypes.hh"
#include "lmsg/Socket.hh"
#include "lmsg/ErrorList.hh"
#include <cstdlib>

using namespace lmsg;
using namespace std;

const MsgAddr::ipport_t default_port = 23456;

NameClient::~NameClient(void) {
}

NameClient::NameClient(void) 
  : mDomainServer(0, default_port), mLocal(false)
{
    const char* server = ::getenv("DMTNAMESERVER");
    if (server) setDomain(server);
    else        localInit();
}

error_type 
NameClient::setDomain(const char* domain) {
    mDomainName = domain;
    return findDomainServer();
}

error_type 
NameClient::addName(const char* name, const MsgAddr& addr, 
			  NameProcs type) {
    return addName(NameData(name, addr, type));
}

error_type 
NameClient::addName(const NameData& name) {
    error_type rc = OK;
    if (mLocal) rc = localAdd(name.getName(), name.getAddr());
    else        rc = doRequest(AddName(name));
    return rc;
}

error_type 
NameClient::getIndex(string& Directory, MsgAddr::ipaddr_t ipnode, 
			   NameProcs type) {
    error_type rc = OK;
    if (mLocal) {
        Directory.erase();
    } else {
        NameData reply;
	MsgAddr addr(ipnode);
	rc = doRequest(NameIndex(NameData("", addr, type)), &reply);
	if (!rc) Directory = reply.getName();
    }
    return rc;
}

error_type 
NameClient::remName(const char* name) {
    return remName(NameData(name, MsgAddr(0)));
}

error_type 
NameClient::remName(const NameData& name) {
    error_type rc = OK;
    if (mLocal) rc = localRemove(name.getName());
    else        rc = doRequest(RemoveName(name));
    return rc;
}

error_type 
NameClient::lookup(const char* name, MsgAddr& addr) {
    NameData reply;
    index_type rc = lookup(name, reply);
    if (rc) return rc;
    addr = reply.getAddr();
    return OK;
}

error_type 
NameClient::lookup(const char* name, NameData& reply) {
    error_type rc(OK);
    if (mLocal) rc = localResolve(name, reply);
    else        rc = doRequest(FindName(NameData(name, MsgAddr(0))), &reply);
    return rc; 
}

error_type 
NameClient::lookupID(int ident, MsgAddr& addr) {
    NameData reply;
    index_type rc = lookupID(ident, reply);
    if (rc) return rc;
    addr = reply.getAddr();
    return OK;
}

error_type 
NameClient::lookupID(int ident, NameData& reply) {
    error_type rc(OK);
    if (mLocal) rc = Failure;
    else        rc = doRequest(IDget(ident), &reply);
    return rc; 
}

error_type 
NameClient::doRequest(const Message& req, NameData* rep) {
    error_type rc;
    if (rep) {
        NameStatus repmsg;
        MsgHeader  rephdr;
        rc = request(mDomainServer, req, rephdr, repmsg);
	if (!rc) {
	    *rep = repmsg.refData();
	    rep->fixAddr(rephdr.getSource());
	} else if (getDebug()) {
	    cout << "Server address set to " << mDomainServer << endl;
	}

    } else {
        MsgHeader rhdr;
        rc = request(mDomainServer, req, rhdr, 0, 0);
	if (!rc && rhdr.getMsgType() != m_OK) rc = Failure;
    }
    return rc;
}

error_type 
NameClient::findDomainServer(void) {
    if (mDomainName == "local") {
        localInit();
    } else {
        mDomainServer = MsgAddr::findIPHost(mDomainName.c_str());
	if (!mDomainServer.getIPPort()) mDomainServer.setIPPort(default_port);
	if (getDebug()) {
	    cout << "Server address set to " << mDomainServer << endl;
	}
    }
    return OK;
}

inline bool
fExists(const char* name) {
    return !access(name, F_OK);
}

void    
NameClient::localInit(void) {
    mLocal    = true;
    mLocalDir = "/tmp/DMTLocalNames";
    const char* user = getlogin();
    if (user) {
        mLocalDir += "_";
	mLocalDir += user;
    }

    const char* dir = mLocalDir.c_str();
    if (!fExists(dir)) mkdir(dir, 0777);
    mLocalDir += "/";
}

error_type 
NameClient::localAdd(const char* name, const MsgAddr& addr) {
    string fName = mLocalDir + name;
    if (fExists(fName.c_str())) unlink(fName.c_str());
    ostringstream addrStr;
    addrStr << addr << ends;
    if ( symlink(addrStr.str().c_str(), fName.c_str()) ) return SystemError;
    return OK;
}

error_type 
NameClient::localRemove(const char* name) {
    string fName = mLocalDir + name;
    unlink(fName.c_str());
    return OK;
}

error_type 
NameClient::localResolve(const char* name, NameData& reply) const {
    char buf[512];

    string fName = mLocalDir + name;
    int len = readlink(fName.c_str(), buf, sizeof(buf));
    if (len < 0) return SystemError;
    buf[len] = 0;
    reply = NameData(string(name), MsgAddr::findIPHost(buf));
    return OK;
}
