/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef ENDTIMES_HH
#define ENDTIMES_HH
#include "DatEnv.hh"
#include "OperStateCondList.hh"
#include "Time.hh"
#include "TrigClient.hh"
#include <string>
#include <vector>

class OperStateCondList;

/**  The end-times monitor generated segments during a programmable period 
  *  before the assertion of an osc condition.
  */
class EndTimes : public DatEnv, TrigClient {
public:
   EndTimes(int argc, const char* argv[]);
   ~EndTimes(void);
   void ProcessData(void);
   /**  Configure the monitor from the specified configuration file. The 
     *  configuration file contains one line for each segment to be gerneated.
     *  each line contains the following fields
     *  \verbose
          <OSC-condition> <time-delay> [<segment-name>]   \endverbose
     *  If the segment name is not specified, it is generated in the following
     *  form \c \<osc-name\>_PRE_\<delay\>.
     *  \brief Configure the monitor
     *  \param file Configuration file path
     *  \return True on failure.
     */
   bool configure(const std::string& file);

private:
   //===================================  Define a single condition.
   class end_test {
   public:
      end_test(const std::string& osc_name, Interval delay);
      ~end_test(void);
      void book(OperStateCondList& oscl);
      void set_segname(const std::string& sn);
      void test(const Time& tCur, const Time& tEnd,
		OperStateCondList& oscl, TrigClient& tc);
   private:
      std::string _osc_name;
      std::string _seg_name;
      Interval    _delay;
      int         _last_state;
      Time        _last_time;
      Time        _proc_time;
   };
   typedef std::vector<end_test> etime_list;
   typedef etime_list::iterator etime_iter;
   
private:
   etime_list        _list;
   OperStateCondList _oscl;
};

#endif // !defiend(ENDTIMES_HH)
