#include "html/text.hh" 
#include "html/table.hh"
#include "xml/XsilTSeries.hh"
#include "SetInfo.hh"
#include <sstream>
#include <vector>

using namespace std;
using namespace xml;

int SetInfo::sfData_attn [ kTSMaxNArray ];

SetInfo:: SetInfo (): fHist (0) { 
  sinit = false;
} 

SetInfo:: ~SetInfo () {
}

void SetInfo::Attention() {
  int nconf = GetNConf();
  int current_conf;
  for (current_conf = 0; current_conf<nconf; current_conf++) {
    int n = 0;
    fHistS.at(current_conf).Clear();
    fHistL.at(current_conf).Clear();
    (fHistL.at(current_conf)).SetTime ( (fHist_buff.at(current_conf)).front().GetTime() );
    for ( std::deque<Histogram1>::iterator itr = fHist_buff.at(current_conf).begin();
	  itr != fHist_buff.at(current_conf).end(); ++itr ) {
      fHistL.at(current_conf) += *itr;
      if ( n > 21 ) {
	fHistS.at(current_conf) += *itr;
	if ( n == 22 ) fHistS.at(current_conf).SetTime ( itr->GetTime() );
      }
      ++n;
    }
    n = 0;
    for ( std::deque<int>::iterator itr = fRate.at(current_conf).begin();
	  itr != fRate.at(current_conf).end(); ++itr, ++n ) {
      sfData_attn[n] = *itr;
    }
    fTSRate.at(current_conf).setData( Time (int( fTSRateStartTime.at(current_conf).getS() - (fRate.at(current_conf).size() - 1) * kTSUpdateInt ), fTSRateStartTime.at(current_conf).getN() ), kTSUpdateInt, sfData_attn, fRate.at(current_conf).size() );
  }
}

void SetInfo::TSSave( ofstream& out ) {
  int nconf = GetNConf();
  int current_conf;
  for (current_conf = 0; current_conf<nconf; current_conf++) {
    if ( fRate.at(current_conf).size() ) { 
      int n = 0;
      for ( std::deque<int>::iterator itr = fRate.at(current_conf).begin();
	    itr != fRate.at(current_conf).end(); ++itr, ++n ) {
	sfData_attn[n] = *itr;
      }
      fTSRate.at(current_conf).setData( Time ( int( fTSRateStartTime.at(current_conf).getS() - (fRate.at(current_conf).size() - 1) * kTSUpdateInt ), fTSRateStartTime.at(current_conf).getN() ), kTSUpdateInt, sfData_attn, fRate.at(current_conf).size() );
      out << xsilTSeries ( &fTSRate.at(current_conf) ) << endl;
    }
  }
}

void SetInfo::SetName(std::string& value) {
  fSName = value;
}

void SetInfo::SetTrigger(std::string& value) {
  trigger = value;
}

std::string SetInfo::GetName() {
  return fSName;
}

int SetInfo::GetNConf(){
  return ((fCCmap.begin())->second).size();
}

void SetInfo::AddPair(std::string chname, config_numbers c_numbers) {
  if (!fCCmap.empty()) {
    if (c_numbers.size() != ((fCCmap.begin())->second).size()) {
      cerr << "Number of configurations doesn't match for Set: " << fSName << "; Channel: " << chname << endl;
    }
  }
  if (fCCmap.find(chname) != fCCmap.end()) {
    cerr << "Channel name redundancy for Set: " << fSName << "; Channel: " << chname << endl;
  }
  fCCmap[ chname.c_str() ] = c_numbers;
}

void 
SetInfo::findCoincidentEvents(EventList& master_elist, 
			      std::vector<std::string>& Einfo_log, 
			      ChannelList& ChList) {
  int nchan = fCCmap.size();
  EventList temp_elist;
  int nconf = (fCCmap.begin()->second).size();
  int which_conf;
  int current_ch;
  std::string logstr;
  std::string filter_str;
  std::string nsigma_str;
  vector<int> coinc_event_location(nchan);
  bool coinc;
  vector<Time> event_times(nchan);
  Time time1;
  Time time2;
  Interval current_error;
  Interval prev_error; 
  Interval max_error(1);
  vector<EventInfo> coinc_events(nchan);
 

  for (int current_config = 0; current_config<nconf; current_config++) {
    temp_elist.clear();
    vector<EventList> elists(nchan);
    current_ch = 0;
    for (ChanConfig_map::iterator mitr = fCCmap.begin(); 
	 mitr != fCCmap.end(); ++mitr) {
      ChannelList::iterator chitr = ChList.begin();
      bool found = false;
      while ((chitr != ChList.end()) && !found) {
	if ((strcasecmp((mitr->first).c_str(),(chitr->GetName())))==0) {
	  found = true;
	  which_conf = mitr->second.at(current_config);
	  chitr->getElist(which_conf,temp_elist);
	  elists[current_ch] = temp_elist;
	}
	++chitr;
      }
      current_ch++;
    }
    int n1 = 0;
    for (EventList::iterator evitr = elists[0].begin(); 
	 evitr != elists[0].end(); ++evitr) {
      event_times[0] = evitr->fStartTime;
      time1 = event_times[0];
      coinc_events[0] = *evitr;
      coinc_event_location[0] = n1;
      coinc = true;
      if (nchan>1) {
	for (current_ch = 1; current_ch<nchan; ++current_ch) {
	  prev_error = max_error + Interval(1);
	  int n2 = 0;
	  for (EventList::iterator evitr2 = elists[current_ch].begin();
	       evitr2 != elists[current_ch].end(); ++evitr2) {
	    time2 = evitr2->fStartTime;
	    current_error = time1-time2;
	    if (abs(current_error.GetSecs()) <= abs(prev_error.GetSecs())) {
	      event_times[current_ch] = time2;
	      coinc_events[current_ch] = *evitr2;
	      coinc_event_location[current_ch] = n2;
	      prev_error = current_error;
	    }
	    ++n2;
	  }
	  if (abs(prev_error.GetSecs())> abs(max_error.GetSecs())) {
	    coinc = false;
	  }
	  else if ((coinc==true)&&(current_ch>1)) {
	    for (int ch = 1; ch<current_ch; ++ch) {
	      if (!Almost(event_times[current_ch], event_times[ch], long(max_error.GetSecs()*1000000000))) {
		coinc = false;
	      }
	    }
	  }
	}
      }
      if (coinc==true) {
	bool above_high_th = true;
	cout<<"coincident event"<<endl;
	logstr.erase();
	logstr += "<td>";
	logstr += fSName;
	logstr += "</td><td>";
	filter_str.erase();
	filter_str += "<td>";
	nsigma_str.erase();
	nsigma_str += "<td>";
	current_ch = 0;
	// Update event rates
	for (ChanConfig_map::iterator mitr = fCCmap.begin(); 
	     mitr != fCCmap.end(); ++mitr) {
	  if (mitr != fCCmap.begin()) {
	    logstr += "<br>";
	    filter_str += "<br>";
	    nsigma_str += "<br>";
	  }
	  logstr += mitr->first;
	  std::ostringstream ostr;
	  ostr.clear();
	  ostr << coinc_events[current_ch].fMaxData;
	  nsigma_str += ostr.str();

	  ChannelList::iterator chitr = ChList.begin();
	  bool found = false;
	  while ((chitr != ChList.end()) && !found) {
	    if ((strcasecmp((mitr->first).c_str(),(chitr->GetName())))==0) {
	      found = true;
	      which_conf = mitr->second.at(current_config);
	      filter_str += chitr->getFilterFormula(which_conf);
	      chitr->CheckAboveHighThreshold_ch(coinc_events[current_ch], which_conf, above_high_th);
	      //chitr->CoincidentUpdate_low(coinc_events[current_ch],which_conf);
	      //++(fRate.at(current_config).back());
	      //(fHist_buff.at(current_config)).back().Fill (c_event.fMaxData);
	      chitr->AddErasure_ch(which_conf, coinc_event_location[current_ch]);
	    }
	    ++chitr;
	  }
	  current_ch++;
	}

	current_ch = 0;
	for (ChanConfig_map::iterator mitr = fCCmap.begin(); 
	     mitr != fCCmap.end(); ++mitr) {
	  if (strcasecmp((mitr->first).c_str(), trigger.c_str()) == 0) {
	    ++(fRate.at(current_config).back());
	    (fHist_buff.at(current_config)).back().Fill(coinc_events[current_ch].fMaxData);
	    if (above_high_th) {
	      master_elist.push_back(coinc_events[current_ch]);
	    }
	  }
	  ++current_ch;
	}


	

	filter_str += "</td>";
	nsigma_str += "</td>";
	logstr += filter_str;
	logstr += nsigma_str;
	
	if (above_high_th) {
	  Einfo_log.push_back(logstr);
	}
      }
      n1++;
    }
  }
}


void SetInfo::ConfigLog(html::table& results, ChannelList& ChList){
  std::string dashes_comment = "-------------------------------------------------------";
  std::string dashes_long = "---------------------------------";
  std::string dashes_short = "-----------";
  results.addRow();
  int row = results.getNRow () - 1;
  results.insertData(row,0,html::text (fSName.c_str()));
  int nconf = ((fCCmap.begin())->second).size();
  int which_conf;
  int ch_row;

  html::table config_table;
  config_table.setBorder(false);
  html::table ch_table;
  ch_table.setBorder(false);
  html::table chlock_table;
  chlock_table.setBorder(false);
  html::table ttype_table;
  ttype_table.setBorder(false);
  html::table tlow_table;
  tlow_table.setBorder(false);
  html::table thigh_table;
  thigh_table.setBorder(false);
  html::table filt_table;
  filt_table.setBorder(false);
  html::table minsep_table;
  minsep_table.setBorder(false);
  html::table mindur_table;
  mindur_table.setBorder(false);
  html::table maxdur_table;
  maxdur_table.setBorder(false);
  html::table mindens_table;
  mindens_table.setBorder(false);
  html::table comment_table;
  comment_table.setBorder(false);
  std::vector<html::table> Tables;
  Tables.push_back(chlock_table);
  Tables.push_back(ttype_table);
  Tables.push_back(tlow_table);
  Tables.push_back(thigh_table);
  Tables.push_back(filt_table);
  Tables.push_back(minsep_table);
  Tables.push_back(mindur_table);
  Tables.push_back(maxdur_table);
  Tables.push_back(mindens_table);
  Tables.push_back(comment_table);

  for (int current_conf = 0; current_conf<nconf; ++current_conf) {
    std::ostringstream o;
    o << current_conf + 1;
    std::string confstring;
    confstring = "Config";
    confstring += o.str();
    html::text conftext (confstring.c_str());
    if (config_table.getNColumn()==0) {
      config_table.addColumn(confstring.c_str());
      config_table.refHeader(0).setAlign("center");
    }
    else {
      config_table.addRow();
      int rowc = config_table.getNRow() -1;
      config_table.insertData(rowc,0,conftext);
      config_table.refCell(rowc,0).setAlign("center");

    }
    int current_chan = 0;
    for (ChanConfig_map::iterator mitr = fCCmap.begin(); 
	 mitr != fCCmap.end(); ++mitr) {
      if (mitr != fCCmap.begin()) {
	config_table.addRow();
	std::string spaces = "   \"   ";
	config_table.insertData(config_table.getNRow()-1, 0, html::text (spaces.c_str()));
	config_table.refCell (config_table.getNRow()-1, 0 ).setAlign ( "center" );
      }
      ChannelList::iterator chitr = ChList.begin();
      bool found = false;
      while ((chitr != ChList.end()) && !found) {
	if ((strcasecmp((mitr->first).c_str(),(chitr->GetName())))==0) {
	  found = true;
	  which_conf = mitr->second.at(current_conf);
	  if (ch_table.getNColumn()==0) {
	    ch_table.addColumn(chitr->GetName());
	    ch_table.refHeader(0).setAlign("center");
	  }
	  else {
	    ch_table.addRow();
	    ch_row = ch_table.getNRow() - 1;
	    ch_table.insertData(ch_row,0,html::text(chitr->GetName()));
	    ch_table.refCell(ch_row, 0).setAlign("center");
	  }
	  chitr->ConfigLog(which_conf, Tables);

	}
	++chitr;
      }
      current_chan++;
    }
    if ((current_conf+1) != nconf) {
      ch_table.addRow();
      int rowc = ch_table.getNRow()-1;
      ch_table.insertData(rowc, 0, html::text(dashes_long.c_str()));
      ch_table.refCell(rowc, 0).setAlign("center");
      int current_table = 0;
      for (std::vector<html::table>::iterator tabitr = Tables.begin();
	   tabitr+1 != Tables.end(); ++tabitr) {
	tabitr->addRow();
	if (current_table != 4){
	  tabitr->insertData(rowc, 0, html::text(dashes_short.c_str()));
	}
	else {
	  tabitr->insertData(rowc, 0, html::text(dashes_comment.c_str()));
	}
	tabitr->refCell(rowc, 0).setAlign("center");
	current_table++;
      }
      (Tables.end()-1)->addRow();
      (Tables.end()-1)->insertData(rowc, 0, html::text(dashes_comment.c_str()));
      (Tables.end()-1)->refCell(rowc, 0).setAlign("center");
    }
    if ((current_conf+1) != nconf) {
      config_table.addRow();
      int rowc = config_table.getNRow()-1;
      config_table.insertData(rowc, 0, html::text(dashes_short.c_str()));
      config_table.refCell(rowc, 0).setAlign("center");
    }
  }
  results.insertData(row, 1, config_table);
  results.insertData(row, 2, ch_table);
  for (int i = 3; i<=12; i++) {
    results.insertData(row, i, Tables.at(i-3));
  } 
}


void SetInfo::ResetStat ( MonServer& mserv, Trend& trend, const std::vector<TSeries>& tlist, int ts_interval) {
  int nconf = GetNConf();
  int current_conf;
  for (current_conf = 0; current_conf<nconf; current_conf++) {
    std::string temp_trend_name = GetName();
    temp_trend_name += "_config";
    temp_trend_name += current_conf+1;
    trend_channel_name.push_back(temp_trend_name);

    if ( !trend.getName().empty() ) {
      trend.addChannel ( trend_channel_name.at(current_conf).c_str() );
    }
    std::string name_hists = trend_channel_name.at(current_conf);
    name_hists += "_H2hrs";
    std::string name_histl = trend_channel_name.at(current_conf);
    name_histl += "_H24hrs";
    std::string name_ts = trend_channel_name.at(current_conf);
    name_ts += "_T";
    
    Histogram1 temp_fHistS = fHist->CreateHistogram( name_hists.c_str(), "Number of Std. Dev", "Count" );
    Histogram1 temp_fHistL = fHist->CreateHistogram( name_histl.c_str(), "Number of Std. Dev", "Count" );

    fHistS.push_back(temp_fHistS);
    fHistL.push_back(temp_fHistL);

    // fHistS.at(current_conf) = fHist->CreateHistogram( name_hists.c_str(), "Number of Std. Dev", "Count" );
//     fHistL.at(current_conf) = fHist->CreateHistogram( name_histl.c_str(), "Number of Std. Dev", "Count" );

    std::deque<Histogram1> fHist_buff_temp;
    for ( int i = 0; i < 24; ++i ) {
      fHist_buff_temp.push_back( fHist->CreateHistogram () );
//(fHist_buff.at(current_conf)).push_back ( fHist->CreateHistogram () );
    }
    fHist_buff.push_back(fHist_buff_temp);
    
    std::deque<int> fRate_temp;
    for ( int i = 0; i < ts_interval; ++i ) {
      //(fRate.at(current_conf)).push_back( (int) 0 );
      fRate_temp.push_back( (int) 0 );
    }
    fRate.push_back(fRate_temp);

    TSeries fTSRate_temp;
    fTSRate_temp.setName( name_ts.c_str() );
    //(fTSRate.at(current_conf)).setName ( name_ts.c_str() );
    for ( vector<TSeries>::const_iterator itr = tlist.begin();
	  itr != tlist.end(); ++itr ) {
      if ( strcasecmp ( itr->getName(), name_ts.c_str() ) == 0 ) {
	//fTSRate.at(current_conf) = *itr;
	fTSRate_temp = *itr;
	break;
      }
    }
    fTSRate.push_back(fTSRate_temp);
    
    mserv.serveData( name_hists.c_str(), &(fHistS.at(current_conf)) );
    mserv.serveData( name_histl.c_str(), &(fHistL.at(current_conf)) );
    mserv.serveData( name_ts.c_str(), &(fTSRate.at(current_conf)) );
  }
  
}

void SetInfo::Init (const Time& t) {
  if (!sinit) {
    int nconf = GetNConf();
    int current_conf;
    for (current_conf = 0; current_conf<nconf; current_conf++) {
      for ( std::deque<Histogram1>::iterator itr = fHist_buff.at(current_conf).begin();
	    itr != fHist_buff.at(current_conf).end(); ++itr ) {
	itr->SetTime ( t );
      }
      Time::ulong_t tS = t.getS();
      tS -= tS%60;

      Time fTSRateStartTime_temp = Time(tS, 0);
      fTSRateStartTime.push_back(fTSRateStartTime_temp);
      
      int arraysize = fRate.at(current_conf).size();
      int ts_size = fTSRate.at(current_conf).getNSample();
      Time start_time = fTSRateStartTime.at(current_conf) - Interval ( (arraysize - 1) * kTSUpdateInt );
      if ( fTSRate.at(current_conf).getEndTime() < fTSRateStartTime.at(current_conf) && 
	   fTSRate.at(current_conf).getEndTime() >= start_time ) {
	std::deque<int>::iterator itr = fRate.at(current_conf).begin();
	while ( start_time < fTSRate.at(current_conf).getStartTime() ) {
	  ++itr;
	  start_time += Interval (kTSUpdateInt);
	}
	int data[ ts_size ]; 
	fTSRate.at(current_conf).getData( ts_size, data );
	for ( int i = fTSRate.at(current_conf).getBin ( start_time );
	      i < ts_size; ++i, ++itr ) {
	  *itr = data[ i ];
	}
      }
      fTSRate.at(current_conf).Clear();
    }
    sinit = true;
  }
}

bool SetInfo::IsInit() {
  if (sinit) return true;
  else return false;
}

void SetInfo::UpdateHistogram( const Time& t, Trend& trend ) {
  int nconf = GetNConf();
  int current_conf;
  for (current_conf = 0; current_conf<nconf; current_conf++) {
    if ( Interval( kHistUpdateInt ) <= t - fHist_buff.at(current_conf).back().GetTime() ) {
      fHist_buff.at(current_conf).pop_front ();
      fHist_buff.at(current_conf).push_back ( fHist->CreateHistogram () );
      fHist_buff.at(current_conf).back().SetTime (t);
    }
    
    if ( Interval( kTSUpdateInt ) <= t - fTSRateStartTime.at(current_conf) ) {
      if ( !trend.getName().empty() ) {
	trend.trendData( trend_channel_name.at(current_conf).c_str(), t - Interval(30,0), fRate.at(current_conf).back() );
      }
      fTSRateStartTime.at(current_conf) = t;
      fRate.at(current_conf).pop_front();
      fRate.at(current_conf).push_back ( (int) 0 );
    }
  }
}
