/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "wfigure.hh"
#include "TCanvas.h"
#include <iostream>
#include <sstream>
#include <cstdlib>

#define ASYNCH_THUMB_BUILD 1

#ifdef   ASYNCH_THUMB_BUILD
#include <signal.h>
#include "PConfig.h"
#include <unistd.h>
#endif

using namespace wpipe;
using namespace std;


#ifdef ASYNCH_THUMB_BUILD
//======================================  Asynchronous shell command execution.
static int
frog(const string& s) {
#if defined (P__DARWIN)
    sigignore(SIGCHLD);
#else
    sigignore(SIGCLD);
#endif

    pid_t pid = fork();
    if (pid != 0) {
	if (pid == -1) perror("fork failed");
	else           pid = 0;
	return pid;
    }
    string a(s);
    a += char(0);
    const char* argv[32];
    argv[0] = 0;
    char* p = &a[0];
    for (int i=0; i<31 && *p; ) {
        while (*p == ' ') *p++ = 0;
	if (*p) argv[i] = p;
	while (*p && *p != ' ') p++;
	argv[++i] = 0;
    }
    exit(execvp(argv[0], const_cast<char* const*>(argv)));
}
#endif

//======================================  figure constructor
wfigure::wfigure(void) 
    : _wx(21), _wy(15), _format(".png")
{
}

//======================================  clear figure
void 
wfigure::clear(void) {
    _plot.new_plot();
}

//======================================  open figure
void 
wfigure::open(void) {
    _plot.set_canvas(new TCanvas("w-pipeline"));
}

//======================================  set canvas size
void 
wfigure::set_size(int nw, int nh) {
    _wx = nw;
    _wy = nh;
}

//======================================  set smoothing
void
wfigure::set_smooth(int n, const string& opt) {
    _plot.set_smooth(n, opt);
}

//======================================  set file format
void 
wfigure::set_format(const std::string& fmt) {
    _format = fmt;
    if (_format.empty()) {
	_format = ".png";
    }
    else if (_format[0] != '.') {
	_format.insert(0, ".");
    }
}

//======================================  plot a time series
void 
wfigure::wtimeseries(const TSeries& ts, const Time& centerTime, 
		     Interval before, Interval after, 
		     const std::string& channelName) {
  Time tStart(centerTime + before);
  Interval dT = after - before;
  const TSeries tsPlot(ts.extract(tStart, dT));
  _plot.set_color(600);
  string yttl = "Amplitude";
  string units = tsPlot.getUnits();
  if (!units.empty()) {
    yttl += " [";
    yttl += units + "]";
  }
  _plot.ylabel(yttl);
  double tink = _plot.xTimeScale(dT, "Time");
  _plot.plot(*(tsPlot.refDVect()), before/tink, 
	     ts.getTStep()/tink, channelName);
}

#if 0
//======================================  plot a spectrogram
void 
wfigure::wspectrogram(const qTransform& transform, const wtile& tiling, 
		      const Time& centerTime, const dble_vect& timeRange,
		      const dble_vect& frequencyRange, const dble_vect& qRange,
		      const dble_vect& plotNormalizedEnergyRange, 
		      long horizontalResolution) {
}

//======================================  plot an eventgram
void 
wfigure::weventgram(const weventlist& significants, const wtile& tiling, 
		    const Time& centerTime, const dble_vect& tRange,
		    const dble_vect& plotFrequencyRange, 
		    double plotDurationInflation, 
		    double plotBandwidthInflation, 
		    const dble_vect& plotNormalizedEnergyRange) {
}
#endif

//======================================  print figure
void 
wfigure::wprintfig(const std::string& figureBase, bool thumb) const {
  std::string file = figureBase + _format;
  _plot.set_size(_wx, _wy);
  _plot.print(file);
  if (thumb) {
    string thumb = figureBase + ".thumb.png";
    ostringstream cmd;
    cmd << "convert -format png -resize 320x240 -strip -depth 8 " 
	<< file << " " << thumb;
#ifdef ASYNCH_THUMB_BUILD
    if (frog(cmd.str())) {
#else
    if (system(cmd.str().c_str())) {
#endif
	cerr << "failed to create thumbnail with command: " << cmd.str()
	     << endl;
    }
  }
}
