/***************************************************************************
    File        : RandomRanrotW.h
    Description : Random number generator of type RANROT-W.
                  Adaption of the code by: Uniform random number generators
                  by Agner Fog, sources randomc.zip at www.agner.org/random/
 ---------------------------------------------------------------------------
    Begin       : Fri Jan 2 2004
    Author(s)   : Roberto Grosso
 ***************************************************************************/


/************************* RANROTW.CPP ****************** AgF 1999-03-03 *
*  Random Number generator 'RANROT' type W                               *
*  This version is used when a resolution higher that 32 bits is desired.*
*                                                                        *
*  This is a lagged-Fibonacci type of random number generator with       *
*  rotation of bits.  The algorithm is:                                  *
*  Z[n] = (Y[n-j] + (Y[n-k] rotl r1)) modulo 2^(b/2)                     *
*  Y[n] = (Z[n-j] + (Z[n-k] rotl r2)) modulo 2^(b/2)                     *
*  X[n] = Y[n] + Z[n]*2^(b/2)                                            *
*                                                                        *
*  The last k values of Y and Z are stored in a circular buffer named    *
*  randbuffer.                                                           *
*  The code includes a self-test facility which will detect any          *
*  repetition of previous states.                                        *
*  The function uses a fast method for conversion to floating point.     *
*  This method relies on floating point numbers being stored in the      *
*  standard 64-bit IEEE format or the 80-bit long double format.         *
*                                                                        *
*  The theory of the RANROT type of generators and the reason for the    *
*  self-test are described at www.agner.org/random/theory                *
*                                                                        *
* 2002 A. Fog. GNU General Public License www.gnu.org/copyleft/gpl.html *
*************************************************************************/


#ifndef __RANDOM_RANROTW_H
#define __RANDOM_RANROTW_H

// System Libs
#include <ctime>
#include <cstdlib>
#include <cstring>

// Project files
#include "Utilities.h"

namespace gwd {


  class RandomRanrotW {
    enum constants {KK = 17, JJ = 10, R1 = 19, R2 =  27};
  public:
    // Constructor
    RandomRanrotW()                       { DetectComputerArchitecture(); RandomInit((unsigned long int)time(NULL)); }
    RandomRanrotW(unsigned long int seed) { DetectComputerArchitecture(); RandomInit(seed);       }
    // Destructor
    virtual ~RandomRanrotW() { }

    // Methods
    void RandomInit(unsigned long int seed);  // initialization
    int IRandom(int min, int max);            // get integer random number in desired interval
    long double Random();                     // get floating point random number
    unsigned long int BRandom();              // output random bits

  protected:
    int p1, p2;                               // indexes into buffer
    union                                     // used for conversion to float
    {
      long double randp1;
      unsigned long int randbits[3];
    };
    unsigned long int randbuffer[KK][2];      // history buffer
    unsigned long int randbufcopy[KK*2][2];   // used for self-test
    enum Architecture
    {
      LITTLEENDIAN, BIGENDIAN, NONIEEE, EXTENDEDPRECISIONLITTLEENDIAN
    };
    Architecture mArchitecture;    // conversion to float depends on computer architecture

    //! Determine littleendian, bigendian number representation
    void DetectComputerArchitecture();
  };


} // namespce

#endif // __RANDOM_RANROTW_H
