/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef DUOTONE_HH
#define DUOTONE_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "FSpectrum.hh"
#include "TSeries.hh"
#include "Trend.hh"
#include "AlarmClient.hh"
#include <vector>

// #define DEBUG_DUOTONE

class ostream;

//
//    DUOTONE class header.
//
class DuoTone : public DatEnv, MonServer {
    class time_chan {
    public:
	enum chan_type {
	    tRamp,
	    tDuotone
	};
    public:
	time_chan(void) : _type(tDuotone), _f1(960), _f2(961), _offset(0) {}
	time_chan(const std::string& ch, chan_type t);
	/**  Return offset time in microseconds.
	  *  \brief calculate time offset
	  *  \param ts time series to measure time from.
	  *  \return Time delat in microseconds.
	  */
	double calculateTime(const TSeries& ts);
	const std::string& chan(void) {return _chan;}
	void params(const TSeries& ts);
	double rms(const TSeries& ts);
	void setF(double f1, double f2);
	/**  Set the nominal offset for this channel. 
	  *  \brief Set the nominal offset
	  *  \param Offset in microseconds.  
	  */
	void setOffset(double off);
	void set_subsys(const std::string& s);
	void setTrend(const std::string& tchan);
	const std::string& subsys(void) {return _subsys;}
	const char* trend(void) const {return _trendChan.c_str();}
	chan_type type(void) {return _type;}
    private:
	std::string _chan;
	std::string _subsys;
	chan_type   _type;
	double      _f1;
	double      _f2;
	double      _offset;
	std::string _trendChan;
	TSeries     _CosF1;                  ///<  cosine series for F1
	TSeries     _SinF1;                  ///<  sine series for F1
	TSeries     _CosF2;                  ///<  cosine series for F1
	TSeries     _SinF2;                  ///<  sine series for F1
	//------------------------------  fit parameters
	Time        _param_t0;
	double      _cCos1;
	double      _cSin1;
	double      _cCos2;
	double      _cSin2;
	double      _cOff;
    };
    typedef std::vector<time_chan> chan_vect;
public:
    int MaxFrame;                           //  Number of frames to process
    DuoTone(int argc, const char *argv[]);  // Constructor
    ~DuoTone();                             // Destructor
    void ProcessData(void);
    void Attention(void);
private:
    std::string trend;
    std::string IFO;
    std::string WebDir;
    std::string LogDir;
    std::string CaPutDir;
    std::string EpicsName;
    bool        Epics;
    Interval    Stride;
    double      alarmThreshold;
    std::string trendChan_QAF;
    std::string trendChan_ERR;
    Trend       mTrendMinute;
    AlarmClient mAlarm;
    chan_vect   mChannels;
};

#endif     //  DUOTONE_HH
