/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "gds_shmem.hh"
#include "lsmp_int.hh"
#include <iostream>
#include <iomanip>
#include <string>

using namespace std;

int
main(int argc, const char* argv[]) {
    gds_shmem shm;

    cout << "  id      name        nBuf   lBuf     nTotal" << endl;

    //---------------------------------  Loop over valid IDs
    for (int id=0; id < LSMP_MAXSHM; id++) {
	int shmid = LSMP_SHMBASE + id;
	if (shm.attach(shmid)) {
	    LSMP_global* ptr = reinterpret_cast<LSMP_global*>(shm.ref());
	    int nBuf = ptr->nbuf;
	    int nTot = 0;
	    for (int i=0; i<nBuf; i++) {
		nTot += ptr->refBuffer(i)->evt_count;
	    }
	    string name(ptr->name);
	    name.resize(16, ' ');
	    cout << setw(4) << shmid << "  " << name << "  " << nBuf 
		 << "  " << setw(8) << ptr->lbuf << "  " << setw(8) 
		 << nTot << endl;
	    shm.release();
	}
    }
}
