#include "html/label.hh"
#include "html/writer.hh"

using namespace html;
static const char* labelTag = "a";

//======================================  Default constructor
label::label(void) {}

//======================================  Data constructor
label::label(const std::string& name)
  : mName(name)
{}

//======================================  Destructor
label::~label(void) {
}

//======================================  Clone a label
label*
label::clone(void) const {
    return new label(mName);
}

//======================================  Write the label address.
void 
label::write(writer& out) const {
    if (mName.empty()) return;
    const char* keys[] = {"name"};
    const char* vals[] = {mName.c_str()};
    out.tag(labelTag, 1, keys, vals);
    out.endTag(labelTag);
}

//======================================  Set the label description
void 
label::setName(const std::string& name) {
    mName = name;
}
