#include "html/genAttr.hh"
#include "html/writer.hh"

using namespace html;

//======================================  Constructor
genAttr::genAttr(const std::string& value)
  : mValue(value)
{}

//======================================  Destructor
genAttr::~genAttr(void) {}

//======================================  Clone this attribute
genAttr* 
genAttr::clone(void) const {
    return new genAttr(*this);
}

//======================================  Test for default
bool 
genAttr::isDefault(void) const {
    return mValue.empty();
}

//======================================  Keyword only attribute
bool
genAttr::hasArg(void) const {
    return true;
}

//======================================  No data
void 
genAttr::putAttr(writer& w) const {
    w.text(mValue);
}

//======================================  Set string value
void 
genAttr::setValue(const std::string& value) {
    mValue = value;
}

//======================================  Assignment operator
bool 
genAttr::operator==(const genAttr& x) const {
    return mValue == x.mValue;
}
