/* -*- mode: c++; c-basic-offset: 4; -*- */
#include <time.h>
#include "CheckFrame.hh"
#include <cstdio>
#include <sstream>
using namespace std;

CheckFrame::CheckFrame(istream& in)
  : mFile(in), mDebug(0)
{
    //---------------------------------  Initialize the instance counts.
    for (int i=0 ; i<MaxID ; i++) {
        mInstCt[i] = 0;
	mDefID[i]  = false;
	mProcID[i] = false;
    }
    mDefID[1] = true;
    mDefID[2] = true;
}

CheckFrame::~CheckFrame() {
}

void
CheckFrame::Check(void) throw(BadFile) {
    //---------------------------------  Check the IGWD specifier
    mFile.ReadHeader();
    int hdrSz = mFile.getStrucHdrLen();

    //---------------------------------  Loop over structures
    while (1) {

        //-----------------------------  Read the structure header
        mFile.NxStruct();

        //-----------------------------  Check for valid structure length
	if (mFile.getLength() < hdrSz) {
	    ostringstream line;
	    line << "Illegal structure length " << mFile.getLength();
	    throw BadFile(line.str());
	}

        //-----------------------------  Check for valid structure ID
	int id = mFile.getID();
	if (id <= 0 || id >= MaxID || !mDefID[id]) {
	    ostringstream line;
	    line << "Illegal or undefined structure ID: " << id;
	    throw BadFile(line.str());
	}

        //-----------------------------  Check for valid instance number
	int inst = mFile.getInstance();
	if (inst != mInstCt[id]++) {
	    if (inst == 1 && mInstCt[id] == 1) {
		ostringstream line;
	        line << "Warning: First instance of structure " << id 
		     << " is 1";
		ErrorOut(line.str());
	        mInstCt[id]++;
	    } else {
		ostringstream line;
		line << "Illegal structure " << id << " instance " << inst
		     << " (" << mInstCt[id]-1 << " expected)";
		throw BadFile(line.str());
	    }
	}

	if (mDebug>1) {
	    ostringstream line;
	    line << "Length, id, instance = " << mFile.getLength() 
		 << " " << id << " " << inst; 
	    ErrorOut(line.str());
	}

	if (id == 1) {
            procSH();
	} else if (mProcID[id]) {
	    procID();
	}

	if (mFile.getID() == mEOFrID) {
	    if (mFile.getVersion() >= 4 && mFile.getVersion() < 6) {
	        for (int i=1 ; i<MaxID ; i++) mInstCt[i] = 0;
	    }
	}
	if (mFile.getID() == mEOFID) break;
    }
    if (mDebug) ErrorOut("End of Frame.");
}

void
CheckFrame::procSH(void) {
    string name(mFile.getString());

    unsigned short ID = mFile.getShort();

    string comment(mFile.getString());
    if (mProcID[mFile.getID()]) {
	ostringstream line;
        line << "Structure type SH, Instance: " << mFile.getInstance() 
	     << ", Length: mFile.getLength()";
	ErrorOut(line.str());
	line.str("");
	line << "  Name: " << name << "  ID: " << ID << " Comment: " << comment;
	ErrorOut(line.str());
    }

    if (!ID || ID > MaxID) throw BadFile("Illegal structure ID defined");

    mDefID[ID] = true;
    if (name == "FrEndOfFile")  mEOFID = ID;
    if (name == "FrEndOfFrame") mEOFrID = ID;
}

void
CheckFrame::procID(void) {
}

void
CheckFrame::ErrorOut(const std::string& error) {
    cout << error << endl;
}

