VCSID("$(#)$Id: testenv.cc 7338 2015-04-14 23:24:47Z ed.maros@LIGO.ORG $");
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: testenv							*/
/*                                                         		*/
/* Module Description: test environment abstract class			*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

/* Header File List: */

#include <time.h>
#include <iostream> // JCB
#include "dtt/testenv.hh"
#include "dtt/diagnames.h"
#include "dtt/diagdatum.hh"


namespace diag {
   using namespace std;
   using namespace thread;

   // JCB - initialize class instance count.
   int testenvironment::instance_count = 0 ;

   // JCB - move contructor to source file from header file.
   testenvironment::testenvironment()
   {
      myinstance = instance_count ; // JCB
      instance_count++; // JCB
      { // JCB
//	 char str[128] ;
//	 sprintf(str, "testenvironment instance %d created\n", myinstance) ;
//	 cerr << str ;
      }
   }


   testenvironment::~testenvironment () 
   {
      stopEnvrionment (_ONESEC);
      { // JCB
//	 char str[128] ;
//	 sprintf(str, "testenvironment instance %d destroyed\n", myinstance) ;
//	 cerr << str ;
      }
   }


   bool testenvironment::subscribeEnvironment (ostringstream& errmsg)
   {
      semlock		lockit (envmux);
      bool 		err = false;
   
      if (envexc == 0) {
         errmsg << "No excitation manager for environment" << endl;
         return false;
      }
   
      for (environmentlist::const_iterator iter = envlist.begin();
          iter != envlist.end(); iter++) {
         if (iter->active) {
            ostringstream	cmd (iter->waveform);
            /* add waveform points to arb command */
            if (iter->waveform.find ("arb") != string::npos) {
               for (vector<float>::const_iterator 
                   iter2 = iter->points.begin();
                   iter2 != iter->points.end(); iter2++) {
                  cmd << " " << *iter2;
               }
            }
         
            if (!envexc->add (iter->channel, cmd.str(), iter->wait)) {
               errmsg << "Invalid environment channel '" << iter->channel <<
                  "'" << endl;
               err = true;
            }
         }
      }
      return !err;
   }


   double testenvironment::waitEnvironment () const 
   {
      semlock		lockit (envmux);
   
      if (envexc != 0) {
         return envexc->dwellTime();
      }
      else {
         return -1;
      }
   }


   bool testenvironment::startEnvrionment (tainsec_t starttime, 
                     tainsec_t timeout) 
   {
      semlock		lockit (envmux);
   
      if (envexc != 0) {
         return envexc->start (starttime, timeout);
      }
      else {
         return false;
      }
   }


   bool testenvironment::stopEnvrionment (tainsec_t timeout) 
   {
      semlock		lockit (envmux);
   
      if (envexc != 0) {
         return envexc->stop (timeout);
      }
      else {
         return false;
      }
   }


   bool testenvironment::clearEnvrionment (tainsec_t timeout) 
   {
      semlock		lockit (envmux);
   
      if (envexc != 0) {
         return envexc->del ();
      }
      else {
         return false;
      }
   }


}
