const int nBin=512;
const int nIter=1024;

void
testSpectrum(void) {
    testPak t("testSpectrum", cout);

    //-------------------------------  Fill asn FSpectrum with random noise
    t.startSection("FSpectrum", "Test FSpectrum use");
    FSpectrum Sum;
    t.startTest("Average", "Average gaussian noise");
    for (long i=0; i<nIter; i++) {
        TSeries xx(Time(i), Interval(1.0/1024.0), 2*nBin, GaussNoise(1.0));
	if (!i) Sum  = FSpectrum(FSeries(xx));
	else    Sum += FSpectrum(FSeries(xx));
	t.testError(Sum.getCount(), double(i+1), 0.0, "FSpectrum Count Error");
    }
    t.endTest();

    t.startTest("Data", "Test Average results");
    for (float f=0; f<=nBin; f+=1.0) {
        float mean     = 2.0;
	if (f == 0 || f == nBin) mean = 1.0;
	float sigmaBin = mean/TMath::Sqrt(double(nIter));
	t.testError(Sum(f), mean, 3.0*sigmaBin, "Bin value error");
    }
    t.endTest();
    t.endSection();

    //--------------------------------  Build an FDFilter ~ 1/F
    t.startSection("FDFspectrum", "FD filtering FSpectrum");
    t.startTest("Construct", "Construct an FDFilter");
    float coef[nBin+1];
    coef[0] = 1.0;
    for (int j=1; j<=nBin; j++) coef[j] = 1.0/double(j);
    FSpectrum FiltSp(0.0, 1.0, Time(0), Interval(1.0), nBin+1, coef);
    FDFilter filt(FiltSp);
    // filt.getFSpectrum().Dump(cout);
    FSpectrum filtOut(filt.Apply(Sum));
    t.endTest();

    t.startTest("Check", "Check results");
    for (float f=0; f<=nBin; f+=1.0) {
        float test=Sum(f);
	if (f != 0.0) test /= f;
        t.testError(filtOut(f), test, 1e-6, "Spectrum contents incorrect");
    }
    t.endTest();
    t.endSection();
}
