/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef DatTEMPLATE_HH
#define DatTEMPLATE_HH

// startincludes
#include "DatEnv.hh"
#include "MonServer.hh"
#include "FixedLenTS.hh"
#include "Trend.hh"
#include "TrigClient.hh"
#include "SegAccountant.hh"
#include "autopipe.hh"
#include <string>
// endincludes

//
//    Data Monitor template class.

/**  @name DatTemplate
  *  @memo Template of a data environment (DatEnv) based monitor.
  *  The DatTemplate monitor is a template for a data monitor program.
  *  DatTemplate makes a simple calculation of the standard deviation of
  *  a specified channel (by default H0:PEM-LVEA_SEISX), serves the result 
  *  for display by the DMT viewer, stores the result as a minute trend and
  *  optionally writes a segment.
  *
  *  {\bf {\Large Running DatTemplate}}
  *
  *  The DatTemplate command line syntax is:
  *  \begin{verbatim}
        DatTemplate [-channel <channel>] [-frames <number>] [-stride <time>] \
                    [-filter <filter>] [-settle <s-time>] 
     \end{verbatim}
  *  The \c \<number> argument specifies the number of data strides to process
  *  before terminating the program. The \c \<time> argument specifies the data
  *  stride.
  *
  *  {\bf {\Large Configuration File}}
  *
  *  DatTemplate uses a fixed configuration. There is therfore no 
  *  configuration file
  *
  *  {\bf {\Large DatTemplate Output}}
  *
  *  {\bf Trend channels}
  *  DatTemplate produces a minute trend of the sigma value called 
  *  #<channel>_sigma#
  *
  *  {\bf Monitor data channels}
  *  DatTemplate publishes a time series history of the sigma values 
  *  with the name #<channel>_sigma#
  *
  *  @author John Zweizig; Caltech/LIGO
  *  @version 2.0; Last modified July 16, 2014
  */
//{
//}

// classdef
class DatTemplate : public DatEnv, MonServer 
{
public:
    DatTemplate(int argc, const char *argv[]);  // Constructor
    ~DatTemplate(void);                         // Destructor
    void ProcessData(void);                     // Process 1 data stride
    void Attention(void);                       // Handle Message signal.
private:
    int         maxFrame;       //  Number of frames to process
    Interval    mStep;          //  Time stride.
    Trend       mTrend;         //  Trend writer
    std::string mChannel;       //  Channel name
    std::string mFilter;        //  Filter description
    Interval    mSettle;        //  Settling time.
    std::string mSigmaName;     //  Channel data and trend name
    auto_pipe   mPipe;          // Pipe pointer
    FixedLenTS  mHistory;       //  X sigma history.
    double      mLowLimit;
    double      mHiLimit;
    bool        mSeg;
    TrigClient  mTClient;
    trig::SegAccountant mSegAcct;
    typedef trig::SegAccountant::seg_id segid_type;
    segid_type mLoSegId;
    segid_type mHiSegId;
};

#endif     //  DatTEMPLATE_HH
