#include "FilterDB.hh"
#include "ParseLine.hh"
#include <fstream>

using namespace std;

//--------------------------------------  Default constructor
FilterDB::FilterDB(void) {
}

//--------------------------------------  Data constructor
FilterDB::FilterDB(const char* file) {
    init(file);
}

//--------------------------------------  Get the specified fiter module
const FilterModule& 
FilterDB::operator[](const std::string& f) const {
    return mMap.find(f)->second;
}

//--------------------------------------  Reset the data base
void 
FilterDB::reset(void) {
    mMap.clear();
}

//--------------------------------------  Initialize the database
void 
FilterDB::init(const char* file) {
    ParseLine pl(file);
    while (pl.getLine() >= 0) {
        if (!pl.getCount()) continue;
        string name   = pl[0];      // Module name
        int    Nstage = pl.getInt(1);
	int    type   = pl.getInt(2);
	int    nSos   = pl.getInt(3);
	int    flags  = pl.getInt(4);
	//	int    token  = pl.getInt(5);
	string Stage  = pl[6];
	double c0     = pl.getDouble(7);
	double c1     = pl.getDouble(8);
	double c2     = pl.getDouble(9);
	double c3     = pl.getDouble(10);
	double c4     = pl.getDouble(11);
	IIRFilter f(16384);
	f *= IIRSos(c0,c1,c2,c3,c4);
	for (int i=1 ; i<nSos ; i++) {
	    pl.getLine();
	    c1 = pl.getDouble(0);
	    c2 = pl.getDouble(1);
	    c3 = pl.getDouble(2);
	    c4 = pl.getDouble(3);
	    f *= IIRSos(1.0, c1, c2, c3, c4);
	}
	mMap[name].addStage(Nstage, FilterStage(Stage.c_str(), type, flags, f));
    }
}

//--------------------------------------  insert a new filter module
void 
FilterDB::insert(const std::string& name, const FilterModule& filter) {
    mMap[name] = filter;
}

