/* -*- mode: c++; c-basic-offset: 4; -*- */

#include "fzstream.hh"
#include <zlib.h>

using namespace std;

namespace gdsbase {

    //==================================  Open a gzipped file.
    void* 
    fzopen(const char* file, ios_base::openmode mode) {
	gzFile rc;
	switch (mode) {
	case ios_base::in:
	    rc = gzopen(file, "rd");
	    break;
	case ios_base::out:
	    rc = gzopen(file, "wd");
	    break;
	default:
	    rc = 0;
	}
	return reinterpret_cast<void*>(rc);
    }

    //==================================  Read data from a gzipped file.
    int
    fzclose(void* fvoid) {
	gzFile file = reinterpret_cast<gzFile>(fvoid);
	return gzclose(file);
    }

    //==================================  Read data from a gzipped file.
    int
    fzread(void* fvoid, char* buf, int length, int size) {
	gzFile file = reinterpret_cast<gzFile>(fvoid);
	int ret = gzread(file, buf, length*size);
	if (ret <= 0) return ret;
	return ret/size;
    }

    //==================================  Seek a specified position
    int
    fzseek(void* fvoid, int off, ios_base::seekdir way, int size) {
	return -1;
    }

    //==================================  Read data from a gzipped file.
    int
    fzwrite(void* fvoid, const char* buf, int length, int size) {
	gzFile file = reinterpret_cast<gzFile>(fvoid);
	int ret = gzwrite(file, buf, length*size);
	if (ret <= 0) return ret;
	return ret/size;
    }

}
