#ifndef VARIABLE_H
#define VARIABLE_H

/*
 * variable.h - mkcf variable info storage.
 * 
 * include LICENSE
 */

#include <appclass.h>

typedef struct _Variable Variable;

struct _Variable {
   AppClass parent;
   char *varname;     /* variable name */
   char *vartype;     /* C type of the var: char * */
   char *desctype;    /* equivalent type in desc table */
   char *varcmt;      /* comment for this variable */
   char *varfunc;     /* name of the function that return the address of variable */
   int index;         /* index in desc table 0 = not visited */
   int tini;          /* this variable need specfic initialization */
   int lineno;        /* line number in userpref.h */
};

/*
 * prototypes
 */
Variable *var_new( char *varname, char *vartype, char *varcmt, int tini,
		   int lineno );
void var_construct( Variable *var, char *varname, char *vartype, char *varcmt,
		    int tini, int lineno );
void var_destroy(void *var);

void var_dup_varfunc( Variable *var, char *prefix);
int var_iter_print_var( AppClass *data, void *user_data );
void var_set_desctype(Variable *var, char *vartype);

int var_name_cmp(AppClass *d1, AppClass *d2 );
int var_varname_cmp(AppClass *d1, AppClass *d2 );

char *var_text2type( char *ctype);

#endif /* VARIABLE_H */
