#ifndef DESCREC_H
#define DESCREC_H

/*
 * descrec.h - mkcf object for conf desc tables and elems
 * 
 * include LICENSE
 */

#include <dlist.h>

typedef struct _DescRecord DescRecord;

struct _DescRecord {
   AppClass parent;
   char *name;          /* table name */
   char *proto;         /* associated proto in frec */
   char *prefix;        /* prefix used for this table */
   DList *elems;        /* list of table entries */
};

/*
 * prototypes
 */
DescRecord *descrec_new( char *name, char *proto, char *prefix );
void descrec_construct( DescRecord *desc, char *name, char *proto, char *prefix );
void descrec_destroy(void *desc);

void descrec_add_elem( DescRecord *desc, char *extTok, char *varfunc,
		       char *desctype, char *desccmt, int lineno );
int descrec_iter_print_elems( AppClass *data, void *user_data );

int descrec_proto_cmp (AppClass *d1, AppClass *d2 );

#endif /* DESCREC_H */
