/*   FILE: fmt_ptrnjni.c --
 * AUTHOR: W. Michael Petullo <new@flyn.org>
 *   DATE: 09 September 2006 
 *
 * Copyright (c) 2006 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <assert.h>
#include <jni.h>
#include <FmtPtrn.h>
#include <stdio.h>
#include <glib.h>
#include <fmt-ptrn/fmt-ptrn.h>

JNIEXPORT void JNICALL
Java_FmtPtrn_init(JNIEnv * env, jobject obj)
{
	static jfieldID fid_lineNum = NULL;
	jclass cls;

	cls = (*env)->GetObjectClass(env, obj);
	fid_lineNum = (*env)->GetFieldID(env, cls, "lineNum", "J");

	if (fid_lineNum == NULL) {
		return;
	}
	(*env)->SetLongField(env, obj, fid_lineNum, 0);
	
	return;
}

JNIEXPORT jobjectArray JNICALL
Java_FmtPtrn_getKeys(JNIEnv * env, jobject obj, jstring p)
{
	int i;
	GList *keys;
	GList *node;
	fmt_ptrn_t fp;
	jobjectArray result = NULL;
	const jbyte *str;
	jclass strArrCls;

	str = (*env)->GetStringUTFChars(env, p, NULL);

	if (str == NULL) {
		goto _return_no_close;
	}

	fmt_ptrn_init(&fp);
	keys = fmt_ptrn_get_keys(&fp, str);	

	(*env)->ReleaseStringUTFChars(env, p, str);

	strArrCls = (*env)->FindClass(env, "java/lang/String");

	if (strArrCls == NULL) {
		goto _return_no_close;
	}

	result = (*env)->NewObjectArray(env, g_list_length(keys), strArrCls,
	                                     NULL);

	for (i = 0; keys != NULL; i++) {
		jstring key;

		node = g_list_first(keys);	
		key = (*env)->NewStringUTF(env, node->data);	

		(*env)->SetObjectArrayElement(env, result, i, key);
		(*env)->DeleteLocalRef(env, key);

		keys = g_list_remove(keys, node->data);
	}
_return:
	fmt_ptrn_close(&fp);
_return_no_close:
	return result;
}
