/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Period;
import java.util.Map;
import oracle.jdbc.driver.json.JsonpGeneratorWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

public abstract class AbstractGenerator
implements OracleJsonGenerator {
    AbstractGenerator() {
    }

    @Override
    public abstract OracleJsonGenerator writeKey(String var1);

    @Override
    public final OracleJsonGenerator writeStartObject(String string) {
        this.writeKey(string);
        this.writeStartObject();
        return this;
    }

    @Override
    public final OracleJsonGenerator writeStartArray(String string) {
        this.writeKey(string);
        return this.writeStartArray();
    }

    @Override
    public final OracleJsonGenerator write(String string, OracleJsonValue oracleJsonValue) {
        this.writeKey(string);
        return this.write(oracleJsonValue);
    }

    @Override
    public final OracleJsonGenerator write(String string, String string2) {
        this.writeKey(string);
        return this.write(string2);
    }

    @Override
    public final OracleJsonGenerator write(String string, BigInteger bigInteger) {
        this.writeKey(string);
        return this.write(bigInteger);
    }

    @Override
    public final OracleJsonGenerator write(String string, BigDecimal bigDecimal) {
        this.writeKey(string);
        return this.write(bigDecimal);
    }

    @Override
    public final OracleJsonGenerator write(String string, int n2) {
        this.writeKey(string);
        return this.write(n2);
    }

    @Override
    public final OracleJsonGenerator write(String string, long l2) {
        this.writeKey(string);
        return this.write(l2);
    }

    @Override
    public final OracleJsonGenerator write(String string, double d2) {
        this.writeKey(string);
        return this.write(d2);
    }

    @Override
    public final OracleJsonGenerator write(String string, float f2) {
        this.writeKey(string);
        return this.write(f2);
    }

    @Override
    public final OracleJsonGenerator write(String string, boolean bl) {
        this.writeKey(string);
        return this.write(bl);
    }

    @Override
    public final OracleJsonGenerator writeNull(String string) {
        this.writeKey(string);
        return this.writeNull();
    }

    @Override
    public OracleJsonGenerator write(String string, Period period) {
        this.writeKey(string);
        return this.write(period);
    }

    @Override
    public OracleJsonGenerator write(String string, Duration duration) {
        this.writeKey(string);
        return this.write(duration);
    }

    protected abstract OracleJsonGenerator writeBinary(OracleJsonBinary var1);

    protected abstract OracleJsonGenerator writeDouble(OracleJsonDouble var1);

    protected abstract OracleJsonGenerator writeFloat(OracleJsonFloat var1);

    protected abstract OracleJsonGenerator writeOraNumber(OracleJsonDecimal var1);

    protected abstract OracleJsonGenerator writeTimestamp(OracleJsonTimestamp var1);

    protected abstract OracleJsonGenerator writeDate(OracleJsonDate var1);

    protected abstract OracleJsonGenerator writeString(OracleJsonString var1);

    protected abstract OracleJsonGenerator writeIntervalDS(OracleJsonIntervalDS var1);

    protected abstract OracleJsonGenerator writeIntervalYM(OracleJsonIntervalYM var1);

    protected abstract void writeStringFromParser(OracleJsonParser var1);

    protected abstract void writeDecimalFromParser(OracleJsonParser var1);

    @Override
    public OracleJsonGenerator write(OracleJsonValue oracleJsonValue) {
        this.writeOracleJsonValue(oracleJsonValue);
        return this;
    }

    private void writeOracleJsonValue(OracleJsonValue oracleJsonValue) {
        switch (oracleJsonValue.getOracleJsonType()) {
            case OBJECT: {
                OracleJsonObject oracleJsonObject = (OracleJsonObject)oracleJsonValue;
                this.writeStartObject();
                for (Map.Entry entry : oracleJsonObject.entrySet()) {
                    this.writeKey((String)entry.getKey());
                    this.writeOracleJsonValue((OracleJsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case ARRAY: {
                OracleJsonArray oracleJsonArray = (OracleJsonArray)oracleJsonValue;
                this.writeStartArray();
                for (OracleJsonValue oracleJsonValue2 : oracleJsonArray) {
                    this.writeOracleJsonValue(oracleJsonValue2);
                }
                this.writeEnd();
                break;
            }
            case BINARY: {
                this.writeBinary((OracleJsonBinary)oracleJsonValue);
                break;
            }
            case FLOAT: {
                this.writeFloat((OracleJsonFloat)oracleJsonValue);
                break;
            }
            case DOUBLE: {
                this.writeDouble((OracleJsonDouble)oracleJsonValue);
                break;
            }
            case DECIMAL: {
                this.writeOraNumber((OracleJsonDecimal)oracleJsonValue);
                break;
            }
            case STRING: {
                this.writeString((OracleJsonString)oracleJsonValue);
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp((OracleJsonTimestamp)oracleJsonValue);
                break;
            }
            case DATE: {
                this.writeDate((OracleJsonDate)oracleJsonValue);
                break;
            }
            case INTERVALDS: {
                this.writeIntervalDS((OracleJsonIntervalDS)oracleJsonValue);
                break;
            }
            case INTERVALYM: {
                this.writeIntervalYM((OracleJsonIntervalYM)oracleJsonValue);
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
    }

    @Override
    public OracleJsonGenerator writeParser(Object object) {
        if (object instanceof OracleJsonParser) {
            this.writeOracleJsonParser((OracleJsonParser)object);
            return this;
        }
        this.wrap(JsonpGeneratorWrapper.class).writeJsonParser(object);
        return this;
    }

    private void writeOracleJsonParser(OracleJsonParser oracleJsonParser) {
        block18: while (oracleJsonParser.hasNext()) {
            switch (oracleJsonParser.next()) {
                case START_OBJECT: {
                    this.writeStartObject();
                    continue block18;
                }
                case START_ARRAY: {
                    this.writeStartArray();
                    continue block18;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    this.writeEnd();
                    continue block18;
                }
                case KEY_NAME: {
                    this.writeKey(oracleJsonParser.getString());
                    continue block18;
                }
                case VALUE_STRING: {
                    this.writeStringFromParser(oracleJsonParser);
                    continue block18;
                }
                case VALUE_TRUE: {
                    this.write(true);
                    continue block18;
                }
                case VALUE_FALSE: {
                    this.write(false);
                    continue block18;
                }
                case VALUE_NULL: {
                    this.writeNull();
                    continue block18;
                }
                case VALUE_BINARY: {
                    this.writeBinary(oracleJsonParser.getValue().asJsonBinary());
                    continue block18;
                }
                case VALUE_DATE: {
                    this.writeDate(oracleJsonParser.getValue().asJsonDate());
                    continue block18;
                }
                case VALUE_DECIMAL: {
                    this.writeDecimalFromParser(oracleJsonParser);
                    continue block18;
                }
                case VALUE_DOUBLE: {
                    this.write(oracleJsonParser.getDouble());
                    continue block18;
                }
                case VALUE_FLOAT: {
                    this.write(oracleJsonParser.getFloat());
                    continue block18;
                }
                case VALUE_INTERVALDS: {
                    this.writeIntervalDS(oracleJsonParser.getValue().asJsonIntervalDS());
                    continue block18;
                }
                case VALUE_INTERVALYM: {
                    this.writeIntervalYM(oracleJsonParser.getValue().asJsonIntervalYM());
                    continue block18;
                }
                case VALUE_TIMESTAMP: {
                    this.writeTimestamp(oracleJsonParser.getValue().asJsonTimestamp());
                    continue block18;
                }
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        try {
            return clazz.cast(new JsonpGeneratorWrapper(this));
        }
        catch (ClassCastException classCastException) {
            throw OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, classCastException, clazz.getName());
        }
    }
}

